/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;

public class BotpMutexValidator
extends AbstractValidator {
    public static final String DEFAULT_GROUPID = "default_netctrl";
    private String relationKey;

    public void setRelationKey(String relationKey) {
        this.relationKey = relationKey;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.setEntityKey(this.relationKey);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            QFilter qFilter = new QFilter("srcfinbillid", "=", obj.getPkValue());
            DynamicObjectCollection linkBills = QueryServiceHelper.query((String)this.relationKey, (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (ObjectUtils.isEmpty((Object)linkBills)) continue;
            this.chkMutex(dataEntity, linkBills);
        }
    }

    private void chkMutex(ExtendedDataEntity dataEntity, DynamicObjectCollection linkBills) {
        StringBuilder sb = new StringBuilder();
        int size = linkBills.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject linkBill = (DynamicObject)linkBills.get(i);
            String objId = String.valueOf(linkBill.getLong("id"));
            if (i < size - 1) {
                sb.append('\'').append(objId).append('\'').append(", \n");
                continue;
            }
            sb.append('\'').append(objId).append('\'');
        }
        StringBuilder querySQL = new StringBuilder();
        querySQL.append("select Count(FID) as count from T_Mutex_DataLock where FEntityKey = ? and FGroupID = ? and FObjectID IN (").append((CharSequence)sb).append(") ");
        Object[] params = new Object[]{this.relationKey, DEFAULT_GROUPID};
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)BotpMutexValidator.class.getName(), (DBRoute)DBRouteConst.BASEDATA, (String)querySQL.toString(), (Object[])params);){
            Iterator rowIterator = ds.iterator();
            if (rowIterator != null) {
                while (rowIterator.hasNext()) {
                    Row data = (Row)rowIterator.next();
                    count = data.getInteger("count");
                }
            }
        }
        if (count > 0) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.relationKey);
            String msg = String.format(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\uff1a%s \uff0c\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BotpMutexValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), dt.getDisplayName().getLocaleValue());
            this.addMessage(dataEntity, msg);
        }
    }
}

