/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.DateUtils;

public class CasPayDateValidator
implements IOthersExecCtrlService {
    private static final Log logger = LogFactory.getLog(CasPayDateValidator.class);

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selector = new HashSet<String>(8);
        selector.add("id");
        selector.add("paydate");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("entry.settleorg");
        selector.add("entry.e_paymenttype");
        selector.add("entry.seq");
        return selector;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] others) {
        DynamicObject[] initInfos;
        HashMap<Long, String> result = new HashMap<Long, String>(others.length);
        HashMap<Long, String> orgIdNameMap = new HashMap<Long, String>(8);
        for (DynamicObject info : others) {
            DynamicObjectCollection entryCol = info.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entryCol) {
                DynamicObject orgInfo = entryInfo.getDynamicObject("settleorg");
                if (orgInfo == null) continue;
                orgIdNameMap.put(orgInfo.getLong("id"), orgInfo.getString("name"));
            }
        }
        HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>(8);
        for (DynamicObject initInfo : initInfos = BusinessDataServiceHelper.load((String)"ap_init", (String)"org,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdNameMap.keySet())})) {
            currentDateMap.put(initInfo.getLong("org.id"), initInfo.getDate("currentdate"));
        }
        HashMap casParamMap = new HashMap(8);
        for (DynamicObject info : others) {
            String billNo = info.getString("billno");
            DynamicObjectCollection entryCol = info.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entryCol) {
                DynamicObject e_PayMentTypeInfo = entryInfo.getDynamicObject("e_paymenttype");
                if (e_PayMentTypeInfo == null || !e_PayMentTypeInfo.getBoolean("ispartpayment")) continue;
                Long orgId = entryInfo.getLong("settleorg.id");
                Object casParam = casParamMap.get(orgId);
                if (ObjectUtils.isEmpty(casParam)) {
                    casParam = SystemParameterHelper.getCasParam(orgId, "cs104");
                    casParamMap.put(orgId, casParam);
                }
                Date payDate = null;
                payDate = Objects.equals(casParam, "2") ? info.getDate("paydate") : info.getDate("bizdate");
                Date currentDate = (Date)currentDateMap.get(orgId);
                if (payDate == null || currentDate == null || DateUtils.getDiffDays(payDate, currentDate) <= 0 || result.size() >= 5) continue;
                result.put(entryInfo.getLong("id"), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u4ed8\u6b3e\u660e\u7ec6\u7b2c[%2$s]\u884c\u7ed3\u7b97\u7ec4\u7ec7[%3$s]\u5bf9\u5e94\u7684\u5e94\u4ed8\u671f\u95f4\u5df2\u7ecf\u5173\u8d26\uff0c\u8bf7\u5148\u5728\u5e94\u4ed8\u7cfb\u7edf\u53cd\u5173\u8d26\uff0c\u518d\u6267\u884c\u64cd\u4f5c\u3002", (String)"CasPayDateValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, entryInfo.getInt("seq"), orgIdNameMap.get(orgId)));
            }
        }
        return result;
    }
}

