/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.BOTPNewHelper;

public class CasPayPaymentValidator
implements IOthersExecCtrlService {
    private static final Log logger = LogFactory.getLog(CasPayPaymentValidator.class);

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selector = new HashSet<String>(8);
        selector.add("paymenttype");
        selector.add("sourcebilltype");
        selector.add("entry.e_paymenttype");
        return selector;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] others) {
        logger.info("CasPayPaymentValidator start");
        HashMap<Long, String> result = new HashMap<Long, String>(others.length);
        ArrayList<DynamicObject> casPayBills = new ArrayList<DynamicObject>(64);
        for (DynamicObject casPay : others) {
            String sourceBillType = casPay.getString("sourcebilltype");
            DynamicObjectCollection entry = casPay.getDynamicObjectCollection("entry");
            boolean isAllPartPayment = Boolean.TRUE;
            for (DynamicObject row : entry) {
                DynamicObject paymentType = row.getDynamicObject("e_paymenttype");
                if (!ObjectUtils.isEmpty((Object)paymentType) && paymentType.getBoolean("ispartpayment")) continue;
                isAllPartPayment = Boolean.FALSE;
                break;
            }
            if (isAllPartPayment || ObjectUtils.isEmpty((Object)sourceBillType) || "ap_finapbill".equals(sourceBillType) || "ar_finarbill".equals(sourceBillType) || !sourceBillType.contains("ar_") && !sourceBillType.contains("ap_")) continue;
            casPayBills.add(casPay);
        }
        if (ObjectUtils.isEmpty(casPayBills)) {
            return result;
        }
        Map<Object, Object> finApRelationMap = new HashMap(8);
        Map<Object, Object> finArRelationMap = new HashMap(8);
        ArrayList<Long> casPayBillIds = new ArrayList<Long>(64);
        ArrayList<Long> casPayRowIds = new ArrayList<Long>(64);
        for (DynamicObject casPayBill : casPayBills) {
            casPayBillIds.add(casPayBill.getLong("id"));
            DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                casPayRowIds.add(row.getLong("id"));
            }
        }
        finApRelationMap = BOTPNewHelper.loadNearSourceBillIds("cas_paybill", "entry", casPayBillIds.toArray(new Long[0]), casPayRowIds.toArray(new Long[0]), "ap_finapbill");
        casPayBillIds.removeIf(finApRelationMap::containsKey);
        if (!ObjectUtils.isEmpty(casPayBillIds)) {
            finArRelationMap = BOTPNewHelper.loadNearSourceBillIds("cas_paybill", "entry", casPayBillIds.toArray(new Long[0]), casPayRowIds.toArray(new Long[0]), "ar_finarbill");
        }
        for (DynamicObject casPayBill : casPayBills) {
            long capPayBillId = casPayBill.getLong("id");
            if (!ObjectUtils.isEmpty((Object)finApRelationMap.get(capPayBillId))) {
                result.put(capPayBillId, ResManager.loadKDString((String)"\u3010\u4e8b\u4e2d\u76d1\u63a7\u3011\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4e3a\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u4ed8\u6b3e\u5355\u5206\u5f55.\u4ed8\u6b3e\u7c7b\u578b\u9700\u5168\u90e8\u53c2\u4e0e\u7ed3\u7b97\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CasPayPaymentValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                continue;
            }
            if (ObjectUtils.isEmpty((Object)finArRelationMap.get(capPayBillId))) continue;
            result.put(capPayBillId, ResManager.loadKDString((String)"\u3010\u4e8b\u4e2d\u76d1\u63a7\u3011\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4e3a\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u4ed8\u6b3e\u5355\u5206\u5f55.\u4ed8\u6b3e\u7c7b\u578b\u9700\u5168\u90e8\u53c2\u4e0e\u7ed3\u7b97\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CasPayPaymentValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        logger.info("CasPayPaymentValidator end");
        return result;
    }
}

