/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;

public class CasPaySettleOrgValidator
implements IOthersExecCtrlService {
    private static final Log logger = LogFactory.getLog(CasPaySettleOrgValidator.class);

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("entry.settleorg");
        selectors.add("entry.e_sourcebillid");
        selectors.add("sourcebilltype");
        return selectors;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] others) {
        logger.info("CasPaySettleOrgValidator validate begin");
        HashSet<Long> finApBillIds = new HashSet<Long>(64);
        HashSet<Long> finArBillIds = new HashSet<Long>(64);
        HashSet<Long> applyBillIds = new HashSet<Long>(64);
        for (DynamicObject other : others) {
            String sourceBillType = other.getString("sourcebilltype");
            if (!"ap_finapbill".equals(sourceBillType) && !"ar_finarbill".equals(sourceBillType) && !"ap_payapply".equals(sourceBillType)) continue;
            DynamicObjectCollection entry = other.getDynamicObjectCollection("entry");
            for (DynamicObject detail : entry) {
                long eSourceBillId = detail.getLong("e_sourcebillid");
                if ("ap_finapbill".equals(sourceBillType)) {
                    finApBillIds.add(eSourceBillId);
                    continue;
                }
                if ("ar_finarbill".equals(sourceBillType)) {
                    finArBillIds.add(eSourceBillId);
                    continue;
                }
                applyBillIds.add(eSourceBillId);
            }
        }
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        if (finApBillIds.isEmpty() && finArBillIds.isEmpty() && applyBillIds.isEmpty()) {
            return result;
        }
        HashMap<Long, Long> srcBillOrgMap = new HashMap<Long, Long>(64);
        if (!finApBillIds.isEmpty()) {
            DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap_org", (String)"ap_finapbill", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)}, (String)"");
            for (Row finApRow : finApDataSet) {
                srcBillOrgMap.put(finApRow.getLong("id"), finApRow.getLong("org"));
            }
        }
        if (!finArBillIds.isEmpty()) {
            DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"query_finar_org", (String)"ar_finarbill", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)}, (String)"");
            for (Row finArRow : finArDataSet) {
                srcBillOrgMap.put(finArRow.getLong("id"), finArRow.getLong("org"));
            }
        }
        if (!applyBillIds.isEmpty()) {
            DataSet ApplyDataSet = QueryServiceHelper.queryDataSet((String)"query_apply_org", (String)"ap_payapply", (String)"id,settleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillIds)}, (String)"");
            for (Row applyRow : ApplyDataSet) {
                srcBillOrgMap.put(applyRow.getLong("id"), applyRow.getLong("settleorg"));
            }
        }
        block5: for (DynamicObject other : others) {
            String sourceBillType = other.getString("sourcebilltype");
            if (!"ap_finapbill".equals(sourceBillType) && !"ar_finarbill".equals(sourceBillType) && !"ap_payapply".equals(sourceBillType)) continue;
            long payBillId = other.getLong("id");
            DynamicObjectCollection entry = other.getDynamicObjectCollection("entry");
            for (DynamicObject detail : entry) {
                long settleOrgId = detail.getLong("settleorg.id");
                Long srcOrgId = (Long)srcBillOrgMap.get(detail.getLong("e_sourcebillid"));
                if (srcOrgId != null && srcOrgId == settleOrgId) continue;
                String entityName = "ap_finapbill".equals(sourceBillType) ? ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"CasPaySettleOrgValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]) : ("ar_finarbill".equals(sourceBillType) ? ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355", (String)"CasPaySettleOrgValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355", (String)"CasPaySettleOrgValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                result.put(payBillId, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4e3a%1$s\uff0c\u4ed8\u6b3e\u660e\u7ec6\u7ed3\u7b97\u7ec4\u7ec7\u9700\u4e0e\u4e0a\u6e38\u5355\u636e\u7ed3\u7b97\u7ec4\u7ec7\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u540e\u4fee\u6539\u3002", (String)"CasPaySettleOrgValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), entityName));
                continue block5;
            }
        }
        logger.info("CasPaySettleOrgValidator validate end");
        return result;
    }
}

