/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.BOTPHelper;

public class CasPaySrcFinHadWrittenOffValidator
implements IOthersExecCtrlService {
    private static final Log logger = LogFactory.getLog(CasPaySrcFinHadWrittenOffValidator.class);

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("id");
        selectors.add("entry.seq");
        selectors.add("entry.e_sourcebillid");
        selectors.add("sourcebilltype");
        return selectors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<Long, String> validate(DynamicObject[] payBills) {
        void var12_29;
        DynamicObjectCollection entrys;
        logger.info("CasPaySrcFinHadWrittenOffValidator validate begin");
        HashSet<Long> finApBillIds = new HashSet<Long>(64);
        HashSet<Long> finArBillIds = new HashSet<Long>(64);
        HashSet<Long> applyBillIds = new HashSet<Long>(64);
        HashSet<Long> hadWrittenOffBillIds = new HashSet<Long>(64);
        HashMap<Long, Long> casPayEntryIdToFinIdMap = new HashMap<Long, Long>(64);
        ArrayList<Long> casPayBillIds = new ArrayList<Long>(64);
        ArrayList<Long> casPayEntryIds = new ArrayList<Long>(64);
        for (DynamicObject dynamicObject : payBills) {
            String string = dynamicObject.getString("sourcebilltype");
            long payBillId = dynamicObject.getLong("id");
            entrys = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                long entryid = entry.getLong("id");
                long eSourceBillId = entry.getLong("e_sourcebillid");
                if ("ap_finapbill".equals(string)) {
                    finApBillIds.add(eSourceBillId);
                    casPayEntryIdToFinIdMap.put(entryid, eSourceBillId);
                }
                if ("ar_finarbill".equals(string)) {
                    finArBillIds.add(eSourceBillId);
                    casPayEntryIdToFinIdMap.put(entryid, eSourceBillId);
                }
                if (!"ap_payapply".equals(string)) continue;
                applyBillIds.add(eSourceBillId);
                casPayBillIds.add(payBillId);
                casPayEntryIds.add(entryid);
            }
        }
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        if (finApBillIds.isEmpty() && finArBillIds.isEmpty() && applyBillIds.isEmpty()) {
            return result;
        }
        if (!applyBillIds.isEmpty()) {
            Map<Long, BFRowId> srcFinApBFRowMap = BOTPHelper.loadNearSrcBFRowIdMap("cas_paybill", "entry", casPayBillIds.toArray(new Long[0]), casPayEntryIds.toArray(new Long[0]), "ap_finapbill");
            for (Map.Entry<Long, BFRowId> entry : srcFinApBFRowMap.entrySet()) {
                Long l = entry.getKey();
                BFRowId finApBFRow = entry.getValue();
                Long finApBillId = finApBFRow.getBillId();
                casPayEntryIdToFinIdMap.put(l, finApBillId);
                finApBillIds.add(finApBillId);
            }
            casPayEntryIds.removeIf(srcFinApBFRowMap::containsKey);
            if (!ObjectUtils.isEmpty(casPayEntryIds)) {
                Map<Long, BFRowId> srcFinArBFRowMap = BOTPHelper.loadNearSrcBFRowIdMap("cas_paybill", "entry", casPayBillIds.toArray(new Long[0]), casPayEntryIds.toArray(new Long[0]), "ar_finarbill");
                for (Map.Entry<Long, BFRowId> entry : srcFinArBFRowMap.entrySet()) {
                    Long payEntryId = entry.getKey();
                    BFRowId finArBFRow = entry.getValue();
                    Long finArBillId = finArBFRow.getBillId();
                    casPayEntryIdToFinIdMap.put(payEntryId, finArBillId);
                    finArBillIds.add(finArBillId);
                }
            }
        }
        if (!finApBillIds.isEmpty()) {
            DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap_org", (String)"ap_finapbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)}, (String)"");
            for (Row row : finApDataSet) {
                if (!row.getBoolean("hadwrittenoff").booleanValue()) continue;
                hadWrittenOffBillIds.add(row.getLong("id"));
            }
        }
        if (!finArBillIds.isEmpty()) {
            DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"query_finar_org", (String)"ar_finarbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)}, (String)"");
            for (Row row : finArDataSet) {
                if (!row.getBoolean("hadwrittenoff").booleanValue()) continue;
                hadWrittenOffBillIds.add(row.getLong("id"));
            }
        }
        if (hadWrittenOffBillIds.size() == 0) {
            return result;
        }
        DynamicObject[] dynamicObjectArray = payBills;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var12_29 < n) {
            DynamicObject dynamicObject = dynamicObjectArray[var12_29];
            long payBillId = dynamicObject.getLong("id");
            entrys = dynamicObject.getDynamicObjectCollection("entry");
            HashSet<String> errSeq = new HashSet<String>(entrys.size());
            for (DynamicObject entry : entrys) {
                long entryid = entry.getLong("id");
                Long srcFinId = (Long)casPayEntryIdToFinIdMap.get(entryid);
                String seq = entry.getString("seq");
                if (!hadWrittenOffBillIds.contains(srcFinId)) continue;
                errSeq.add(seq);
            }
            if (errSeq.size() > 0) {
                result.put(payBillId, String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4e0a\u6e38\u5b58\u5728\u5df2\u88ab\u51b2\u9500\u7684\u8d22\u52a1\u5355\uff0c\u8bf7\u5220\u9664\u4ed8\u6b3e\u5355\u5e76\u901a\u8fc7\u91cd\u65b0\u786e\u8ba4\u7684\u8d22\u52a1\u5355\u53d1\u8d77\u4ed8\u6b3e\uff0c\u6216\u5220\u9664\u4ed8\u6b3e\u5355\u4e0a\u5df2\u7ecf\u88ab\u51b2\u9500\u7684\u660e\u7ec6\u7b2c%1$s\u884c\u540e\u91cd\u8bd5\u3002\u5982\u9700\u68c0\u67e5\u5355\u636e\uff0c\u8bf7\u4e0a\u67e5\u6216\u67e5\u770b\u5355\u636e\u5173\u7cfb\u56fe\u3002", (String)"CasPaySrcFinHadWrittenOffValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), String.join((CharSequence)",", errSeq)));
            }
            ++var12_29;
        }
        logger.info("CasPaySrcFinHadWrittenOffValidator validate end");
        return result;
    }
}

