/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class CasRecReceivableValidator
implements IOthersExecCtrlService {
    private static final Log logger = LogFactory.getLog(CasRecReceivableValidator.class);

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selector = new HashSet<String>(8);
        selector.add("receivingtype");
        selector.add("sourcebilltype");
        selector.add("entry.e_receivingtype");
        return selector;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] others) {
        logger.info("CasRecReceivableValidator start");
        HashMap<Long, String> result = new HashMap<Long, String>(others.length);
        ArrayList<DynamicObject> casRecBills = new ArrayList<DynamicObject>(64);
        for (DynamicObject casRec : others) {
            String sourceBillType = casRec.getString("sourcebilltype");
            DynamicObjectCollection entry = casRec.getDynamicObjectCollection("entry");
            boolean isPartReceivable = Boolean.TRUE;
            for (DynamicObject row : entry) {
                DynamicObject receivingType = row.getDynamicObject("e_receivingtype");
                if (!ObjectUtils.isEmpty((Object)receivingType) && receivingType.getBoolean("ispartreceivable")) continue;
                isPartReceivable = Boolean.FALSE;
                break;
            }
            if (isPartReceivable || StringUtils.isEmpty(sourceBillType) || !sourceBillType.contains("ar_") && !sourceBillType.contains("ap_")) continue;
            casRecBills.add(casRec);
        }
        if (EmptyUtils.isEmpty(casRecBills)) {
            return result;
        }
        Map<Object, Object> finArRelationMap = new HashMap(8);
        Map<Object, Object> finApRelationMap = new HashMap(8);
        ArrayList<Long> casRecBillIds = new ArrayList<Long>(64);
        ArrayList<Long> casRecRowIds = new ArrayList<Long>(64);
        for (DynamicObject casRecBill : casRecBills) {
            casRecBillIds.add(casRecBill.getLong("id"));
            DynamicObjectCollection entry = casRecBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                casRecRowIds.add(row.getLong("id"));
            }
        }
        finArRelationMap = BOTPNewHelper.loadNearSourceBillIds("cas_recbill", "entry", casRecBillIds.toArray(new Long[0]), casRecRowIds.toArray(new Long[0]), "ar_finarbill");
        casRecBillIds.removeIf(finArRelationMap::containsKey);
        if (EmptyUtils.isNotEmpty(casRecBillIds)) {
            finApRelationMap = BOTPNewHelper.loadNearSourceBillIds("cas_recbill", "entry", casRecBillIds.toArray(new Long[0]), casRecRowIds.toArray(new Long[0]), "ar_finarbill");
        }
        for (DynamicObject casRecBill : others) {
            long casRecBillId = casRecBill.getLong("id");
            if (EmptyUtils.isNotEmpty(finArRelationMap.get(casRecBillId))) {
                result.put(casRecBillId, ResManager.loadKDString((String)"\u3010\u4e8b\u4e2d\u76d1\u63a7\u3011\u6536\u6b3e\u5355\u4e0a\u6e38\u4e3a\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u6536\u6b3e\u5355\u5206\u5f55.\u6536\u6b3e\u7c7b\u578b\u9700\u5168\u90e8\u53c2\u4e0e\u7ed3\u7b97\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CasRecReceivableValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                continue;
            }
            if (!EmptyUtils.isNotEmpty(finApRelationMap.get(casRecBillId))) continue;
            result.put(casRecBillId, ResManager.loadKDString((String)"\u3010\u4e8b\u4e2d\u76d1\u63a7\u3011\u6536\u6b3e\u5355\u4e0a\u6e38\u4e3a\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u6536\u6b3e\u5355\u5206\u5f55.\u6536\u6b3e\u7c7b\u578b\u9700\u5168\u90e8\u53c2\u4e0e\u7ed3\u7b97\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CasRecReceivableValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        logger.info("CasRecReceivableValidator end");
        return result;
    }
}

