/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;

public class CasRecSrcFinHadWrittenOffValidator
implements IOthersExecCtrlService {
    private static final Log logger = LogFactory.getLog(CasRecSrcFinHadWrittenOffValidator.class);

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("id");
        selectors.add("entry.e_sourcebillid");
        selectors.add("entry.seq");
        selectors.add("sourcebilltype");
        return selectors;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] recBills) {
        logger.info("CasRecSrcFinHadWrittenOffValidator validate begin");
        HashSet<Long> finArBillIds = new HashSet<Long>(64);
        HashSet<Long> hadWrittenOffBillIds = new HashSet<Long>(64);
        HashMap<Long, Long> casPayEntryIdToFinIdMap = new HashMap<Long, Long>(8);
        for (DynamicObject payBill : recBills) {
            String sourceBillType = payBill.getString("sourcebilltype");
            if (!"ar_finarbill".equals(sourceBillType)) continue;
            DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                long entryid = entry.getLong("id");
                long eSourceBillId = entry.getLong("e_sourcebillid");
                finArBillIds.add(eSourceBillId);
                casPayEntryIdToFinIdMap.put(entryid, eSourceBillId);
            }
        }
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        if (finArBillIds.isEmpty()) {
            return result;
        }
        DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"query_finar_org", (String)"ar_finarbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)}, (String)"");
        for (Row finArRow : finArDataSet) {
            if (!finArRow.getBoolean("hadwrittenoff").booleanValue()) continue;
            hadWrittenOffBillIds.add(finArRow.getLong("id"));
        }
        if (hadWrittenOffBillIds.size() == 0) {
            return result;
        }
        for (DynamicObject payBill : recBills) {
            long payBillId = payBill.getLong("id");
            DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
            HashSet<String> errSeq = new HashSet<String>(entrys.size());
            for (DynamicObject entry : entrys) {
                long entryid = entry.getLong("id");
                Long srcFinId = (Long)casPayEntryIdToFinIdMap.get(entryid);
                String seq = entry.getString("seq");
                if (!hadWrittenOffBillIds.contains(srcFinId)) continue;
                errSeq.add(seq);
            }
            if (errSeq.size() <= 0) continue;
            result.put(payBillId, String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4e0a\u6e38\u5b58\u5728\u5df2\u88ab\u51b2\u9500\u7684\u8d22\u52a1\u5355\uff0c\u8bf7\u5220\u9664\u6536\u6b3e\u5355\u5e76\u901a\u8fc7\u91cd\u65b0\u786e\u8ba4\u7684\u8d22\u52a1\u5355\u53d1\u8d77\u6536\u6b3e\uff0c\u6216\u5220\u9664\u6536\u6b3e\u5355\u4e0a\u5df2\u7ecf\u88ab\u51b2\u9500\u7684\u660e\u7ec6\u7b2c%1$s\u884c\u540e\u91cd\u8bd5\u3002\u5982\u9700\u68c0\u67e5\u5355\u636e\uff0c\u8bf7\u4e0a\u67e5\u6216\u67e5\u770b\u5355\u636e\u5173\u7cfb\u56fe\u3002", (String)"CasRecSrcFinHadWrittenOffValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), String.join((CharSequence)",", errSeq)));
        }
        logger.info("CasRecSrcFinHadWrittenOffValidator validate end");
        return result;
    }
}

