/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.CloseAccountHelper;

public class CloseAccountValidatorBase
extends AbstractValidator {
    protected Date closeDate;

    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
    }

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        if (datas.length <= 0) {
            return;
        }
        ArrayList<DynamicObject> dataSaves = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject closeAccountsInfo = datas[i].getDataEntity();
            DynamicObject org = closeAccountsInfo.getDynamicObject("org");
            boolean isFinishInit = closeAccountsInfo.getBoolean("isfinishinit");
            if (!isFinishInit) {
                String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u8fdb\u884c\u5173\u8d26\u64cd\u4f5c\u3002", (String)"CloseAccountValidatorBase_0", (String)"fi-arapcommon", (Object[])new Object[0]), org.getString("name"));
                this.addErrorMessage(datas[i], message);
                continue;
            }
            Date currentDate = closeAccountsInfo.getDate("currentdate");
            if (this.closeDate.before(currentDate)) {
                String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5173\u8d26\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8be5\u7ec4\u7ec7\u5f53\u524d\u65e5\u671f\u3002", (String)"CloseAccountValidatorBase_1", (String)"fi-arapcommon", (Object[])new Object[0]), org.getString("name"));
                this.addErrorMessage(datas[i], message);
                continue;
            }
            List<Map<String, Object>> allValidateInfos = CloseAccountHelper.getAllValidateInfos(true, (Long)org.getPkValue(), this.closeDate, currentDate);
            if (!allValidateInfos.isEmpty()) {
                CloseAccountHelper.bindFailedInfoToEntityEntry(closeAccountsInfo, allValidateInfos);
                boolean isNotExistSimBill = false;
                for (Map<String, Object> info : allValidateInfos) {
                    String entityNum = (String)info.get("entityKey");
                    if ("sim_original_bill".equals(entityNum)) {
                        String message = String.format(ResManager.loadKDString((String)"\u5173\u8d26\u65e5\u671f\u4e4b\u524d\uff0c\u7ec4\u7ec7\u201c%s\u201d\u5b58\u5728\u5df2\u5f00\u7968\u672a\u786e\u8ba4\u5e94\u6536\u7684\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u8bf7\u5173\u6ce8\u5e94\u6536\u662f\u5426\u5165\u8d26\u3002", (String)"CloseAccountValidatorBase_3", (String)"fi-arapcommon", (Object[])new Object[0]), closeAccountsInfo.getDynamicObject("org").getLocaleString("name"));
                        this.addErrorMessage(datas[i], message);
                        continue;
                    }
                    isNotExistSimBill = true;
                }
                if (isNotExistSimBill) {
                    String message = String.format(ResManager.loadKDString((String)"\u5173\u8d26\u65e5\u671f\u4e4b\u524d\uff0c\u7ec4\u7ec7\u201c%s\u201d\u5b58\u5728\u672a\u5ba1\u6279\u7684\u5355\u636e\u6216\u5df2\u5ba1\u6279\u4f46\u73b0\u9500\u672a\u7ed3\u7b97\u7684\u5355\u636e\uff0c\u65e0\u6cd5\u5173\u8d26\u3002", (String)"CloseAccountValidatorBase_2", (String)"fi-arapcommon", (Object[])new Object[0]), closeAccountsInfo.getDynamicObject("org").getLocaleString("name"));
                    this.addErrorMessage(datas[i], message);
                }
            }
            dataSaves.add(closeAccountsInfo);
        }
        SaveServiceHelper.save((IDataEntityType)datas[0].getDataEntity().getDataEntityType(), (Object[])dataSaves.toArray());
    }
}

