/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DecimalScopeValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(DecimalScopeValidator.class);

    public void validate() {
        try {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                this.validate0(bill, dataEntity);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void validate(DynamicObject bill) {
        this.validate0(bill, null);
    }

    private void validate0(DynamicObject bill, ExtendedDataEntity dataEntity) {
        IDataEntityType dataEntityType = bill.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        block0: for (IDataEntityProperty prop : properties) {
            if (prop instanceof AmountProp) {
                Object value = prop.getValueFast((Object)bill);
                if (this.check(prop, value, 0, dataEntity)) continue;
                break;
            }
            if (!(prop instanceof EntryProp)) continue;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(prop.getName());
            DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
            for (IDataEntityProperty entryProp : entryProperties) {
                if (!(entryProp instanceof AmountProp)) continue;
                for (int i = 0; i < entry.size(); ++i) {
                    Object value = entryProp.getValueFast(entry.get(i));
                    if (!this.check(entryProp, value, i, dataEntity)) break block0;
                }
            }
        }
    }

    private boolean check(IDataEntityProperty prop, Object value, int index, ExtendedDataEntity dataEntity) {
        int realScale;
        if (!(value instanceof BigDecimal)) {
            return true;
        }
        int precision = ((DecimalProp)prop).getPrecision();
        int scale = ((DecimalProp)prop).getScale();
        int truncPrecison = precision - scale;
        if (precision <= 0 || scale <= 0) {
            return true;
        }
        int realPrecision = ((BigDecimal)value).precision();
        int realTruncPrecision = realPrecision - (realScale = ((BigDecimal)value).scale());
        if (realTruncPrecision > truncPrecison) {
            String message = null;
            IDataEntityType parent = prop.getParent();
            if (parent instanceof EntryType) {
                String errorMessageTemplate = ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\uff0c%3$s\u8d85\u8fc7\u7cfb\u7edf\u5141\u8bb8\u7684\u6700\u5927\u503c\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6b63\u5f55\u5165\u7684\u6570\u636e\u3002", (String)"DecimalScopeValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]);
                message = String.format(errorMessageTemplate, parent.getDisplayName().getLocaleValue(), index + 1, prop.getDisplayName().getLocaleValue());
            } else {
                String errorMessageTemplate = ResManager.loadKDString((String)"%s\u8d85\u8fc7\u7cfb\u7edf\u5141\u8bb8\u7684\u6700\u5927\u503c\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6b63\u5f55\u5165\u7684\u6570\u636e\u3002", (String)"DecimalScopeValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]);
                message = String.format(errorMessageTemplate, prop.getDisplayName().getLocaleValue());
            }
            if (dataEntity == null) {
                throw new KDBizException(message);
            }
            this.addErrorMessage(dataEntity, message);
            return false;
        }
        return true;
    }
}

