/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class GlImportSchemeSaveValidator
extends AbstractValidator {
    private static final String E_MAPPINGFIELDNAME = "e_mappingfieldname";
    private static final String E_MAPPINGFIELD = "e_mappingfield";
    private static final String E_ENTITYOBJECT = "e_entityobject";
    private static final String E_BIZTYPE = "e_biztype";
    private static final String E_LINETYPE = "e_linetype";
    private static final String E_BILLTYPE = "e_billtype";
    private static final String E_MATERIAL = "e_material";
    private static final String E_ASSTACTITEM = "e_asstactitem";
    private static final String E_EXPENSEITEM = "e_expenseitem";
    private static final String E_APPAYPROPERTY = "e_appayproperty";
    private static final String E_ARPAYPROPERTY = "e_arpayproperty";
    private static final String E_BALANCETYPE = "e_balancetype";
    private static final String E_PAYMENTTYPE = "e_paymenttype";
    private static final String E_RECTYPE = "e_rectype";

    public void validate() {
        Map billTypeEntities = BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id,number,fieldcontrolentry.fieldkey,fieldcontrolentry.mustinput", (QFilter[])new QFilter[]{new QFilter("billformid", "in", this.getBillEntitySet())});
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entry");
            Map<String, String> fieldNameMapping = this.getfieldNameMapping(entries);
            String appid = data.getString("appid");
            long orgId = data.getLong("useorg.id");
            boolean isLineType = LineTypeHelper.getParam(orgId, "ar".equals(appid));
            for (DynamicObject entry : entries) {
                String seq = entry.getString("seq");
                this.mustInputCheck(dataEntity, fieldNameMapping, isLineType, billTypeEntities, entry, seq);
                this.asstactTypeCheck(dataEntity, entry, seq);
                this.billInfoDuplicateCheck(dataEntity, entry, seq);
            }
            this.uniqueCheck(dataEntity, entries);
        }
    }

    private Map<String, String> getfieldNameMapping(DynamicObjectCollection entries) {
        HashMap<String, String> fieldNameMapping = new HashMap<String, String>();
        if (entries.size() > 0) {
            DataEntityPropertyCollection properties = ((DynamicObject)entries.get(0)).getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (!EmptyUtils.isNotEmpty(property.getDisplayName())) continue;
                String localeValue = property.getDisplayName().getLocaleValue();
                fieldNameMapping.put(property.getName(), localeValue);
            }
        }
        return fieldNameMapping;
    }

    private void billInfoDuplicateCheck(ExtendedDataEntity dataEntity, DynamicObject entry, String seq) {
        for (int i = 1; i <= 6; ++i) {
            DynamicObject asstactitem = entry.getDynamicObject(E_ASSTACTITEM + i);
            String e_mappingfieldname = entry.getString(E_MAPPINGFIELDNAME + i);
            if (EmptyUtils.isNotEmpty(asstactitem) && "bd_material".equals(asstactitem.getString("valuesource.number")) && EmptyUtils.isNotEmpty(e_mappingfieldname)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c:\u660e\u7ec6\u884c\u7269\u6599\u5e94\u5728\u5355\u636e\u4fe1\u606f\u4e2d\u7ef4\u62a4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GlImportSchemeSaveValidator_2", (String)"fi-arapcommon", (Object[])new Object[]{seq}));
            }
            if (EmptyUtils.isNotEmpty(asstactitem) && "er_expenseitemedit".equals(asstactitem.getString("valuesource.number")) && EmptyUtils.isNotEmpty(e_mappingfieldname)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c:\u660e\u7ec6\u884c\u8d39\u7528\u9879\u76ee\u5e94\u5728\u5355\u636e\u4fe1\u606f\u4e2d\u7ef4\u62a4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GlImportSchemeSaveValidator_3", (String)"fi-arapcommon", (Object[])new Object[]{seq}));
            }
            if (!EmptyUtils.isNotEmpty(asstactitem) || !EmptyUtils.isNotEmpty(e_mappingfieldname)) continue;
            if ("org".equals(entry.getString(E_MAPPINGFIELD + i))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c:\u7ed3\u7b97\u7ec4\u7ec7\u65e0\u9700\u5728\u201c\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6\u6620\u5c04\u5b57\u6bb5\u201d\u4e2d\u7ef4\u62a4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GlImportSchemeSaveValidator_7", (String)"fi-arapcommon", (Object[])new Object[]{seq}));
            }
            if (!"asstact".equals(entry.getString(E_MAPPINGFIELD + i)) && !"payee".equals(entry.getString(E_MAPPINGFIELD + i))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c:%2$s\u65e0\u9700\u5728\u201c\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6\u6620\u5c04\u5b57\u6bb5\u201d\u4e2d\u7ef4\u62a4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GlImportSchemeSaveValidator_8", (String)"fi-arapcommon", (Object[])new Object[0]), seq, e_mappingfieldname.substring(e_mappingfieldname.indexOf(46) + 1)));
        }
    }

    private void asstactTypeCheck(ExtendedDataEntity dataEntity, DynamicObject entry, String seq) {
        String billType = entry.getString("e_billtype.number");
        String asstacttype = entry.getString("e_asstacttype");
        if (this.getApBillTypeSet().contains(billType) && !"bd_supplier".equals(asstacttype) || this.getArBillTypeSet().contains(billType) && !"bd_customer".equals(asstacttype)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c:\u5355\u636e\u7c7b\u578b\u4e0e\u5f80\u6765\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GlImportSchemeSaveValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]), seq));
        }
    }

    private void mustInputCheck(ExtendedDataEntity dataEntity, Map<String, String> fieldNameMapping, boolean isLineType, Map<Object, DynamicObject> billTypeEntities, DynamicObject entry, String seq) {
        DynamicObject recType;
        DynamicObject paymentType;
        String appid = dataEntity.getDataEntity().getString("appid");
        String entityobject = entry.getString(E_ENTITYOBJECT);
        Long billTypeId = entry.getLong("e_billtype.id");
        DynamicObject billTypeEntity = billTypeEntities.get(billTypeId);
        if (this.getBillEntitySet().contains(entityobject)) {
            String payPropertyKey;
            DynamicObject payProperty;
            DynamicObject billType = entry.getDynamicObject(E_BILLTYPE);
            if (EmptyUtils.isEmpty(billType)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8bf7\u586b\u5199%2$s\u5b57\u6bb5\u3002", (String)"GlImportSchemeSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq, fieldNameMapping.get(E_BILLTYPE)));
            }
            DynamicObject bizType = entry.getDynamicObject(E_BIZTYPE);
            if (isLineType && EmptyUtils.isEmpty(bizType)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8bf7\u586b\u5199%2$s\u5b57\u6bb5\u3002", (String)"GlImportSchemeSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq, fieldNameMapping.get(E_BIZTYPE)));
            }
            if (EmptyUtils.isEmpty(payProperty = entry.getDynamicObject(payPropertyKey = "ap".equals(appid) ? E_APPAYPROPERTY : E_ARPAYPROPERTY))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8bf7\u586b\u5199%2$s\u5b57\u6bb5\u3002", (String)"GlImportSchemeSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq, fieldNameMapping.get(payPropertyKey)));
            }
            DynamicObject lineType = entry.getDynamicObject(E_LINETYPE);
            if (isLineType && EmptyUtils.isEmpty(lineType)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8bf7\u586b\u5199%2$s\u5b57\u6bb5\u3002", (String)"GlImportSchemeSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq, fieldNameMapping.get(E_LINETYPE)));
            }
            String materialKey = "ap_finapbill".equals(entityobject) ? "material" : E_MATERIAL;
            boolean materialIsMustInput = this.getFieldMustInput(billTypeEntity, materialKey);
            DynamicObject material = entry.getDynamicObject(E_MATERIAL);
            if (materialIsMustInput && EmptyUtils.isEmpty(material)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8bf7\u586b\u5199%2$s\u5b57\u6bb5\u3002", (String)"GlImportSchemeSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq, fieldNameMapping.get(E_MATERIAL)));
            }
            String expenseitemKey = "ap_finapbill".equals(entityobject) ? "expenseitem" : E_EXPENSEITEM;
            boolean expenseitemIsMustInput = this.getFieldMustInput(billTypeEntity, expenseitemKey);
            DynamicObject expenseitem = entry.getDynamicObject(E_EXPENSEITEM);
            if (expenseitemIsMustInput && EmptyUtils.isEmpty(expenseitem)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8bf7\u586b\u5199%2$s\u5b57\u6bb5\u3002", (String)"GlImportSchemeSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq, fieldNameMapping.get(E_EXPENSEITEM)));
            }
        }
        if ("ap_paidbill".equals(entityobject) && EmptyUtils.isEmpty(paymentType = entry.getDynamicObject(E_PAYMENTTYPE))) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8bf7\u586b\u5199%2$s\u5b57\u6bb5\u3002", (String)"GlImportSchemeSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq, fieldNameMapping.get(E_PAYMENTTYPE)));
        }
        if ("ar_receivedbill".equals(entityobject) && EmptyUtils.isEmpty(recType = entry.getDynamicObject(E_RECTYPE))) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u8bf7\u586b\u5199%2$s\u5b57\u6bb5\u3002", (String)"GlImportSchemeSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq, fieldNameMapping.get(E_RECTYPE)));
        }
    }

    private boolean getFieldMustInput(DynamicObject billTypeEntity, String fieldKey) {
        if (EmptyUtils.isNotEmpty(billTypeEntity)) {
            DynamicObjectCollection fieldcontrolentry = billTypeEntity.getDynamicObjectCollection("fieldcontrolentry");
            for (DynamicObject fieldcontrol : fieldcontrolentry) {
                if (!fieldKey.equals(fieldcontrol.getString("fieldkey")) || !fieldcontrol.getBoolean("mustinput")) continue;
                return true;
            }
        }
        return false;
    }

    private void uniqueCheck(ExtendedDataEntity dataEntity, DynamicObjectCollection entries) {
        HashSet<String> uniquePKs = new HashSet<String>(8);
        for (DynamicObject entry : entries) {
            ArrayList<String> matchList = new ArrayList<String>(8);
            String accountId = entry.getString("e_account.id");
            String asstactitemId = entry.getString("e_asstactitem.id");
            String balancetype = entry.getString(E_BALANCETYPE);
            if (EmptyUtils.isNotEmpty(accountId) && EmptyUtils.isNotEmpty(asstactitemId)) {
                matchList.add(accountId);
                matchList.add(asstactitemId);
            }
            for (int i = 1; i <= 6; ++i) {
                String mappingfieldname = entry.getString(E_MAPPINGFIELDNAME + i);
                if (!EmptyUtils.isNotEmpty(mappingfieldname)) continue;
                DynamicObject asstactitem = entry.getDynamicObject(E_ASSTACTITEM + i);
                matchList.add(asstactitem.getString("id"));
            }
            Collections.sort(matchList);
            String matchString = String.join((CharSequence)",", matchList);
            String uniquePK = balancetype + matchString;
            if ("1".equals(balancetype)) {
                if (uniquePKs.contains("2" + matchString) || uniquePKs.contains("3" + matchString)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u76f8\u540c\u79d1\u76ee+\u6838\u7b97\u7ef4\u5ea6\u7ec4\u5408\u4e2d\uff0c\u4f59\u989d\u53d6\u503c\u8bbe\u7f6e\u53ef\u80fd\u9020\u6210\u91cd\u590d\u53d6\u503c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GlImportSchemeSaveValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                uniquePKs.add(uniquePK);
            }
            if (!"2".equals(balancetype) && !"3".equals(balancetype)) continue;
            if (uniquePKs.contains("1" + matchString)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u76f8\u540c\u79d1\u76ee+\u6838\u7b97\u7ef4\u5ea6\u7ec4\u5408\u4e2d\uff0c\u4f59\u989d\u53d6\u503c\u8bbe\u7f6e\u53ef\u80fd\u9020\u6210\u91cd\u590d\u53d6\u503c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GlImportSchemeSaveValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            uniquePKs.add(uniquePK);
        }
        if (entries.size() != uniquePKs.size()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u79d1\u76ee+\u6838\u7b97\u7ef4\u5ea6+\u4f59\u989d\u53d6\u503c\u7684\u7ec4\u5408\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GlImportSchemeSaveValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private Set<String> getApBillTypeSet() {
        HashSet<String> apBillTypeSet = new HashSet<String>();
        apBillTypeSet.add("ap_finapbill_asset_BT_S");
        apBillTypeSet.add("ApFin_fee_BT_S");
        apBillTypeSet.add("ApFin_product_BT_S");
        apBillTypeSet.add("ApFin_pur_BT_S");
        apBillTypeSet.add("ApFin_purfee_BT_S");
        apBillTypeSet.add("ApFin_service_BT_S");
        apBillTypeSet.add("ap_busbill_stadpur_BT_S");
        apBillTypeSet.add("ap_busbill_asset_BT_S");
        apBillTypeSet.add("ap_busbill_feepur_BT_S");
        apBillTypeSet.add("ap_busbill_om_BT_S");
        apBillTypeSet.add("ap_busbill_purfee_BT_S");
        apBillTypeSet.add("ap_busbill_serpur_BT_S");
        return apBillTypeSet;
    }

    private Set<String> getArBillTypeSet() {
        HashSet<String> arBillTypeSet = new HashSet<String>();
        arBillTypeSet.add("arfin_salefee_BT_S");
        arBillTypeSet.add("arfin_sersal_BT_S");
        arBillTypeSet.add("arfin_standard_BT_S");
        arBillTypeSet.add("ar_busbill_salefee_BT_S");
        arBillTypeSet.add("ar_busbill_sersal_BT_S");
        arBillTypeSet.add("ar_busbill_standard_BT_S");
        return arBillTypeSet;
    }

    private Set<String> getBillEntitySet() {
        HashSet<String> billEntitySet = new HashSet<String>();
        billEntitySet.add("ap_finapbill");
        billEntitySet.add("ap_busbill");
        billEntitySet.add("ar_finarbill");
        billEntitySet.add("ar_busbill");
        return billEntitySet;
    }
}

