/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.util.GLUtils;

public class GlImportValidator
extends AbstractValidator {
    private boolean isAr;

    public void validate() {
        DynamicObject p_useorg = null;
        if (this.getOption().containsVariable("useorg")) {
            String s_useorg = this.getOption().getVariableValue("useorg");
            p_useorg = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(s_useorg), (String)"bos_org", (String)"id, number, name");
        }
        long userId = RequestContext.get().getCurrUserId();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String orgName;
            DynamicObject info = dataEntity.getDataEntity();
            String appId = info.getString("appid");
            this.isAr = "ar".equalsIgnoreCase(appId);
            DynamicObject useorg = info.getDynamicObject("useorg");
            if (useorg == null) {
                useorg = p_useorg;
                info.set("useorg", (Object)p_useorg);
            }
            if (useorg == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"GlImportValidator_7", (String)"fi-arapcommon", (Object[])new Object[0]));
                continue;
            }
            long orgPk = (Long)useorg.getPkValue();
            InitHelper init = new InitHelper(orgPk, this.isAr ? "ar_init" : "ap_init");
            if (!this.checkInit(dataEntity, init, orgName = useorg.getLocaleString("name").getLocaleValue())) {
                this.chkAccountBook(dataEntity, init, orgPk, orgName);
            }
            DynamicObjectCollection entries = info.getDynamicObjectCollection("entry");
            this.chkBillPerm(dataEntity, entries, userId, orgPk, orgName, appId);
            this.checkNumberRule(dataEntity, orgPk, entries);
        }
    }

    private void checkNumberRule(ExtendedDataEntity dataEntity, long orgPk, DynamicObjectCollection entries) {
        Set entityKeys = entries.stream().map(e -> e.getString("e_entityobject")).collect(Collectors.toSet());
        for (String entityKey : entityKeys) {
            DynamicObject newBill;
            boolean hasNumber = CodeRuleServiceHelper.isExist((String)entityKey, (DynamicObject)(newBill = BusinessDataServiceHelper.newDynamicObject((String)entityKey)), (String)String.valueOf(orgPk));
            if (hasNumber) continue;
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityKey);
            String message = ResManager.loadKDString((String)"%s\u65e0\u5bf9\u5e94\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u5148\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u518d\u5bfc\u5165\u3002", (String)"GlImportValidator_8", (String)"fi-arapcommon", (Object[])new Object[]{dt.getDisplayName().getLocaleValue()});
            this.addErrorMessage(dataEntity, message);
        }
    }

    private boolean checkInit(ExtendedDataEntity dataEntity, InitHelper init, String orgName) {
        boolean chkErr;
        String message = null;
        if (ObjectUtils.isEmpty((Object)init.getInitId())) {
            message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%s \u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"GlImportValidator_0", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
        } else if (init.isFinishInit()) {
            message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%s \u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"GlImportValidator_1", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
        }
        boolean bl = chkErr = message != null;
        if (chkErr) {
            this.addErrorMessage(dataEntity, message);
        }
        return chkErr;
    }

    private void chkAccountBook(ExtendedDataEntity dataEntity, InitHelper init, long orgPk, String orgName) {
        DynamicObject accountBook = GLUtils.getAccountBook4Master(orgPk);
        if (ObjectUtils.isEmpty((Object)accountBook)) {
            String message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%s \u7684\u4f1a\u8ba1\u4e3b\u8d26\u7c3f\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"GlImportValidator_2", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
            this.addErrorMessage(dataEntity, message);
        } else if (!accountBook.getBoolean("isendinit")) {
            String message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%s \u603b\u8d26\u6ca1\u6709\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"GlImportValidator_3", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
            this.addErrorMessage(dataEntity, message);
        } else {
            if (!Objects.equals(init.getPeriodType().getPkValue(), accountBook.getLong("periodtype.id"))) {
                String message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%s \u4f1a\u8ba1\u4e3b\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0e\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GlImportValidator_4", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
                this.addErrorMessage(dataEntity, message);
            }
            DynamicObject startPeriod = init.getStartPeriod();
            DynamicObject glStartPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)accountBook.getLong("startperiod.id"), (String)"bd_period", (String)"periodyear, periodnumber");
            DynamicObject glCurPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)accountBook.getLong("curperiod.id"), (String)"bd_period", (String)"periodyear, periodnumber");
            if (!PeriodHelper.afterEquals(startPeriod, glStartPeriod) || !PeriodHelper.beforeEquals(startPeriod, glCurPeriod)) {
                String bizAppName = AppMetadataCache.getAppInfo((String)(this.isAr ? "ar" : "ap")).getName().getLocaleValue();
                String message = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%1$s %2$s\u542f\u7528\u671f\u95f4\u4e0d\u5728\u5bf9\u5e94\u4f1a\u8ba1\u4e3b\u8d26\u7c3f\u7684\u542f\u7528\u671f\u95f4\u4e0e\u5f53\u524d\u671f\u95f4\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"GlImportValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]), orgName, bizAppName);
                this.addErrorMessage(dataEntity, message);
            }
        }
    }

    private void chkBillPerm(ExtendedDataEntity dataEntity, DynamicObjectCollection entries, long userId, long orgPk, String orgName, String appId) {
        HashMap<String, Boolean> permMap = new HashMap<String, Boolean>(0);
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            String entityKey = entry.getString("e_entityobject");
            Boolean hasPerm = null;
            Boolean value = (Boolean)permMap.get(entityKey);
            if (value != null) {
                hasPerm = value;
            } else {
                int result = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgPk, (String)"10", (String)appId, (String)entityKey, (String)"47156aff000000ac");
                hasPerm = result == 1;
                permMap.put(entityKey, hasPerm);
            }
            if (hasPerm.booleanValue()) continue;
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityKey);
            String message = String.format(ResManager.loadKDString((String)"\u201c\u6620\u5c04\u4fe1\u606f\u201d\u7b2c%1$s\u884c\uff0c\u7ec4\u7ec7\uff1a%2$s\uff0c\u6ca1\u6709[%3$s]\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"GlImportValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1, orgName, dt.getDisplayName().getLocaleValue());
            this.addErrorMessage(dataEntity, message);
        }
    }
}

