/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ImportSettleValidator
extends AbstractValidator {
    public void validate() {
        Map<String, Long> asstactIdMap = this.getAsstIdMap();
        for (ExtendedDataEntity entity : this.dataEntities) {
            String mainBillNum;
            Long mainAsstActId;
            DynamicObject bill = entity.getDataEntity();
            String settleResult = bill.getString("settleresult");
            if ("1".equals(settleResult)) {
                String message = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u7b97\u7f16\u53f7%s\uff1a\u7ed3\u7b97\u7ed3\u679c\u4e3a\u672a\u7ed3\u7b97\u6216\u5931\u8d25\u624d\u53ef\u4ee5\u7ed3\u7b97\u3002", (String)"ImportSettleValidator_0", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")});
                this.addErrorMessage(entity, message);
            }
            if ((mainAsstActId = asstactIdMap.get(mainBillNum = bill.getString("mainbillnum"))) == null) continue;
            Long modelMainAsstId = bill.getLong("mainasstactid.id");
            if (!mainAsstActId.equals(modelMainAsstId)) {
                String message = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u7b97\u7f16\u53f7%s\uff1a\u4e3b\u65b9\u5f80\u6765\u6237\u4e0e\u5bfc\u5165\u65f6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ImportSettleValidator_1", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")});
                this.addErrorMessage(entity, message);
            }
            DynamicObjectCollection asstEntry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : asstEntry) {
                String asstBillNum = entry.getString("billnum");
                Long asstactId = asstactIdMap.get(asstBillNum);
                Long modelAsstId = entry.getLong("asstactid.id");
                if (asstactId != null && asstactId.equals(modelAsstId)) continue;
                String message = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u7b97\u7f16\u53f7%s\uff1a\u8f85\u65b9\u5f80\u6765\u6237\u4e0e\u5bfc\u5165\u65f6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ImportSettleValidator_2", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")});
                this.addErrorMessage(entity, message);
            }
        }
    }

    private Map<String, Long> getAsstIdMap() {
        HashMap<String, Long> asstIdMap = new HashMap<String, Long>(this.dataEntities.length);
        HashSet<String> finApNos = new HashSet<String>(this.dataEntities.length);
        HashSet<String> finArNos = new HashSet<String>(this.dataEntities.length);
        HashSet<String> payNos = new HashSet<String>(this.dataEntities.length);
        HashSet<String> resNos = new HashSet<String>(this.dataEntities.length);
        block28: for (ExtendedDataEntity entity : this.dataEntities) {
            String relation;
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            switch (relation = bill.getString("settlerelation")) {
                case "appaysettle": {
                    this.getSettleBillNo(bill, entrys, finApNos, payNos);
                    continue block28;
                }
                case "payself": {
                    this.getSettleBillNo(bill, entrys, payNos, payNos);
                    continue block28;
                }
                case "apself": {
                    this.getSettleBillNo(bill, entrys, finApNos, finApNos);
                    continue block28;
                }
                case "aparsettle": {
                    this.getSettleBillNo(bill, entrys, finApNos, finArNos);
                    continue block28;
                }
                case "payrecsettle": {
                    this.getSettleBillNo(bill, entrys, payNos, resNos);
                    continue block28;
                }
                case "aprecsettle": {
                    this.getSettleBillNo(bill, entrys, finApNos, resNos);
                    continue block28;
                }
                case "recsettle": {
                    this.getSettleBillNo(bill, entrys, finArNos, resNos);
                    continue block28;
                }
                case "arself": {
                    this.getSettleBillNo(bill, entrys, finArNos, finArNos);
                    continue block28;
                }
                case "arapsettle": {
                    this.getSettleBillNo(bill, entrys, finArNos, finApNos);
                    continue block28;
                }
                case "recself": {
                    this.getSettleBillNo(bill, entrys, resNos, resNos);
                    continue block28;
                }
                case "recpaysettle": {
                    this.getSettleBillNo(bill, entrys, resNos, payNos);
                    continue block28;
                }
                case "arpaysettle": {
                    this.getSettleBillNo(bill, entrys, finArNos, payNos);
                }
            }
        }
        if (finApNos.size() > 0) {
            DynamicObjectCollection apBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"billno,asstact.id", (QFilter[])new QFilter[]{new QFilter("billno", "in", finApNos)});
            for (DynamicObject apBill : apBills) {
                asstIdMap.put(apBill.getString("billno"), apBill.getLong("asstact.id"));
            }
        }
        if (finArNos.size() > 0) {
            DynamicObjectCollection arBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"billno,asstact.id", (QFilter[])new QFilter[]{new QFilter("billno", "in", finArNos)});
            for (DynamicObject arBill : arBills) {
                asstIdMap.put(arBill.getString("billno"), arBill.getLong("asstact.id"));
            }
        }
        if (payNos.size() > 0) {
            DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"billno,payee", (QFilter[])new QFilter[]{new QFilter("billno", "in", payNos)});
            for (DynamicObject payBill : payBills) {
                asstIdMap.put(payBill.getString("billno"), payBill.getLong("payee"));
            }
            DynamicObjectCollection paidBills = QueryServiceHelper.query((String)"ap_paidbill", (String)"billno,payee", (QFilter[])new QFilter[]{new QFilter("billno", "in", payNos)});
            for (DynamicObject paidBill : paidBills) {
                asstIdMap.put(paidBill.getString("billno"), paidBill.getLong("payee"));
            }
        }
        if (resNos.size() > 0) {
            DynamicObjectCollection resBills = QueryServiceHelper.query((String)"cas_recbill", (String)"billno,payer", (QFilter[])new QFilter[]{new QFilter("billno", "in", resNos)});
            for (DynamicObject resBill : resBills) {
                asstIdMap.put(resBill.getString("billno"), resBill.getLong("payer"));
            }
            DynamicObjectCollection receivedBills = QueryServiceHelper.query((String)"ar_receivedbill", (String)"billno,asstact", (QFilter[])new QFilter[]{new QFilter("billno", "in", resNos)});
            for (DynamicObject receivedBill : receivedBills) {
                asstIdMap.put(receivedBill.getString("billno"), receivedBill.getLong("asstact"));
            }
        }
        return asstIdMap;
    }

    private void getSettleBillNo(DynamicObject bill, DynamicObjectCollection entrys, Set<String> mainNos, Set<String> asstNos) {
        String mainBillNum = bill.getString("mainbillnum");
        mainNos.add(mainBillNum);
        for (DynamicObject entry : entrys) {
            String asstBillNum = entry.getString("billnum");
            asstNos.add(asstBillNum);
        }
    }
}

