/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;

public class InitBillValidator
extends AbstractValidator {
    private boolean isAr;
    private boolean isSubmitOp;

    public void validate() {
        DynamicObject info;
        this.isAr = "ar_init".equals(this.entityKey);
        this.isSubmitOp = "submit".equalsIgnoreCase(this.getOperateKey());
        HashSet<Long> initIds = new HashSet<Long>(8);
        HashMap<Long, ExtendedDataEntity> idAndEntity = new HashMap<Long, ExtendedDataEntity>(8);
        ArrayList dataEntityUnFinished = new ArrayList(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            info = dataEntity.getDataEntity();
            Long id = info.getLong("id");
            initIds.add(id);
            idAndEntity.put(id, dataEntity);
        }
        String selectors = this.isAr ? "id, isfinishinit, org.name, policytype.name" : "id, isfinishinit, org.name";
        DynamicObjectCollection researchInit = QueryServiceHelper.query((String)this.entityKey, (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", initIds)});
        for (DynamicObject init : researchInit) {
            Long id = init.getLong("id");
            boolean isFinishInit = init.getBoolean("isfinishinit");
            if (this.isSubmitOp && isFinishInit) {
                String message = null;
                String orgName = init.getString("org.name");
                if (this.isAr) {
                    String policyTypeName = init.getString("policytype.name");
                    message = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u3001\u653f\u7b56\u7c7b\u578b\u201c%2$s\u201d\uff1a\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"InitBillValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), orgName, policyTypeName);
                } else {
                    message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"InitBillValidator_14", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
                }
                this.addErrorMessage((ExtendedDataEntity)idAndEntity.get(id), message);
                continue;
            }
            dataEntityUnFinished.add(idAndEntity.get(id));
        }
        for (ExtendedDataEntity dataEntity : dataEntityUnFinished) {
            info = dataEntity.getDataEntity();
            DynamicObject org = info.getDynamicObject("org");
            long orgPk = (Long)org.getPkValue();
            String orgName = org.getLocaleString("name").getLocaleValue();
            boolean isfinishinit = info.getBoolean("isfinishinit");
            if (this.isSubmitOp) {
                if (isfinishinit) continue;
                this.checkBill(dataEntity, orgPk, orgName);
                continue;
            }
            if (isfinishinit) continue;
            this.checkBill(dataEntity, orgPk, orgName);
        }
    }

    private void checkBill(ExtendedDataEntity dataEntity, long orgPk, String orgName) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgPk);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
        QFilter periodFilter = new QFilter("isperiod", "=", (Object)Boolean.TRUE);
        if (this.isAr) {
            String message;
            if (QueryServiceHelper.exists((String)"ar_finarbill", (QFilter[])new QFilter[]{qFilter, periodFilter})) {
                message = null;
                message = this.isSubmitOp ? ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"InitBillValidator_1", (String)"fi-arapcommon", (Object[])new Object[]{orgName}) : ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u8bf7\u63d0\u4ea4\u540e\u5bf9\u8d26\u3002", (String)"InitBillValidator_2", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
                this.addErrorMessage(dataEntity, message);
            }
            if (QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{qFilter, periodFilter})) {
                message = null;
                message = this.isSubmitOp ? ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u6682\u4f30\u5e94\u6536\u5355\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"InitBillValidator_3", (String)"fi-arapcommon", (Object[])new Object[]{orgName}) : ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u6682\u4f30\u5e94\u6536\u5355\uff0c\u8bf7\u63d0\u4ea4\u540e\u5bf9\u8d26\u3002", (String)"InitBillValidator_4", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
                this.addErrorMessage(dataEntity, message);
            }
            if (QueryServiceHelper.exists((String)"ar_receivedbill", (QFilter[])new QFilter[]{qFilter})) {
                message = null;
                message = this.isSubmitOp ? ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u9884\u6536\u5355\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"InitBillValidator_5", (String)"fi-arapcommon", (Object[])new Object[]{orgName}) : ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u9884\u6536\u5355\uff0c\u8bf7\u63d0\u4ea4\u540e\u5bf9\u8d26\u3002", (String)"InitBillValidator_6", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
                this.addErrorMessage(dataEntity, message);
            }
            if (this.isSubmitOp && QueryServiceHelper.exists((String)"ar_baddebtreservebill", (QFilter[])new QFilter[]{qFilter})) {
                message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u574f\u8d26\u51c6\u5907\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"InitBillValidator_7", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
                this.addErrorMessage(dataEntity, message);
            }
        } else {
            String message;
            if (QueryServiceHelper.exists((String)"ap_finapbill", (QFilter[])new QFilter[]{qFilter, periodFilter})) {
                message = null;
                message = this.isSubmitOp ? ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"InitBillValidator_8", (String)"fi-arapcommon", (Object[])new Object[]{orgName}) : ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u8bf7\u63d0\u4ea4\u540e\u5bf9\u8d26\u3002", (String)"InitBillValidator_9", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
                this.addErrorMessage(dataEntity, message);
            }
            if (QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{qFilter, periodFilter})) {
                message = null;
                message = this.isSubmitOp ? ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u6682\u4f30\u5e94\u4ed8\u5355\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"InitBillValidator_10", (String)"fi-arapcommon", (Object[])new Object[]{orgName}) : ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u6682\u4f30\u5e94\u4ed8\u5355\uff0c\u8bf7\u63d0\u4ea4\u540e\u5bf9\u8d26\u3002", (String)"InitBillValidator_11", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
                this.addErrorMessage(dataEntity, message);
            }
            if (QueryServiceHelper.exists((String)"ap_paidbill", (QFilter[])new QFilter[]{qFilter})) {
                message = null;
                message = this.isSubmitOp ? ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u9884\u4ed8\u5355\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"InitBillValidator_12", (String)"fi-arapcommon", (Object[])new Object[]{orgName}) : ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5b58\u5728\u6682\u5b58\u7684\u671f\u521d\u9884\u4ed8\u5355\uff0c\u8bf7\u63d0\u4ea4\u540e\u5bf9\u8d26\u3002", (String)"InitBillValidator_13", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
                this.addErrorMessage(dataEntity, message);
            }
        }
    }
}

