/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class LineTypeValidator
extends AbstractValidator {
    Map<Long, Boolean> paramCache;

    public void validate() {
        DynamicObject bill;
        HashSet<Long> serviceAttributeIds = new HashSet<Long>(this.dataEntities.length);
        LinkedList<ExtendedDataEntity> entities = new LinkedList<ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            bill = dataEntity.getDataEntity();
            Boolean param = this.getParam(bill.getLong("org.id"), this.isAr());
            if (!param.booleanValue()) continue;
            entities.add(dataEntity);
        }
        if (ObjectUtils.isEmpty(entities)) {
            return;
        }
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill2 = entity.getDataEntity();
            boolean isBaseDonAmt = bill2.getBoolean("payproperty.isbasedonamt");
            DynamicObjectCollection entry = bill2.getDynamicObjectCollection(this.getDetailEntryKey(this.entityKey));
            for (DynamicObject row : entry) {
                String criterion = row.getString("linetype.controlcriterion");
                if ((!isBaseDonAmt || !"0".equals(criterion)) && (isBaseDonAmt || !"1".equals(criterion))) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5355\u636e\u884c\u7c7b\u578b.\u63a7\u5236\u57fa\u51c6\u9700\u4e0e\u6b3e\u9879\u6027\u8d28.\u662f\u5426\u91d1\u989d\u57fa\u51c6\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"LineTypeValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                break;
            }
            for (DynamicObject row : entry) {
                Long serviceAttributeId = row.getLong("linetype.serviceattribute.id");
                serviceAttributeIds.add(serviceAttributeId);
            }
        }
        DynamicObjectCollection relatedEntities = QueryServiceHelper.query((String)"bd_serviceattribute", (String)"id,entity.number", (QFilter[])new QFilter[]{new QFilter("id", "in", serviceAttributeIds)});
        Set expenseItemEntities = relatedEntities.stream().filter(relatedEntity -> "er_expenseitemedit".equals(relatedEntity.getString("entity.number"))).map(relatedEntity -> relatedEntity.getLong("id")).collect(Collectors.toSet());
        if (ObjectUtils.isEmpty(expenseItemEntities)) {
            return;
        }
        for (ExtendedDataEntity entity : entities) {
            bill = entity.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(this.getDetailEntryKey(this.entityKey));
            for (DynamicObject row : entry) {
                if (!expenseItemEntities.contains(row.getLong("linetype.serviceattribute.id")) || !ObjectUtils.isEmpty((Object)row.getDynamicObject(this.getExpenseItemKey(this.entityKey)))) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\u884c\u7c7b\u578b\u5173\u8054\u4e1a\u52a1\u5c5e\u6027\u4e3a\u8d39\u7528\u9879\u76ee\uff0c\u8d39\u7528\u9879\u76ee\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"LineTypeValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), row.getInt("seq")));
            }
        }
    }

    private boolean isAr() {
        boolean isAr = true;
        if (this.entityKey.contains("ap")) {
            isAr = false;
        }
        return isAr;
    }

    private Boolean getParam(long orgId, boolean isAr) {
        Boolean param = null;
        if (this.paramCache != null) {
            param = this.paramCache.get(orgId);
        } else {
            this.paramCache = new HashMap<Long, Boolean>(8);
        }
        if (param == null) {
            String paramKey = "ap_025";
            if (isAr) {
                paramKey = "ar_025";
                param = SystemParameterHelper.getARBooleanParam(orgId, paramKey);
            } else {
                param = SystemParameterHelper.getAPBooleanParam(orgId, paramKey);
            }
            this.paramCache.put(orgId, param);
        }
        return param;
    }

    private String getDetailEntryKey(String entityKey) {
        return "ap_finapbill".equals(entityKey) ? "detailentry" : "entry";
    }

    private String getExpenseItemKey(String entityKey) {
        return "ap_finapbill".equals(entityKey) ? "expenseitem" : "e_expenseitem";
    }
}

