/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.util.EmptyUtils;

public class PayApplyExcessValidator
extends AbstractExecControlValidator {
    private static final Log logger = LogFactory.getLog(PayApplyExcessValidator.class);
    private static final String validateBillBillNo = "SZJK-PRE-0064";
    private static final String validateEntryBillNo = "SZJK-PRE-0019";
    private boolean isValidateBill = false;
    private boolean isValidateEntry = false;

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selector = new HashSet<String>(64);
        selector.add("sourcebilltype");
        selector.add("e_approvedseleamt");
        selector.add("entry.seq");
        selector.add("entry_lk");
        selector.add("entry_lk_sbillid");
        selector.add("entry_lk_sid");
        return selector;
    }

    public void validate() {
        this.initValidateLevel();
        logger.info("PayApplyExcessValidator validate isValidateEntry is\u3010 " + this.isValidateEntry + " \u3011\uff0cisValidateBill\u3010 " + this.isValidateBill + "\u3011");
        if (!this.isValidateBill && !this.isValidateEntry) {
            return;
        }
        ArrayList<ExtendedDataEntity> directArApBills = new ArrayList<ExtendedDataEntity>(64);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject applyBill = dataEntity.getDataEntity();
            String sourceBillType = applyBill.getString("sourcebilltype");
            if (!"ap_finapbill".equals(sourceBillType) && !"ar_finarbill".equals(sourceBillType)) continue;
            directArApBills.add(dataEntity);
        }
        if (directArApBills.isEmpty()) {
            return;
        }
        this.downTarExcessValidator(directArApBills, false);
        this.downTarExcessValidator(directArApBills, true);
    }

    private void initValidateLevel() {
        QFilter filter = new QFilter("number", "in", Arrays.asList(validateBillBillNo, validateEntryBillNo));
        Map execControlMap = BusinessDataServiceHelper.loadFromCache((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object)execControlMap)) {
            return;
        }
        for (Map.Entry entrySet : execControlMap.entrySet()) {
            DynamicObject execControl = (DynamicObject)entrySet.getValue();
            if (!execControl.getBoolean("enable")) continue;
            String number = execControl.getString("number");
            if (validateBillBillNo.equals(number)) {
                this.isValidateBill = true;
                continue;
            }
            if (!validateEntryBillNo.equals(number)) continue;
            this.isValidateEntry = true;
        }
    }

    private void downTarExcessValidator(List<ExtendedDataEntity> directArApBills, boolean isAr) {
        List<Long> applyBillIds;
        Map<Long, Map<String, List<Long>>> allTargetRowIds;
        Set entryIds;
        long billId;
        logger.info("PayApplyExcessValidator downTarExcessValidator begin . isAr :" + isAr);
        String entityKey = isAr ? "ar_finarbill" : "ap_finapbill";
        List<ExtendedDataEntity> applyBills = directArApBills.stream().filter(entity -> entityKey.equals(entity.getDataEntity().getString("sourcebilltype"))).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(applyBills)) {
            return;
        }
        logger.info("PayApplyExcessValidator downTarExcessValidator applyBills :" + applyBills.size());
        HashSet<Long> srcBillIds = new HashSet<Long>(64);
        for (ExtendedDataEntity entity2 : applyBills) {
            DynamicObject applyBill = entity2.getDataEntity();
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            for (DynamicObject applyRow : entry) {
                DynamicObjectCollection entryLk = applyRow.getDynamicObjectCollection("entry_lk");
                if (EmptyUtils.isEmpty(entryLk)) continue;
                long srcBillId = ((DynamicObject)entryLk.get(0)).getLong("entry_lk_sbillid");
                srcBillIds.add(srcBillId);
            }
        }
        if (srcBillIds.isEmpty()) {
            return;
        }
        BillModel billModel = BillModelFactory.getModel(entityKey);
        List<String> detailSelectors = Arrays.asList("id", billModel.HEAD_ORG, billModel.ENTRY + "." + billModel.E_PRICETAXTOTAL + " " + billModel.E_PRICETAXTOTAL, billModel.ENTRY_PK, billModel.HEAD_PRICETAXTOTAL, billModel.HEAD_BILLNO);
        List<String> planSelectors = Arrays.asList("id", billModel.HEAD_ORG, billModel.P_ENTRY_PK, billModel.P_ENTRY + "." + billModel.P_PLANPRICETAX + " " + billModel.P_PLANPRICETAX);
        DataSet detailBills = QueryServiceHelper.queryDataSet((String)"downTarExcessValidator", (String)entityKey, (String)String.join((CharSequence)",", detailSelectors), (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)}, null);
        if (detailBills.isEmpty()) {
            return;
        }
        DataSet planBills = QueryServiceHelper.queryDataSet((String)"downTarExcessValidator", (String)entityKey, (String)String.join((CharSequence)",", planSelectors), (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)}, null);
        ArrayList<Long> orgIds = new ArrayList<Long>(64);
        DataSet orgInfo = detailBills.copy();
        for (Row info : orgInfo) {
            orgIds.add(info.getLong(billModel.HEAD_ORG));
        }
        String settleModelKey = isAr ? "ar_003" : "ap_003";
        Map<Long, Object> settleModelMap = SystemParameterHelper.batchGetAppParameter(isAr, orgIds, settleModelKey);
        HashMap<Long, BigDecimal> finBillAmountMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, BigDecimal> finRowAmountMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, Set> finEntryIdMap = new HashMap<Long, Set>(64);
        HashSet<Long> detailRowIds = new HashSet<Long>(64);
        HashSet<Long> planRowIds = new HashSet<Long>(64);
        HashMap<Long, String> billNoMap = new HashMap<Long, String>(64);
        for (Row bill : detailBills) {
            finBillAmountMap.put(bill.getLong("id"), bill.getBigDecimal(billModel.HEAD_PRICETAXTOTAL));
            finRowAmountMap.put(bill.getLong(billModel.ENTRY_PK), bill.getBigDecimal(billModel.E_PRICETAXTOTAL));
            billId = bill.getLong("id");
            entryIds = finEntryIdMap.getOrDefault(billId, new HashSet(64));
            entryIds.add(bill.getLong(billModel.ENTRY_PK));
            finEntryIdMap.put(billId, entryIds);
            Object object = settleModelMap.get(bill.getLong(billModel.HEAD_ORG));
            if ("1".equals(object)) {
                detailRowIds.add(bill.getLong(billModel.ENTRY_PK));
            }
            billNoMap.put(billId, bill.getString(billModel.HEAD_BILLNO));
        }
        for (Row bill : planBills) {
            finRowAmountMap.put(bill.getLong(billModel.P_ENTRY_PK), bill.getBigDecimal(billModel.P_PLANPRICETAX));
            billId = bill.getLong("id");
            entryIds = finEntryIdMap.getOrDefault(billId, new HashSet(64));
            entryIds.add(bill.getLong(billModel.P_ENTRY_PK));
            finEntryIdMap.put(billId, entryIds);
            Object object = settleModelMap.get(bill.getLong(billModel.HEAD_ORG));
            if (!"2".equals(object)) continue;
            planRowIds.add(bill.getLong(billModel.P_ENTRY_PK));
        }
        HashMap<Long, HashSet<Long>> targetRowIdsMap = new HashMap<Long, HashSet<Long>>(64);
        if (!detailRowIds.isEmpty()) {
            allTargetRowIds = BOTPNewHelper.loadAllTargetRowIds(entityKey, billModel.ENTRY, finBillAmountMap.keySet().toArray(new Long[0]), detailRowIds.toArray(new Long[0]));
            for (Map.Entry<Long, Map<String, List<Long>>> entrySet : allTargetRowIds.entrySet()) {
                applyBillIds = entrySet.getValue().get("ap_payapply");
                if (ObjectUtils.isEmpty((Object)applyBillIds)) continue;
                targetRowIdsMap.put(entrySet.getKey(), new HashSet<Long>(applyBillIds));
            }
        }
        if (!planRowIds.isEmpty()) {
            allTargetRowIds = BOTPNewHelper.loadAllTargetRowIds(entityKey, billModel.P_ENTRY, finBillAmountMap.keySet().toArray(new Long[0]), planRowIds.toArray(new Long[0]));
            for (Map.Entry<Long, Map<String, List<Long>>> entrySet : allTargetRowIds.entrySet()) {
                applyBillIds = entrySet.getValue().get("ap_payapply");
                if (ObjectUtils.isEmpty(applyBillIds)) continue;
                targetRowIdsMap.put(entrySet.getKey(), new HashSet<Long>(applyBillIds));
            }
        }
        logger.info("PayApplyExcessValidator downTarExcessValidator targetRowIdsMap :" + targetRowIdsMap);
        HashMap<Long, BigDecimal> srcBillAmountMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, BigDecimal> srcRowAmountMap = new HashMap<Long, BigDecimal>(64);
        HashSet<Long> operateApplyIds = new HashSet<Long>(64);
        for (ExtendedDataEntity extendedDataEntity : applyBills) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            operateApplyIds.add(dynamicObject.getLong("id"));
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entry");
            for (Object applyRow : entry) {
                DynamicObjectCollection dynamicObjectCollection = applyRow.getDynamicObjectCollection("entry_lk");
                if (EmptyUtils.isEmpty(dynamicObjectCollection)) continue;
                long srcBillId = ((DynamicObject)dynamicObjectCollection.get(0)).getLong("entry_lk_sbillid");
                long srcRowId = ((DynamicObject)dynamicObjectCollection.get(0)).getLong("entry_lk_sid");
                BigDecimal eApprovedseleAmt = applyRow.getBigDecimal("e_approvedseleamt");
                BigDecimal srcBillAmount = srcBillAmountMap.getOrDefault(srcBillId, BigDecimal.ZERO);
                srcBillAmount = srcBillAmount.add(eApprovedseleAmt);
                srcBillAmountMap.put(srcBillId, srcBillAmount);
                BigDecimal srcRowAmount = srcRowAmountMap.getOrDefault(srcRowId, BigDecimal.ZERO);
                srcRowAmount = srcRowAmount.add(eApprovedseleAmt);
                srcRowAmountMap.put(srcRowId, srcRowAmount);
            }
        }
        HashSet applyRowIds = new HashSet(64);
        for (Map.Entry entry : targetRowIdsMap.entrySet()) {
            applyRowIds.addAll((Collection)entry.getValue());
        }
        if (!applyRowIds.isEmpty()) {
            String string = "id,settleorg,entry.id,entry.e_approvedseleamt,billstatus,entry.e_paidamt,entry.e_closestatus";
            QFilter qFilter = new QFilter("settleorg", "in", orgIds);
            qFilter.and(new QFilter("entry.id", "in", applyRowIds));
            DataSet applyData = QueryServiceHelper.queryDataSet((String)"query_apply_bills", (String)"ap_payapply", (String)string, (QFilter[])new QFilter[]{qFilter}, (String)"");
            HashMap<Long, BigDecimal> applyRowAmtMap = new HashMap<Long, BigDecimal>(64);
            for (Row row : applyData) {
                if (operateApplyIds.contains(row.getLong("id"))) continue;
                BigDecimal amount = "B".equals(row.getString("entry.e_closestatus")) ? row.getBigDecimal("entry.e_paidamt") : row.getBigDecimal("entry.e_approvedseleamt");
                applyRowAmtMap.put(row.getLong("entry.id"), amount);
            }
            for (Map.Entry entry : finEntryIdMap.entrySet()) {
                Long finBillIds = (Long)entry.getKey();
                Set finRowIds = (Set)entry.getValue();
                BigDecimal srcBillAmount = srcBillAmountMap.getOrDefault(finBillIds, BigDecimal.ZERO);
                for (Long finRowId : finRowIds) {
                    BigDecimal srcRowAmount = srcRowAmountMap.getOrDefault(finRowId, BigDecimal.ZERO);
                    Set tarRowIds = (Set)targetRowIdsMap.get(finRowId);
                    if (ObjectUtils.isEmpty((Object)tarRowIds)) continue;
                    for (Long tarRowId : tarRowIds) {
                        BigDecimal applyRowAmount = applyRowAmtMap.getOrDefault(tarRowId, BigDecimal.ZERO);
                        srcRowAmount = srcRowAmount.add(applyRowAmount);
                        srcBillAmount = srcBillAmount.add(applyRowAmount);
                    }
                    srcRowAmountMap.put(finRowId, srcRowAmount);
                }
                srcBillAmountMap.put(finBillIds, srcBillAmount);
            }
        }
        HashSet<Long> hashSet = new HashSet<Long>(64);
        if (this.isValidateBill) {
            for (Map.Entry entrySet : srcBillAmountMap.entrySet()) {
                BigDecimal bigDecimal;
                Long finBillId = (Long)entrySet.getKey();
                BigDecimal srcBillAmount = (BigDecimal)entrySet.getValue();
                boolean isExcess = this.isExcessPay(srcBillAmount, bigDecimal = (BigDecimal)finBillAmountMap.get(finBillId), isAr);
                if (!isExcess) continue;
                hashSet.add(finBillId);
            }
        }
        if (this.isValidateEntry) {
            for (Map.Entry entrySet : srcRowAmountMap.entrySet()) {
                BigDecimal bigDecimal;
                Long finRowId = (Long)entrySet.getKey();
                BigDecimal srcRowAmount = (BigDecimal)entrySet.getValue();
                boolean isExcess = this.isExcessPay(srcRowAmount, bigDecimal = (BigDecimal)finRowAmountMap.get(finRowId), isAr);
                if (!isExcess) continue;
                hashSet.add(finRowId);
            }
        }
        this.showErrorMessage(applyBills, hashSet, billNoMap, isAr);
    }

    private void showErrorMessage(List<ExtendedDataEntity> applyBills, Set<Long> excessFinIds, Map<Long, String> billNoMap, boolean isAr) {
        logger.info("PayApplyExcessValidator showErrorMessage excessFinIds :" + excessFinIds);
        if (ObjectUtils.isEmpty(excessFinIds)) {
            return;
        }
        String errorMessage = isAr ? ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u4e0a\u6e38\u8d22\u52a1\u5e94\u6536\u5355%2$s\u6240\u5173\u8054\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01\u603b\u548c\u5927\u4e8e\u8d22\u52a1\u5e94\u6536\u5355\u7684\u5e94\u6536\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayApplyExcessValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355%2$s\u6240\u5173\u8054\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01\u603b\u548c\u5927\u4e8e\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayApplyExcessValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]);
        block0: for (ExtendedDataEntity entity : applyBills) {
            long srcBillId;
            DynamicObjectCollection entryLk;
            DynamicObject applyBill = entity.getDataEntity();
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            boolean isGoOn = true;
            for (DynamicObject applyRow : entry) {
                entryLk = applyRow.getDynamicObjectCollection("entry_lk");
                if (EmptyUtils.isEmpty(entryLk)) continue;
                srcBillId = ((DynamicObject)entryLk.get(0)).getLong("entry_lk_sbillid");
                long srcRowId = ((DynamicObject)entryLk.get(0)).getLong("entry_lk_sid");
                if (!excessFinIds.contains(srcRowId)) continue;
                this.addMessage(entity, String.format(errorMessage, applyRow.getInt("seq"), billNoMap.get(srcBillId)));
                isGoOn = false;
                break;
            }
            if (!isGoOn) continue;
            for (DynamicObject applyRow : entry) {
                entryLk = applyRow.getDynamicObjectCollection("entry_lk");
                if (EmptyUtils.isEmpty(entryLk) || !excessFinIds.contains(srcBillId = ((DynamicObject)entryLk.get(0)).getLong("entry_lk_sbillid"))) continue;
                this.addMessage(entity, String.format(errorMessage, applyRow.getInt("seq"), billNoMap.get(srcBillId)));
                continue block0;
            }
        }
    }

    private boolean isExcessPay(BigDecimal applyPayAmt, BigDecimal priceTaxTotal, boolean isAr) {
        if (priceTaxTotal.signum() == 0 && applyPayAmt.signum() != 0) {
            return true;
        }
        if (priceTaxTotal.signum() != 0 && applyPayAmt.abs().compareTo(priceTaxTotal.abs()) > 0) {
            return true;
        }
        return !isAr && applyPayAmt.signum() != 0 && applyPayAmt.signum() != priceTaxTotal.signum();
    }
}

