/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class PayBillBotpSettleMatchValidator
implements IOthersExecCtrlService {
    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("entry.e_paymenttype");
        selectors.add("entry.id");
        return selectors;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] payBills) {
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        HashMap<Long, DynamicObject> payMentTypeToEntryId = new HashMap<Long, DynamicObject>(payBills.length);
        for (DynamicObject payBill : payBills) {
            DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                long entryId = entry.getLong("id");
                DynamicObject receivingType = entry.getDynamicObject("e_paymenttype");
                payMentTypeToEntryId.put(entryId, receivingType);
            }
        }
        Set<Long> paymentBillPks = Arrays.stream(payBills).map(e -> e.getLong("id")).collect(Collectors.toSet());
        List linkUpNodeList = BFTrackerServiceHelper.loadLinkUpNodes((String)"cas_paybill", (Long[])paymentBillPks.toArray(new Long[0]), (OperateOption)OperateOption.create());
        HashSet<Long> srcArBillIdSet = new HashSet<Long>(paymentBillPks.size());
        HashSet<Long> arBillIdSet = new HashSet<Long>(paymentBillPks.size());
        HashSet<Long> srcApBillIdSet = new HashSet<Long>(paymentBillPks.size());
        HashSet<Long> apBillIdSet = new HashSet<Long>(paymentBillPks.size());
        TableDefine arTableDefine = EntityMetadataCache.loadTableDefine((String)"ar_finarbill", (String)"ar_finarbill");
        Long arTableId = arTableDefine.getTableId();
        TableDefine apTableDefine = EntityMetadataCache.loadTableDefine((String)"ap_finapbill", (String)"ap_finapbill");
        Long apTableId = apTableDefine.getTableId();
        for (Long payId : paymentBillPks) {
            List nodes = linkUpNodeList.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(payId) == 0).collect(Collectors.toList());
            ArrayList<BFRowLinkUpNode> arOrApsrcNodes = new ArrayList<BFRowLinkUpNode>(10);
            for (BFRowLinkUpNode node : nodes) {
                List<BFRowLinkUpNode> sourceNodes = PayBillBotpSettleMatchValidator.findSourceNodes(node, arTableId, apTableId, payId);
                arOrApsrcNodes.addAll(sourceNodes);
            }
            if (arOrApsrcNodes.isEmpty()) continue;
            List srcIdList = arOrApsrcNodes.stream().map(srcNode -> srcNode.getRowId().getBillId()).collect(Collectors.toList());
            Long tableId = ((BFRowLinkUpNode)arOrApsrcNodes.get(0)).getRowId().getMainTableId();
            if (arTableId.compareTo(tableId) == 0) {
                srcArBillIdSet.add(payId);
                arBillIdSet.addAll(srcIdList);
                continue;
            }
            if (apTableId.compareTo(tableId) != 0) continue;
            srcApBillIdSet.add(payId);
            apBillIdSet.addAll(srcIdList);
        }
        if (!srcApBillIdSet.isEmpty()) {
            return this.apPaySettleMatchCheck(payMentTypeToEntryId, srcApBillIdSet, apBillIdSet);
        }
        if (!srcArBillIdSet.isEmpty()) {
            return this.arPaySettleMatchCheck(payMentTypeToEntryId, srcArBillIdSet, arBillIdSet);
        }
        return result;
    }

    private Map<Long, String> arPaySettleMatchCheck(Map<Long, DynamicObject> payMentTypeToEntryId, Set<Long> srcArBillIdSet, Set<Long> arBillIdSet) {
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        DynamicObject[] assts = PayBillHandleHelper.load("cas_paybill", new QFilter[]{new QFilter("id", "in", srcArBillIdSet)});
        if (assts.length == 0) {
            return result;
        }
        List<BillSettleVO> asstList = PayBillHandleHelper.getAsstListVO(assts);
        if (asstList.size() == 0) {
            return result;
        }
        Map<Long, BillSettleVO> asstListVoMap = asstList.stream().collect(Collectors.toMap(BillSettleVO::getEntryId, e -> e));
        Map<Long, Set<Long>> idMap = this.groupByOrg(arBillIdSet, "ar_finarbill");
        block0: for (Map.Entry<Long, Set<Long>> mapEntry : idMap.entrySet()) {
            List<BillSettleVO> mainList;
            Long orgId = mapEntry.getKey();
            Set<Long> arBillIds = mapEntry.getValue();
            SettleSchemeVO scheme = new SettleSchemeVO();
            scheme.setOnlyByBotp(true);
            int settleParam = ArApHelper.getArSettleParam(orgId);
            scheme.setSettleEntryParam(settleParam);
            DynamicObject[] mains = FinArBillHandleHelper.load(new QFilter[]{new QFilter("id", "in", arBillIds)});
            if (mains.length == 0 || (mainList = FinArBillHandleHelper.getMainListVO(mains, scheme)).size() == 0) continue;
            Map<Long, BillSettleVO> mainListVoMap = mainList.stream().collect(Collectors.toMap(BillSettleVO::getEntryId, e -> e));
            String mainBillEntity = mainList.get(0).getBillEntity();
            Map<Long, Long> botpMap = this.loadEntryRelationMapping(mainBillEntity, asstList);
            for (Map.Entry<Long, Long> entryRelation : botpMap.entrySet()) {
                Long asstEntryId = entryRelation.getKey();
                Long mainEntryId = entryRelation.getValue();
                BillSettleVO asst = asstListVoMap.get(asstEntryId);
                BillSettleVO main = mainListVoMap.get(mainEntryId);
                result.putAll(this.matchCheck(payMentTypeToEntryId, asstEntryId, asst, main));
                if (result.size() <= 0) continue;
                continue block0;
            }
        }
        return result;
    }

    private Map<Long, String> apPaySettleMatchCheck(Map<Long, DynamicObject> payMentTypeToEntryId, Set<Long> srcApBillIdSet, Set<Long> apBillIdSet) {
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        DynamicObject[] assts = PayBillHandleHelper.load("cas_paybill", new QFilter[]{new QFilter("id", "in", srcApBillIdSet)});
        if (assts.length == 0) {
            return result;
        }
        List<BillSettleVO> asstList = PayBillHandleHelper.getAsstListVO(assts);
        if (asstList.size() == 0) {
            return result;
        }
        Map<Long, BillSettleVO> asstListVoMap = asstList.stream().collect(Collectors.toMap(BillSettleVO::getEntryId, e -> e));
        Map<Long, Set<Long>> idMap = this.groupByOrg(apBillIdSet, "ap_finapbill");
        block0: for (Map.Entry<Long, Set<Long>> mapEntry : idMap.entrySet()) {
            List<BillSettleVO> mainList;
            Long orgId = mapEntry.getKey();
            Set<Long> apBillIds = mapEntry.getValue();
            SettleSchemeVO scheme = new SettleSchemeVO();
            scheme.setOnlyByBotp(true);
            int settleParam = ArApHelper.getApSettleParam(orgId);
            scheme.setSettleEntryParam(settleParam);
            DynamicObject[] mains = FinApBillHandleHelper.load(new QFilter[]{new QFilter("id", "in", apBillIds)});
            if (mains.length == 0 || (mainList = FinApBillHandleHelper.getMainListVO(mains, scheme)).size() == 0) continue;
            Map<Long, BillSettleVO> mainListVoMap = mainList.stream().collect(Collectors.toMap(BillSettleVO::getEntryId, e -> e));
            String mainBillEntity = mainList.get(0).getBillEntity();
            Map<Long, Long> botpMap = this.loadEntryRelationMapping(mainBillEntity, asstList);
            for (Map.Entry<Long, Long> entryRelation : botpMap.entrySet()) {
                Long asstEntryId = entryRelation.getKey();
                Long mainEntryId = entryRelation.getValue();
                BillSettleVO asst = asstListVoMap.get(asstEntryId);
                BillSettleVO main = mainListVoMap.get(mainEntryId);
                result.putAll(this.matchCheck(payMentTypeToEntryId, asstEntryId, asst, main));
                if (result.size() <= 0) continue;
                continue block0;
            }
        }
        return result;
    }

    private Map<Long, String> matchCheck(Map<Long, DynamicObject> payMentTypeToEntryId, Long asstEntryId, BillSettleVO asst, BillSettleVO main) {
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        if (main == null || asst == null) {
            return result;
        }
        if (main.getOrgId() == asst.getOrgId()) {
            DynamicObject payMentType = payMentTypeToEntryId.get(asstEntryId);
            boolean ispartpayment = payMentType.getBoolean("ispartpayment");
            if ("ap_finapbill".equals(main.getBillEntity()) && "cas_paybill".equals(asst.getBillEntity())) {
                if (!ispartpayment) {
                    result.put(asst.getId(), String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\uff0c\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u201c%1$s\u201d\u4e0d\u6ee1\u8db3\u5e94\u4ed8\u4ed8\u6b3e\u7ed3\u7b97\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a\u4ed8\u6b3e\u5355\u7684\u4ed8\u6b3e\u7c7b\u578b\u672a\u52fe\u9009\u53c2\u4e0e\u5e94\u4ed8\u7ed3\u7b97\u3002", (String)"PayBillBotpSettleMatchValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), main.getBillNo()));
                    return result;
                }
                if (main.getCurrencyId() != asst.getCurrencyId()) {
                    result.put(asst.getId(), String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\uff0c\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u201c%1$s\u201d\u4e0d\u6ee1\u8db3\u5e94\u4ed8\u4ed8\u6b3e\u7ed3\u7b97\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a\u4ed8\u6b3e\u5355\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u7ed3\u7b97\u5e01\u79cd\u662f\u5426\u4e00\u81f4\u3002", (String)"PayBillBotpSettleMatchValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), main.getBillNo()));
                    return result;
                }
                if (main.getEntryUnSettleAmt().signum() != asst.getEntryUnSettleAmt().signum() || main.getEntryUnSettleAmt().abs().compareTo(asst.getEntryUnSettleAmt().abs()) < 0) {
                    result.put(asst.getId(), String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\uff0c\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u201c%1$s\u201d\u4e0d\u6ee1\u8db3\u5e94\u4ed8\u4ed8\u6b3e\u7ed3\u7b97\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a1.\u4ed8\u6b3e\u5355\u7684\u672a\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u672a\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff1b2.\u4ed8\u6b3e\u5355\u7684\u672a\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u8d22\u52a1\u5e94\u4ed8\u5355\u672a\u7ed3\u7b97\u91d1\u989d\u3002", (String)"PayBillBotpSettleMatchValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), main.getBillNo()));
                    return result;
                }
            }
            if ("ar_finarbill".equals(main.getBillEntity()) && "cas_paybill".equals(asst.getBillEntity())) {
                if (!ispartpayment) {
                    result.put(asst.getId(), String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\uff0c\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u6536\u5355\u201c%1$s\u201d\u4e0d\u6ee1\u8db3\u5e94\u6536\u9000\u6b3e\u7ed3\u7b97\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a\u4ed8\u6b3e\u5355\u7684\u4ed8\u6b3e\u7c7b\u578b\u672a\u52fe\u9009\u53c2\u4e0e\u5e94\u4ed8\u7ed3\u7b97\u3002", (String)"PayBillBotpSettleMatchValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]), main.getBillNo()));
                    return result;
                }
                if (main.getCurrencyId() != asst.getCurrencyId()) {
                    result.put(asst.getId(), String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\uff0c\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u6536\u5355\u201c%1$s\u201d\u4e0d\u6ee1\u8db3\u5e94\u6536\u9000\u6b3e\u7ed3\u7b97\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a\u4ed8\u6b3e\u5355\u4e0e\u8d22\u52a1\u5e94\u6536\u5355\u7684\u7ed3\u7b97\u5e01\u79cd\u662f\u5426\u4e00\u81f4\u3002", (String)"PayBillBotpSettleMatchValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]), main.getBillNo()));
                    return result;
                }
                if (main.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) >= 0 || asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) <= 0 || main.getEntryUnSettleAmt().abs().compareTo(asst.getEntryUnSettleAmt()) < 0) {
                    result.put(asst.getId(), String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\uff0c\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u6536\u5355\u201c%1$s\u201d\u4e0d\u6ee1\u8db3\u5e94\u6536\u9000\u6b3e\u7ed3\u7b97\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a1.\u4ed8\u6b3e\u5355\u7684\u672a\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u4e0e\u8d22\u52a1\u5e94\u6536\u5355\u672a\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u5f02\u5e38\uff1b2.\u4ed8\u6b3e\u5355\u7684\u672a\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u8d22\u52a1\u5e94\u6536\u5355\u672a\u7ed3\u7b97\u91d1\u989d\u7684\u7edd\u5bf9\u503c\u3002", (String)"PayBillBotpSettleMatchValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]), main.getBillNo()));
                    return result;
                }
            }
        }
        return result;
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long arTableId, Long apTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        Long mainTableId = node.getRowId().getMainTableId();
        if ((mainTableId.compareTo(arTableId) == 0 || mainTableId.compareTo(apTableId) == 0) && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(PayBillBotpSettleMatchValidator.findSourceNodes(sNode, arTableId, apTableId, id));
            }
        }
        return nodes;
    }

    private Map<Long, Set<Long>> groupByOrg(Set<Long> billIdSet, String billEntity) {
        HashMap<Long, Set<Long>> idMap = new HashMap<Long, Set<Long>>(2);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"groupByOrg", (String)billEntity, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)}, (String)"");
        for (Row row : dataSet) {
            Long orgId = row.getLong("org");
            Long id = row.getLong("id");
            HashSet<Long> ids = (HashSet<Long>)idMap.get(orgId);
            if (ids == null) {
                ids = new HashSet<Long>(billIdSet.size());
            }
            ids.add(id);
            idMap.put(orgId, ids);
        }
        return idMap;
    }

    private Map<Long, Long> loadEntryRelationMapping(String mainBillEntity, List<BillSettleVO> asstList) {
        String asstBill = asstList.get(0).getBillEntity();
        String entryType = asstList.get(0).getEntryEntity();
        HashSet<Long> asstIds = new HashSet<Long>(asstList.size());
        HashSet<Long> asstEntryIds = new HashSet<Long>(asstList.size());
        for (BillSettleVO asst : asstList) {
            asstIds.add(asst.getId());
            asstEntryIds.add(asst.getEntryId());
        }
        return BOTPHelper.loadSourceRowIdsMap(asstBill, entryType, asstIds.toArray(new Long[0]), asstEntryIds.toArray(new Long[0]), mainBillEntity);
    }
}

