/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class PayPropertyBaseOnAmtValidator
extends AbstractValidator {
    public void validate() {
        String entityKey = this.entityKey;
        BillModel model = BillModelFactory.getModel(entityKey);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entries;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject payproperty = bill.getDynamicObject(model.HEAD_PAYPROPERTY);
            if (ObjectUtils.isEmpty((Object)payproperty)) {
                return;
            }
            if (!payproperty.getBoolean("isbasedonamt") || ObjectUtils.isEmpty((Object)(entries = bill.getDynamicObjectCollection(model.ENTRY)))) continue;
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                BigDecimal quantity = entry.getBigDecimal(model.E_QUANTITY);
                if (quantity.abs().compareTo(BigDecimal.ONE) == 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%d\u884c\uff1a\u91d1\u989d\u57fa\u51c6\u4e1a\u52a1\uff0c\u6570\u91cf\u5e94\u4e3a1\u6216-1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayPropertyBaseOnAmtValidator_0", (String)"fi-arapcommon", (Object[])new Object[]{i + 1}));
            }
        }
    }
}

