/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.StringUtils;

public class RPASettleSchemeSaveValidator
extends AbstractValidator {
    private Map<Long, Object> arParamMap = new HashMap<Long, Object>(128);
    private Map<Long, Object> apParamMap = new HashMap<Long, Object>(128);

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        this.getOrgParam(datas);
        for (ExtendedDataEntity data : datas) {
            this.validateRuleEntry(data);
            this.validateOrgEntry(data);
            this.validateRPAScheme(data);
        }
    }

    private void validateRuleEntry(ExtendedDataEntity data) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection ruleEntry = info.getDynamicObjectCollection("ruleentry");
        if (ruleEntry == null || ruleEntry.size() == 0) {
            this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u5206\u5f55\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"RPASettleSchemeSaveValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private void validateOrgEntry(ExtendedDataEntity data) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection orgEntry = info.getDynamicObjectCollection("orgentry");
        boolean isOrgAllEmpty = true;
        if (orgEntry != null && orgEntry.size() > 0) {
            for (DynamicObject entry : orgEntry) {
                DynamicObject org = entry.getDynamicObject("org");
                if (ObjectUtils.isEmpty((Object)org)) continue;
                isOrgAllEmpty = false;
            }
        }
        if (isOrgAllEmpty) {
            this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u5206\u5f55\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"SettleSchemeSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> orgPkList = new ArrayList<Object>(orgEntry.size());
        for (DynamicObject entry : orgEntry) {
            DynamicObject org = entry.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            if (orgPkList.contains(org.getPkValue())) {
                this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u201c\u9002\u7528\u7ec4\u7ec7\u201d\u5206\u5f55\u6709\u91cd\u590d\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RPASettleSchemeSaveValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                break;
            }
            orgPkList.add(org.getPkValue());
        }
    }

    private void validateRPAScheme(ExtendedDataEntity data) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection ruleEntries = info.getDynamicObjectCollection("ruleentry");
        DynamicObjectCollection orgEntries = info.getDynamicObjectCollection("orgentry");
        int ruleSize = ruleEntries.size();
        int orgSize = orgEntries.size();
        for (int i = 0; i < orgSize; ++i) {
            DynamicObject orgEntry = (DynamicObject)orgEntries.get(i);
            Object settlemodel = orgEntry.get("settlemodel");
            DynamicObject org = orgEntry.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            String orgName = org.getString("name");
            for (int j = 0; j < ruleSize; ++j) {
                String format;
                QFilter filterGridValue;
                DynamicObject ruleEntry = (DynamicObject)ruleEntries.get(j);
                String settlerelation = ruleEntry.getString("settlerelation");
                if (this.isNoValidate(settlerelation)) continue;
                String mainbill = ruleEntry.getString("mainbill");
                String asstbill = ruleEntry.getString("asstbill");
                String matchFieldInfo = ruleEntry.getString("matchfieldinfo");
                int mainFilterSeq = -1;
                int asstFilterSeq = -1;
                int mainMatchFieldSeq = -1;
                int asstMatchFieldSeq = -1;
                if ("ar_finarbill".equals(mainbill) || "ap_finapbill".equals(mainbill)) {
                    String mainfilter_tag = ruleEntry.getString("mainfilter_tag");
                    filterGridValue = RPASettleSchemeSaveValidator.getFilterGridValue(mainbill, mainfilter_tag);
                    mainFilterSeq = this.validateSettleModel(filterGridValue, settlemodel);
                    mainMatchFieldSeq = this.validateSettleModel(matchFieldInfo, settlemodel, true);
                }
                if ("ar_finarbill".equals(asstbill) || "ap_finapbill".equals(asstbill)) {
                    String asstfilter_tag = ruleEntry.getString("asstfilter_tag");
                    filterGridValue = RPASettleSchemeSaveValidator.getFilterGridValue(asstbill, asstfilter_tag);
                    Object asstSettleModel = settlemodel;
                    if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settlerelation) && "ap_finapbill".equals(asstbill)) {
                        asstSettleModel = this.apParamMap.get(org.getLong("id"));
                    } else if (SettleRelationEnum.APARSETTLE.getValue().equals(settlerelation) && "ar_finarbill".equals(asstbill)) {
                        asstSettleModel = this.arParamMap.get(org.getLong("id"));
                    }
                    asstFilterSeq = this.validateSettleModel(filterGridValue, asstSettleModel);
                    if (mainMatchFieldSeq == -1) {
                        asstMatchFieldSeq = this.validateSettleModel(matchFieldInfo, asstSettleModel, false);
                    }
                }
                if (mainFilterSeq != -1) {
                    format = ResManager.loadKDString((String)"\u89c4\u5219\u5e8f\u53f7%1$s\uff1a\u4e3b\u65b9\u5355\u636e\u914d\u7f6e\u7684\u57fa\u672c\u6761\u4ef6\u7b2c%2$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%3$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RPASettleSchemeSaveValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]);
                    this.addFatalErrorMessage(data, String.format(format, j + 1, mainFilterSeq + 1, orgName));
                }
                if (asstFilterSeq != -1) {
                    format = ResManager.loadKDString((String)"\u89c4\u5219\u5e8f\u53f7%1$s\uff1a\u8f85\u65b9\u5355\u636e\u914d\u7f6e\u7684\u57fa\u672c\u6761\u4ef6\u7b2c%2$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%3$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RPASettleSchemeSaveValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]);
                    this.addFatalErrorMessage(data, String.format(format, j + 1, asstFilterSeq + 1, orgName));
                }
                if (mainMatchFieldSeq != -1) {
                    format = ResManager.loadKDString((String)"\u89c4\u5219\u5e8f\u53f7%1$s\uff1a\u4e3b\u65b9\u5355\u636e\u914d\u7f6e\u7684\u5339\u914d\u6761\u4ef6\u7b2c%2$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%3$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RPASettleSchemeSaveValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]);
                    this.addFatalErrorMessage(data, String.format(format, j + 1, mainMatchFieldSeq + 1, orgName));
                }
                if (asstMatchFieldSeq == -1) continue;
                format = ResManager.loadKDString((String)"\u89c4\u5219\u5e8f\u53f7%1$s\uff1a\u8f85\u65b9\u5355\u636e\u914d\u7f6e\u7684\u5339\u914d\u6761\u4ef6\u7b2c%2$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%3$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RPASettleSchemeSaveValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]);
                this.addFatalErrorMessage(data, String.format(format, j + 1, asstMatchFieldSeq + 1, orgName));
            }
        }
    }

    private boolean isNoValidate(String settleRelation) {
        return SettleRelationEnum.RECSELF.getValue().equals(settleRelation) || SettleRelationEnum.PAYSELF.getValue().equals(settleRelation);
    }

    private int validateSettleModel(QFilter filterGridValue, Object settlemodel) {
        ArrayList<String> propertyList = new ArrayList<String>(4);
        List recursiveNests = filterGridValue.getNests(true);
        propertyList.add(filterGridValue.getProperty());
        for (QFilter.QFilterNest nest : recursiveNests) {
            QFilter filter = nest.getFilter();
            String propertyName = filter.getProperty();
            if (propertyList.contains(propertyName)) continue;
            propertyList.add(propertyName);
        }
        if ("1".equals(settlemodel)) {
            for (int i = 0; i < propertyList.size(); ++i) {
                if (!((String)propertyList.get(i)).startsWith("planentity.")) continue;
                return i;
            }
        } else {
            for (int i = 0; i < propertyList.size(); ++i) {
                if (!((String)propertyList.get(i)).startsWith("entry.") && !((String)propertyList.get(i)).startsWith("detailentry.")) continue;
                return i;
            }
        }
        return -1;
    }

    private int validateSettleModel(String matchFieldInfo, Object settlemodel, boolean isMain) {
        if (StringUtils.isNotEmpty(matchFieldInfo)) {
            String key = isMain ? "mainfield" : "asstfield";
            List fieldEntrys = (List)SerializationUtils.fromJsonString((String)matchFieldInfo, List.class);
            for (int i = 0; i < fieldEntrys.size(); ++i) {
                String field = (String)((Map)fieldEntrys.get(i)).get(key);
                if (!("1".equals(settlemodel) ? field.startsWith("planentity.") : field.startsWith("entry.") || field.startsWith("detailentry."))) continue;
                return i;
            }
        }
        return -1;
    }

    public static QFilter getFilterGridValue(String entityName, String exprission) {
        CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)exprission, CRCondition.class);
        FilterCondition filterCondition = conditionObj.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    private void getOrgParam(ExtendedDataEntity[] datas) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(128);
        for (ExtendedDataEntity data : datas) {
            DynamicObject info = data.getDataEntity();
            DynamicObjectCollection orgEntries = info.getDynamicObjectCollection("orgentry");
            for (DynamicObject orgEntry : orgEntries) {
                DynamicObject org = orgEntry.getDynamicObject("org");
                if (ObjectUtils.isEmpty((Object)org)) continue;
                orgIdList.add(org.getLong("id"));
            }
        }
        this.arParamMap = SystemParameterHelper.batchGetAppParameter(Boolean.TRUE, orgIdList, "ar_003");
        this.apParamMap = SystemParameterHelper.batchGetAppParameter(Boolean.FALSE, orgIdList, "ap_003");
    }
}

