/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.arapcommon.vo.ReconciliationParam;

public class ReconciliationValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ReconciliationValidator.class);
    private boolean isAr;

    public void validate() {
        this.isAr = "ar_init".equals(this.entityKey);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            this.chkReconcile(dataEntity, info);
        }
    }

    private void chkReconcile(ExtendedDataEntity dataEntity, DynamicObject info) {
        DynamicObject org = info.getDynamicObject("org");
        long orgPk = (Long)org.getPkValue();
        String orgName = org.getLocaleString("name").getLocaleValue();
        ReconciliationParam param = new ReconciliationParam();
        param.setPeriodId(info.getDynamicObject("startperiod").getLong("id"));
        if (this.isAr) {
            param.setAppNumber("ar");
            param.setBizBookId(info.getLong("policyid"));
        } else {
            param.setAppNumber("ap");
        }
        param.setOrgId(orgPk);
        param.setOriResult(true);
        param.setInit(true);
        try {
            String openParam = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{JSONObject.toJSONString((Object)param)});
            logger.info("ai-execute result : " + openParam);
        }
        catch (KDBizException e) {
            String msg = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a \u7ed3\u675f\u521d\u59cb\u5316\u5931\u8d25\uff0c\u4e0e\u603b\u8d26\u5bf9\u8d26\u4e0d\u5e73\u3002\u8bf7\u8fdb\u884c\u5bf9\u8d26\u68c0\u67e5\u3002", (String)"ReconciliationValidator_1", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
            this.addErrorMessage(dataEntity, msg);
        }
        catch (Exception e) {
            String message = e.getMessage();
            throw new KDBizException(message);
        }
    }
}

