/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.StringUtils;

public class SettleSchemeSaveValidator
extends AbstractValidator {
    private final boolean isAr;
    private Map<Long, Object> arParamMap = new HashMap<Long, Object>(128);
    private Map<Long, Object> apParamMap = new HashMap<Long, Object>(128);

    public SettleSchemeSaveValidator(boolean isAr) {
        this.isAr = isAr;
    }

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        this.getOrgParam(datas);
        for (ExtendedDataEntity data : datas) {
            this.validateRuleEntry(data);
            this.validateOrgEntry(data);
            this.validateScheme(data);
        }
    }

    private void validateRuleEntry(ExtendedDataEntity data) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection ruleEntry = info.getDynamicObjectCollection("ruleentry");
        if (ruleEntry == null || ruleEntry.size() == 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u5206\u5f55\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"SettleSchemeSaveValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private void validateOrgEntry(ExtendedDataEntity data) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection orgEntry = info.getDynamicObjectCollection("orgentry");
        boolean isOrgAllEmpty = true;
        if (orgEntry != null && orgEntry.size() > 0) {
            for (DynamicObject entry : orgEntry) {
                DynamicObject org = entry.getDynamicObject("org");
                if (ObjectUtils.isEmpty((Object)org)) continue;
                isOrgAllEmpty = false;
            }
        }
        if (isOrgAllEmpty) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u5206\u5f55\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"SettleSchemeSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> orgPkList = new ArrayList<Object>(orgEntry.size());
        for (DynamicObject entry : orgEntry) {
            DynamicObject org = entry.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            if (orgPkList.contains(org.getPkValue())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u5206\u5f55\u6709\u91cd\u590d\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SettleSchemeSaveValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                break;
            }
            orgPkList.add(org.getPkValue());
        }
    }

    private void validateScheme(ExtendedDataEntity data) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection orgEntry = info.getDynamicObjectCollection("orgentry");
        if (orgEntry == null || orgEntry.size() == 0) {
            return;
        }
        DynamicObjectCollection ruleEntry = info.getDynamicObjectCollection("ruleentry");
        for (DynamicObject rule : ruleEntry) {
            String settleRelation = rule.getString("settlerelation");
            if (!this.isValidateScheme(settleRelation)) continue;
            List<String> entities = SettleRelationEnum.getEntityByRelation(settleRelation);
            String mainName = entities.get(0);
            String asstName = StringUtils.isNotEmpty(rule.getString("asstbill")) ? rule.getString("asstbill") : entities.get(1);
            String mainDateSrc = rule.getString("maindatesrc");
            String asstDateSrc = rule.getString("asstdatesrc");
            this.validateSettleEntry(mainName, mainDateSrc, data);
            this.validateSettleEntry(asstName, asstDateSrc, data);
        }
        this.validateFilterAndMatchField(data);
    }

    private void validateFilterAndMatchField(ExtendedDataEntity data) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection orgEntryColl = info.getDynamicObjectCollection("orgentry");
        if (orgEntryColl == null || orgEntryColl.size() == 0) {
            return;
        }
        ILocaleString schemeName = info.getLocaleString("name");
        DynamicObjectCollection ruleEntry = info.getDynamicObjectCollection("ruleentry");
        for (DynamicObject orgEntry : orgEntryColl) {
            DynamicObject org = orgEntry.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            ILocaleString orgName = org.getLocaleString("name");
            for (int i = 0; i < ruleEntry.size(); ++i) {
                String format;
                DynamicObject rule = (DynamicObject)ruleEntry.get(i);
                String settleRelation = rule.getString("settlerelation");
                if (!this.isValidateScheme(settleRelation)) continue;
                int settlemodel = 1;
                settlemodel = this.isAr ? Integer.parseInt((String)this.arParamMap.get(org.getLong("id"))) : Integer.parseInt((String)this.apParamMap.get(org.getLong("id")));
                List<String> entities = SettleRelationEnum.getEntityByRelation(settleRelation);
                String mainbill = entities.get(0);
                String asstbill = StringUtils.isNotEmpty(rule.getString("asstbill")) ? rule.getString("asstbill") : entities.get(1);
                String matchFieldInfo = rule.getString("matchfieldinfo");
                int mainFilterSeq = -1;
                int asstFilterSeq = -1;
                int mainMatchFieldSeq = -1;
                int asstMatchFieldSeq = -1;
                if ("ar_finarbill".equals(mainbill) || "ap_finapbill".equals(mainbill)) {
                    String mainfilter_tag = rule.getString("mainfilter_tag");
                    if (!ObjectUtils.isEmpty((Object)mainfilter_tag)) {
                        QFilter filterGridValue = this.getFilterGridValue(mainbill, mainfilter_tag);
                        mainFilterSeq = this.validateSettleModel(filterGridValue, settlemodel);
                    }
                    mainMatchFieldSeq = this.validateSettleModel(matchFieldInfo, settlemodel, true);
                }
                if ("ar_finarbill".equals(asstbill) || "ap_finapbill".equals(asstbill)) {
                    String asstfilter_tag = rule.getString("asstfilter_tag");
                    int asstSettleModel = settlemodel;
                    if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) && "ap_finapbill".equals(asstbill)) {
                        asstSettleModel = Integer.parseInt((String)this.apParamMap.get(org.getLong("id")));
                    } else if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) && "ar_finarbill".equals(asstbill)) {
                        asstSettleModel = Integer.parseInt((String)this.arParamMap.get(org.getLong("id")));
                    }
                    if (!ObjectUtils.isEmpty((Object)asstfilter_tag)) {
                        QFilter filterGridValue = this.getFilterGridValue(asstbill, asstfilter_tag);
                        asstFilterSeq = this.validateSettleModel(filterGridValue, asstSettleModel);
                    }
                    if (mainMatchFieldSeq == -1) {
                        asstMatchFieldSeq = this.validateSettleModel(matchFieldInfo, asstSettleModel, false);
                    }
                }
                if (mainFilterSeq != -1) {
                    format = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u6848%1$s\u7b2c%2$s\u4e2a\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u4e3b\u65b9\u5355\u636e\u914d\u7f6e\u7684\u9002\u7528\u6761\u4ef6\u7b2c%3$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%4$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SettleSchemeExecuteValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]);
                    this.addFatalErrorMessage(data, String.format(format, schemeName, i + 1, mainFilterSeq + 1, orgName));
                }
                if (asstFilterSeq != -1) {
                    format = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u6848%1$s\u7b2c%2$s\u4e2a\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u8f85\u65b9\u5355\u636e\u914d\u7f6e\u7684\u9002\u7528\u6761\u4ef6\u7b2c%3$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%4$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SettleSchemeExecuteValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]);
                    this.addFatalErrorMessage(data, String.format(format, schemeName, i + 1, asstFilterSeq + 1, orgName));
                }
                if (mainMatchFieldSeq != -1) {
                    format = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u6848%1$s\u7b2c%2$s\u4e2a\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u4e3b\u65b9\u5355\u636e\u914d\u7f6e\u7684\u5339\u914d\u6761\u4ef6\u7b2c%3$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%4$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SettleSchemeExecuteValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]);
                    this.addFatalErrorMessage(data, String.format(format, schemeName, i + 1, mainMatchFieldSeq + 1, orgName));
                }
                if (asstMatchFieldSeq == -1) continue;
                format = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u6848%1$s\u7b2c%2$s\u4e2a\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u8f85\u65b9\u5355\u636e\u914d\u7f6e\u7684\u5339\u914d\u6761\u4ef6\u7b2c%3$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%4$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SettleSchemeExecuteValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]);
                this.addFatalErrorMessage(data, String.format(format, schemeName, i + 1, asstMatchFieldSeq + 1, orgName));
            }
        }
    }

    private void validateSettleEntry(String number, String dateSrc, ExtendedDataEntity data) {
        DynamicProperty property;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        if (dateSrc.contains(".")) {
            dateSrc = dateSrc.split("\\.")[1];
        }
        if ((property = mainType.getProperty(dateSrc)) == null) {
            if (this.isSettleEntrySame(data)) {
                int settleEntry = this.getSettleEntry(data);
                boolean isError = false;
                if (settleEntry == 1 && ("ar_finarbill".equals(number) && ((EntityType)mainType.getAllEntities().get("planentity")).getProperty(dateSrc) != null || "ap_finapbill".equals(number) && ((EntityType)mainType.getAllEntities().get("planentity")).getProperty(dateSrc) != null)) {
                    isError = true;
                }
                if (settleEntry == 2 && ("ar_finarbill".equals(number) && ((EntityType)mainType.getAllEntities().get("entry")).getProperty(dateSrc) != null || "ap_finapbill".equals(number) && ((EntityType)mainType.getAllEntities().get("detailentry")).getProperty(dateSrc) != null)) {
                    isError = true;
                }
                if (isError) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u5206\u5f55\u5b58\u5728\u4e0e\u9002\u7528\u7ec4\u7ec7.\u7ed3\u7b97\u6a21\u578b\u4e0d\u7b26\u7684\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SettleSchemeSaveValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
            } else {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u5206\u5f55\u5b58\u5728\u5206\u5f55\u5b57\u6bb5\uff0c\u4f46\u9002\u7528\u7ec4\u7ec7.\u7ed3\u7b97\u6a21\u578b\u4e0d\u540c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SettleSchemeSaveValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }

    private int getSettleEntry(ExtendedDataEntity data) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection orgEntry = info.getDynamicObjectCollection("orgentry");
        if (this.isAr) {
            return ArApHelper.getArSettleParam(((DynamicObject)orgEntry.get(0)).getDynamicObject("org").getPkValue());
        }
        return ArApHelper.getApSettleParam(((DynamicObject)orgEntry.get(0)).getDynamicObject("org").getPkValue());
    }

    private int getAsstSettleEntry(ExtendedDataEntity data, boolean isAr) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection orgEntry = info.getDynamicObjectCollection("orgentry");
        if (isAr) {
            return Integer.parseInt((String)this.arParamMap.get(((DynamicObject)orgEntry.get(0)).getDynamicObject("org").getLong("id")));
        }
        return Integer.parseInt((String)this.apParamMap.get(((DynamicObject)orgEntry.get(0)).getDynamicObject("org").getLong("id")));
    }

    private boolean isSettleEntrySame(ExtendedDataEntity data) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection orgEntry = info.getDynamicObjectCollection("orgentry");
        HashSet settleEntrySet = new HashSet(1);
        orgEntry.forEach(orgE -> {
            if (this.isAr) {
                settleEntrySet.add(ArApHelper.getArSettleParam(orgE.getDynamicObject("org").getPkValue()));
            } else {
                settleEntrySet.add(ArApHelper.getApSettleParam(orgE.getDynamicObject("org").getPkValue()));
            }
        });
        return settleEntrySet.size() != 2;
    }

    private boolean isValidateScheme(String settleRelation) {
        return !SettleRelationEnum.RECSELF.getValue().equals(settleRelation) && !SettleRelationEnum.PAYSELF.getValue().equals(settleRelation);
    }

    private QFilter getFilterGridValue(String entityName, String exprission) {
        CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)exprission, CRCondition.class);
        FilterCondition filterCondition = conditionObj.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    private int validateSettleModel(QFilter filterGridValue, int settlemodel) {
        ArrayList<String> propertyList = new ArrayList<String>(4);
        List recursiveNests = filterGridValue.getNests(true);
        propertyList.add(filterGridValue.getProperty());
        for (QFilter.QFilterNest nest : recursiveNests) {
            QFilter filter = nest.getFilter();
            String propertyName = filter.getProperty();
            if (propertyList.contains(propertyName)) continue;
            propertyList.add(propertyName);
        }
        if (settlemodel == 1) {
            for (int i = 0; i < propertyList.size(); ++i) {
                if (!((String)propertyList.get(i)).startsWith("planentity.")) continue;
                return i;
            }
        } else {
            for (int i = 0; i < propertyList.size(); ++i) {
                if (!((String)propertyList.get(i)).startsWith("entry.") && !((String)propertyList.get(i)).startsWith("detailentry.")) continue;
                return i;
            }
        }
        return -1;
    }

    private int validateSettleModel(String matchFieldInfo, int settlemodel, boolean isMain) {
        if (StringUtils.isNotEmpty(matchFieldInfo)) {
            String key = isMain ? "mainfield" : "asstfield";
            List fieldEntrys = (List)SerializationUtils.fromJsonString((String)matchFieldInfo, List.class);
            for (int i = 0; i < fieldEntrys.size(); ++i) {
                String field = (String)((Map)fieldEntrys.get(i)).get(key);
                if (!(settlemodel == 1 ? field.startsWith("planentity.") : field.startsWith("entry.") || field.startsWith("detailentry."))) continue;
                return i;
            }
        }
        return -1;
    }

    private void getOrgParam(ExtendedDataEntity[] datas) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(128);
        for (ExtendedDataEntity data : datas) {
            DynamicObject info = data.getDataEntity();
            DynamicObjectCollection orgEntries = info.getDynamicObjectCollection("orgentry");
            for (DynamicObject orgEntry : orgEntries) {
                DynamicObject org = orgEntry.getDynamicObject("org");
                if (ObjectUtils.isEmpty((Object)org)) continue;
                orgIdList.add(org.getLong("id"));
            }
        }
        this.arParamMap = SystemParameterHelper.batchGetAppParameter(Boolean.TRUE, orgIdList, "ar_003");
        this.apParamMap = SystemParameterHelper.batchGetAppParameter(Boolean.FALSE, orgIdList, "ap_003");
    }
}

