/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class SupplierandMaterial4VmiValidator
extends AbstractValidator {
    private Map<Long, Boolean> paramCache = new HashMap<Long, Boolean>(8);

    public void validate() {
        LinkedList<ExtendedDataEntity> entities = new LinkedList<ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject org;
            boolean param;
            DynamicObject bill = dataEntity.getDataEntity();
            String billSrctype = bill.getString("billsrctype");
            if (!BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype) && !BillSrcTypeEnum.GLIMPT.getValue().equals(billSrctype) || !(param = this.getParam((org = bill.getDynamicObject("org")).getLong("id"), this.isAr()).booleanValue())) continue;
            entities.add(dataEntity);
        }
        HashSet<Long> disableVmiSupplierIds = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : entities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject bizType = bill.getDynamicObject("biztype");
            if (ObjectUtils.isEmpty((Object)bizType) || !"6".equals(bizType.getString("domain"))) continue;
            String asstactType = bill.getString("asstacttype");
            if ("bd_supplier".equals(asstactType)) {
                DynamicObject asstact = bill.getDynamicObject("asstact");
                long asstactId = asstact.getLong("id");
                if (disableVmiSupplierIds.contains(asstactId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f80\u6765\u6237\u4e0e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SupplierandMaterial4VmiValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"enablevmi", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                if (!supplier.getBoolean("enablevmi")) {
                    disableVmiSupplierIds.add(asstactId);
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f80\u6765\u6237\u4e0e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SupplierandMaterial4VmiValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    continue;
                }
            }
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(this.getDetailEntryKey(this.entityKey));
            for (DynamicObject row : entry) {
                if (row.getBoolean(this.getMaterialKey(this.entityKey) + ".enablevmi")) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\u7269\u6599\u4e0e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SupplierandMaterial4VmiValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), row.getInt("seq")));
            }
        }
    }

    private boolean isAr() {
        boolean isAr = true;
        if (this.entityKey.startsWith("ap_")) {
            isAr = false;
        }
        return isAr;
    }

    private Boolean getParam(long orgId, boolean isAr) {
        Boolean param = this.paramCache.get(orgId);
        if (param != null) {
            return param;
        }
        String paramKey = "ap_025";
        if (isAr) {
            paramKey = "ar_025";
            param = SystemParameterHelper.getARBooleanParam(orgId, paramKey);
        } else {
            param = SystemParameterHelper.getAPBooleanParam(orgId, paramKey);
        }
        this.paramCache.put(orgId, param);
        return param;
    }

    private String getDetailEntryKey(String entityKey) {
        return "ap_finapbill".equals(entityKey) ? "detailentry" : "entry";
    }

    private String getMaterialKey(String entityKey) {
        return "ap_finapbill".equals(entityKey) ? "material" : "e_material";
    }
}

