/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator.amount;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.validator.amount.ValidateAndCorrectParam;
import kd.fi.arapcommon.validator.amount.ValidateStrategy;

public abstract class AbstractBillSubmitAmountValidator
extends AbstractValidator {
    protected boolean isInDataBase = false;

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        DynamicObject[] dataEntities = (DynamicObject[])Arrays.stream(datas).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        this.isInDataBase = ArApDataRepairHelper.isInBaseData(dataEntities);
        block0: for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            if (!BillStatusEnum.SAVE.getValue().equals(bill.getString("billstatus"))) continue;
            for (String entryKey : this.entryKeys()) {
                boolean isSkip;
                DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryKey);
                List<ValidateAndCorrectParam> entryParams = this.buildEntryValidateParam().get(entryKey);
                this.ValidateAndCorrectParamPostProcess(entryParams, data);
                List<ValidateAndCorrectParam> entrySumParams = this.buildEntrySumValidateParam().get(entryKey);
                for (DynamicObject entry : entries) {
                    isSkip = this.validateEntry(data, entryParams, bill, entry);
                    if (isSkip) continue block0;
                    this.sumEntry(entrySumParams, entry);
                }
                isSkip = this.validateEntrySumAndTotal(data, bill, entrySumParams);
                if (!isSkip) continue;
                continue block0;
            }
            List<ValidateAndCorrectParam> totalValidateParams = this.buildTotalValidateParam();
            this.ValidateAndCorrectParamPostTotalProcess(totalValidateParams, data);
            this.validateTotal(data, bill, totalValidateParams);
        }
    }

    private boolean validateEntry(ExtendedDataEntity data, List<ValidateAndCorrectParam> entryParams, DynamicObject bill, DynamicObject entry) {
        for (ValidateAndCorrectParam param : entryParams) {
            ValidateStrategy validateStrategy = param.getValidateStrategy();
            BigDecimal srcValue = entry.getBigDecimal(param.getSrcKey());
            BigDecimal tarValue = BigDecimal.ZERO;
            if (param.getTarKeys() != null) {
                for (String tarKey : param.getTarKeys()) {
                    tarValue = tarValue.add(entry.getBigDecimal(tarKey));
                }
            }
            if (validateStrategy.validate(bill, srcValue, tarValue)) continue;
            this.addErrorMessage(data, entry, param.getValidateInfo());
            return true;
        }
        return false;
    }

    private boolean validateTotal(ExtendedDataEntity data, DynamicObject bill, List<ValidateAndCorrectParam> totalValidateParams) {
        for (ValidateAndCorrectParam param : totalValidateParams) {
            ValidateStrategy validateStrategy = param.getValidateStrategy();
            BigDecimal srcValue = bill.getBigDecimal(param.getSrcKey());
            BigDecimal tarValue = BigDecimal.ZERO;
            if (param.getTarKeys() != null) {
                for (String tarKey : param.getTarKeys()) {
                    tarValue = tarValue.add(bill.getBigDecimal(tarKey));
                }
            }
            if (validateStrategy.validate(bill, srcValue, tarValue)) continue;
            if (param.isCorrectFlag()) {
                bill.set(param.getSrcKey(), (Object)tarValue);
                continue;
            }
            super.addErrorMessage(data, param.getValidateInfo());
            return true;
        }
        return false;
    }

    private boolean validateEntrySumAndTotal(ExtendedDataEntity data, DynamicObject bill, List<ValidateAndCorrectParam> entrySumParams) {
        for (ValidateAndCorrectParam param : entrySumParams) {
            BigDecimal tarValue;
            BigDecimal srcValue;
            ValidateStrategy validateStrategy = param.getValidateStrategy();
            if (validateStrategy.validate(bill, srcValue = bill.getBigDecimal(param.getSrcKey()), tarValue = param.getEntrySum())) continue;
            if (param.isCorrectFlag()) {
                bill.set(param.getSrcKey(), (Object)tarValue);
                continue;
            }
            super.addErrorMessage(data, param.getValidateInfo());
            return true;
        }
        return false;
    }

    private void sumEntry(List<ValidateAndCorrectParam> entrySumParams, DynamicObject entry) {
        for (ValidateAndCorrectParam param : entrySumParams) {
            String[] tarKey = param.getTarKeys();
            BigDecimal entryAmount = entry.getBigDecimal(tarKey[0]);
            param.setEntrySum(param.getEntrySum().add(entryAmount));
        }
    }

    private void addErrorMessage(ExtendedDataEntity dataEntity, DynamicObject row, String content) {
        String displayName = row.getDataEntityType().getDisplayName().getLocaleValue();
        String message = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c,%3$s", (String)"FinApBillSubmitAmountValidator_30", (String)"fi-ap-opplugin", (Object[])new Object[0]), displayName, row.get("seq"), content);
        super.addErrorMessage(dataEntity, message);
    }

    protected void ValidateAndCorrectParamPostProcess(List<ValidateAndCorrectParam> entryParams, ExtendedDataEntity data) {
    }

    protected void ValidateAndCorrectParamPostTotalProcess(List<ValidateAndCorrectParam> entryParams, ExtendedDataEntity data) {
    }

    protected abstract List<String> entryKeys();

    protected abstract Map<String, List<ValidateAndCorrectParam>> buildEntryValidateParam();

    protected abstract Map<String, List<ValidateAndCorrectParam>> buildEntrySumValidateParam();

    protected abstract List<ValidateAndCorrectParam> buildTotalValidateParam();
}

