/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator.paysecurity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.validator.paysecurity.BusValidatorResult;

public abstract class AbstractBusBillPaySecurityValidator {
    protected static final Log logger = LogFactory.getLog(AbstractBusBillPaySecurityValidator.class);
    protected boolean isValidataQty;
    protected boolean isValidataPrice;
    protected boolean isValidataAmt;

    public List<BusValidatorResult> validate(List<Long> billIds, String operateKey) {
        this.initValidataLevel();
        ArrayList<BusValidatorResult> results = new ArrayList<BusValidatorResult>(16);
        QFilter filter = new QFilter("id", "in", billIds);
        if (this.getFilter() != null) {
            filter.and(this.getFilter());
        }
        DataSet currentBills = QueryServiceHelper.queryDataSet((String)"paypecurity", (String)this.getTargetEntity(), (String)this.getSelector(), (QFilter[])new QFilter[]{filter}, null);
        for (Row row : currentBills.copy()) {
            BusValidatorResult result = new BusValidatorResult();
            result.setBillId(row.getLong("id"));
            result.setEntryId(row.getLong("entryid"));
            result.setBillNo(row.getString("billno"));
            result.setPrice(row.getBigDecimal("price"));
            result.setSeq(row.getInteger("seq"));
            result.setOrgId(row.getLong("org"));
            result.setQuantity(row.getBigDecimal("qty"));
            if (this.needSetPayproperty()) {
                Boolean isBasedonAmt = row.getBoolean("isbasedonamt");
                if (isBasedonAmt == null) {
                    isBasedonAmt = false;
                }
                result.setBasedonAmt(isBasedonAmt);
            }
            results.add(result);
        }
        HashSet<Long> busBillIds = new HashSet<Long>(16);
        HashSet<Long> busEntryIds = new HashSet<Long>(16);
        HashMap<Long, Long> currentEntryIdToBusEntryIds = new HashMap<Long, Long>(16);
        Map<Long, BusValidatorParam> busValidatorParams = this.getSourceBusBillMap(busBillIds, busEntryIds, currentBills, currentEntryIdToBusEntryIds, operateKey);
        if (busValidatorParams.size() == 0) {
            return new ArrayList<BusValidatorResult>(2);
        }
        this.validataPayproperty(results, currentEntryIdToBusEntryIds, busValidatorParams);
        if (this.isValidataPrice && !"save".equals(operateKey)) {
            this.validatePrice(results, currentEntryIdToBusEntryIds, busValidatorParams);
        }
        this.queryWoffBill(busEntryIds, busValidatorParams);
        this.querySameSrcBill(currentEntryIdToBusEntryIds.keySet(), busBillIds, busEntryIds, busValidatorParams);
        if (this.isValidataQty && !"save".equals(operateKey)) {
            this.validateQty(results, currentEntryIdToBusEntryIds, busValidatorParams);
        }
        this.validateAmt(results, currentEntryIdToBusEntryIds, busValidatorParams, operateKey);
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            String message = ((BusValidatorResult)iterator.next()).getMessage();
            if (message != null) continue;
            iterator.remove();
        }
        return results;
    }

    protected abstract boolean needSetPayproperty();

    protected void validataPayproperty(List<BusValidatorResult> results, Map<Long, Long> currentEntryIdToBusEntryIds, Map<Long, BusValidatorParam> busValidatorParams) {
        Long billId;
        HashMap<Long, BusValidatorResult> errBaseBillResult = new HashMap<Long, BusValidatorResult>(16);
        HashMap<Long, BusValidatorResult> differentDirection = new HashMap<Long, BusValidatorResult>(16);
        HashMap<Long, ArrayList<Integer>> differentDirSeqMap = new HashMap<Long, ArrayList<Integer>>(16);
        for (BusValidatorResult busValidatorResult : results) {
            BigDecimal busQty;
            Long entryId;
            Long srcBusEntryId;
            billId = busValidatorResult.getBillId();
            if (errBaseBillResult.get(billId) != null || (srcBusEntryId = currentEntryIdToBusEntryIds.get(entryId = busValidatorResult.getEntryId())) == null) continue;
            BusValidatorParam param = busValidatorParams.get(srcBusEntryId);
            boolean finIsAmtBase = busValidatorResult.isBasedonAmt();
            if (param == null) continue;
            boolean busIsAmtBase = param.isBasedonAmt();
            if (finIsAmtBase != busIsAmtBase) {
                errBaseBillResult.put(billId, busValidatorResult);
                this.setPayPropertyMessage(busValidatorResult);
                continue;
            }
            BigDecimal finQty = busValidatorResult.getQuantity();
            if (finQty.multiply(busQty = param.getQuantity()).compareTo(BigDecimal.ZERO) >= 0) continue;
            differentDirection.putIfAbsent(billId, busValidatorResult);
            ArrayList<Integer> seqs = (ArrayList<Integer>)differentDirSeqMap.get(billId);
            if (seqs == null) {
                seqs = new ArrayList<Integer>(16);
                seqs.add(busValidatorResult.getSeq());
                differentDirSeqMap.put(billId, seqs);
                continue;
            }
            seqs.add(busValidatorResult.getSeq());
        }
        if (differentDirection.size() > 0) {
            for (Map.Entry entry : differentDirection.entrySet()) {
                billId = (Long)entry.getKey();
                BusValidatorResult result = (BusValidatorResult)entry.getValue();
                List seqs = (List)differentDirSeqMap.get(billId);
                Collections.sort(seqs);
                this.setDirectionMessage(result, seqs);
            }
        }
    }

    protected void setDirectionMessage(BusValidatorResult result, List<Integer> seqs) {
    }

    protected void setPayPropertyMessage(BusValidatorResult result) {
    }

    protected void validatePrice(List<BusValidatorResult> results, Map<Long, Long> currentEntryIdToBusEntryIds, Map<Long, BusValidatorParam> busValidatorParams) {
        ArrayList<Map<String, Object>> toleranceParams = new ArrayList<Map<String, Object>>(16);
        for (BusValidatorResult result : results) {
            BigDecimal busPrice;
            BusValidatorParam param;
            Long entryId = result.getEntryId();
            BigDecimal price = result.getPrice();
            Long busEntryId = currentEntryIdToBusEntryIds.get(entryId);
            if (busEntryId == null || (param = busValidatorParams.get(busEntryId)) == null) continue;
            String busBillNo = param.getBillNo();
            result.setSrcBusNo(busBillNo);
            if (param.isBasedonAmt() || price.compareTo(busPrice = param.getPrice()) == 0) continue;
            Map<String, Object> toleranceParam = this.buildToleranceParam(entryId, param, price, busPrice);
            toleranceParams.add(toleranceParam);
        }
        if (toleranceParams.size() > 0) {
            this.compareToleranceAndWriteMessage(toleranceParams, results, "price");
        }
    }

    protected void validateAmt(List<BusValidatorResult> results, Map<Long, Long> currentEntryIdToBusEntryIds, Map<Long, BusValidatorParam> busValidatorParams, String operateKey) {
        if ("save".equals(operateKey) || !this.isValidataAmt) {
            return;
        }
        logger.info("validataamt by tolerancescheme start");
        ArrayList<Map<String, Object>> amtToleranceParams = new ArrayList<Map<String, Object>>(16);
        HashMap<Long, BusValidatorParam> amtEntryIdToBusParam = new HashMap<Long, BusValidatorParam>(16);
        for (BusValidatorResult busValidatorResult : results) {
            BusValidatorParam validatorParam;
            Long entryId = busValidatorResult.getEntryId();
            Long busEntryId = currentEntryIdToBusEntryIds.get(entryId);
            if (busEntryId == null || (validatorParam = busValidatorParams.get(busEntryId)) == null) continue;
            String busBillNo = validatorParam.getBillNo();
            busValidatorResult.setSrcBusNo(busBillNo);
            if (!validatorParam.isBasedonAmt()) continue;
            amtEntryIdToBusParam.put(entryId, validatorParam);
        }
        for (Map.Entry entry : amtEntryIdToBusParam.entrySet()) {
            Map<String, Object> toleranceParam;
            BigDecimal sumAmt;
            BusValidatorParam validatorParam = (BusValidatorParam)entry.getValue();
            BigDecimal busAmt = validatorParam.getAmount();
            if (busAmt.compareTo(sumAmt = validatorParam.getSumAmount()) == 0 || (toleranceParam = this.buildToleranceParam((Long)entry.getKey(), validatorParam, sumAmt, busAmt)).size() == 0) continue;
            amtToleranceParams.add(toleranceParam);
        }
        if (amtToleranceParams.size() > 0) {
            this.compareToleranceAndWriteMessage(amtToleranceParams, results, "amount");
        }
    }

    protected void validateQty(List<BusValidatorResult> results, Map<Long, Long> currentEntryIdToBusEntryIds, Map<Long, BusValidatorParam> busValidatorParams) {
        ArrayList<Map<String, Object>> qtyToleranceParams = new ArrayList<Map<String, Object>>(16);
        HashMap<Long, BusValidatorParam> qtyEntryIdToBusParam = new HashMap<Long, BusValidatorParam>(16);
        for (BusValidatorResult busValidatorResult : results) {
            BusValidatorParam validatorParam;
            Long entryId = busValidatorResult.getEntryId();
            Long busEntryId = currentEntryIdToBusEntryIds.get(entryId);
            if (busEntryId == null || (validatorParam = busValidatorParams.get(busEntryId)) == null) continue;
            String busBillNo = validatorParam.getBillNo();
            busValidatorResult.setSrcBusNo(busBillNo);
            if (validatorParam.isBasedonAmt()) continue;
            qtyEntryIdToBusParam.put(entryId, validatorParam);
        }
        for (Map.Entry entry : qtyEntryIdToBusParam.entrySet()) {
            Map<String, Object> toleranceParam;
            BigDecimal sumQty;
            BusValidatorParam validatorParam = (BusValidatorParam)entry.getValue();
            BigDecimal busQty = validatorParam.getQuantity();
            if (busQty.compareTo(sumQty = validatorParam.getSumQty()) == 0 || (toleranceParam = this.buildToleranceParam((Long)entry.getKey(), validatorParam, sumQty, busQty)).size() == 0) continue;
            qtyToleranceParams.add(toleranceParam);
        }
        if (qtyToleranceParams.size() > 0) {
            this.compareToleranceAndWriteMessage(qtyToleranceParams, results, "quantity");
        }
    }

    protected void querySameSrcBill(Set<Long> entryIds, Set<Long> busBillIds, Set<Long> busEntryIds, Map<Long, BusValidatorParam> busValidatorParams) {
        ArrayList<Long> allTrgEntryIds = new ArrayList<Long>(16);
        HashMap<Long, List<Long>> busEntryIdTotrgEntryIds = new HashMap<Long, List<Long>>(16);
        Map<Long, Map<String, List<Long>>> allDownBillEntryIds = BOTPNewHelper.loadAllTargetRowIds(this.getSrcEntity(), "entry", busBillIds.toArray(new Long[0]), busEntryIds.toArray(new Long[0]));
        for (Map.Entry<Long, Map<String, List<Long>>> entrySet : allDownBillEntryIds.entrySet()) {
            Map<String, List<Long>> downBills = entrySet.getValue();
            List<Long> targetBillEntryIds = downBills.get(this.getTargetEntity());
            if (targetBillEntryIds == null || targetBillEntryIds.size() == 0) continue;
            allTrgEntryIds.addAll(targetBillEntryIds);
            busEntryIdTotrgEntryIds.put(entrySet.getKey(), targetBillEntryIds);
        }
        logger.info("busbill relation invoice entryIdmap" + busEntryIdTotrgEntryIds);
        logger.info("busbill all targetbill entryids" + allTrgEntryIds);
        QFilter filter = new QFilter(this.getEntryKey() + ".id", "in", allTrgEntryIds);
        if (this.getFilter() != null) {
            filter.and(this.getFilter());
        }
        HashMap<Long, Tuple> targetRows = new HashMap<Long, Tuple>(16);
        DataSet trgBills = QueryServiceHelper.queryDataSet((String)"paypecurity", (String)this.getTargetEntity(), (String)this.getSelector(), (QFilter[])new QFilter[]{filter}, null);
        for (Row row : trgBills) {
            logger.info(row.getLong("entryid") + "qty:" + row.getBigDecimal("qty") + "amount" + row.getBigDecimal("amount"));
            targetRows.put(row.getLong("entryid"), Tuple.create((Object)row.getBigDecimal("qty"), (Object)row.getBigDecimal("amount")));
        }
        for (Map.Entry<Long, BusValidatorParam> entrySet : busValidatorParams.entrySet()) {
            Long busEntryId = entrySet.getKey();
            List relationEntryIds = (List)busEntryIdTotrgEntryIds.get(busEntryId);
            if (relationEntryIds == null) continue;
            BusValidatorParam param = entrySet.getValue();
            for (Long relationEntryId : relationEntryIds) {
                Tuple tuple;
                if (entryIds.contains(relationEntryId) || (tuple = (Tuple)targetRows.get(relationEntryId)) == null) continue;
                param.setSumQty(param.getSumQty().add((BigDecimal)tuple.item1));
                param.setSumAmount(param.getSumAmount().add((BigDecimal)tuple.item2));
            }
        }
        logger.info("busparam:" + busValidatorParams.toString());
    }

    protected void queryWoffBill(Set<Long> busEntryIds, Map<Long, BusValidatorParam> busValidatorParams) {
        String busSelector = "ap_busbill".equals(this.getSrcEntity()) ? "id,entry.id entryid,entry.e_srcentryid srcentryid,entry.e_quantity qty,entry.e_pricetaxtotal taxamt,entry.e_amount amount" : "id,entry.e_quantity qty,entry.id entryid,entry.e_recamount taxamt,entry.e_srcentryid srcentryid,entry.e_amount amount";
        DataSet woffBills = QueryServiceHelper.queryDataSet((String)"paysecurity", (String)this.getSrcEntity(), (String)busSelector, (QFilter[])new QFilter[]{new QFilter("entry.e_srcentryid", "in", busEntryIds), new QFilter("isadjust", "=", (Object)Boolean.TRUE), new QFilter("isselfwoff", "=", (Object)Boolean.TRUE), new QFilter("writeoffbusiness", "=", (Object)Boolean.FALSE)}, null);
        for (Row row : woffBills) {
            Long srcEntryId = row.getLong("srcentryid");
            BusValidatorParam param = busValidatorParams.get(srcEntryId);
            if (param == null) continue;
            param.setSumAmount(param.getSumAmount().subtract(row.getBigDecimal("amount")));
            param.setSumQty(param.getSumQty().subtract(row.getBigDecimal("qty")));
        }
    }

    protected Map<String, Object> buildToleranceParam(Long entryId, BusValidatorParam param, BigDecimal controlvalue, BigDecimal contrastvalue) {
        HashMap<String, Object> toleranceParam = new HashMap<String, Object>(16);
        if (controlvalue.compareTo(contrastvalue) != 0) {
            toleranceParam.put("pk", entryId.toString());
            toleranceParam.put("controlvalue", controlvalue);
            toleranceParam.put("contrastvalue", contrastvalue);
            toleranceParam.put("precision", param.getPricePrecision());
            if ("bd_supplier".equals(param.getAsstactType())) {
                toleranceParam.put("bd_supplier", param.getAsstactId());
                toleranceParam.put("bd_customer", null);
            } else if ("bd_customer".equals(param.getAsstactType())) {
                toleranceParam.put("bd_customer", param.getAsstactId());
                toleranceParam.put("bd_supplier", null);
            } else {
                toleranceParam.put("bd_customer", null);
                toleranceParam.put("bd_supplier", null);
            }
            toleranceParam.put("bos_org", param.getOrgId());
            toleranceParam.put("bd_currency", param.getCurrencyId());
            toleranceParam.put("bd_material", param.getMaterialId());
            toleranceParam.put("bd_materialgroup", param.getMaterialGroupIds());
        }
        return toleranceParam;
    }

    protected void compareToleranceAndWriteMessage(List<Map<String, Object>> toleranceParams, List<BusValidatorResult> results, String validateType) {
        Object entryId;
        Map<String, Object> toleranceResult = this.getToleranceResult(toleranceParams, validateType);
        logger.info("\u5bb9\u5dee\u8fd4\u56de\u7ed3\u679c" + toleranceResult);
        HashMap<Long, String> failedResults = new HashMap<Long, String>(16);
        HashMap<Long, Map<String, Object>> compareInfos = new HashMap<Long, Map<String, Object>>(16);
        for (Map<String, Object> map : toleranceParams) {
            entryId = (String)map.get("pk");
            compareInfos.put(Long.valueOf((String)entryId), map);
        }
        for (Map.Entry entry : toleranceResult.entrySet()) {
            String failReason = (String)entry.getKey();
            List failPkStr = (List)entry.getValue();
            for (String pk : failPkStr) {
                failedResults.put(Long.valueOf(pk), failReason);
            }
        }
        for (BusValidatorResult busValidatorResult : results) {
            entryId = busValidatorResult.getEntryId();
            String failedResult = (String)failedResults.get(entryId);
            if (failedResult == null) continue;
            if ("failtomatch".equals(failedResult)) {
                Map info = (Map)compareInfos.get(entryId);
                if (info == null) continue;
                BigDecimal contrastvalue = (BigDecimal)info.get("contrastvalue");
                BigDecimal controlvalue = (BigDecimal)info.get("controlvalue");
                if (controlvalue.abs().compareTo(contrastvalue.abs()) <= 0) continue;
                String message = this.getMessage(busValidatorResult, validateType);
                if (busValidatorResult.getMessage() == null) {
                    busValidatorResult.setMessage(message);
                    continue;
                }
                busValidatorResult.setMessage(busValidatorResult.getMessage() + '\n' + message);
                continue;
            }
            String message = this.getMessage(busValidatorResult, validateType);
            if (busValidatorResult.getMessage() == null) {
                busValidatorResult.setMessage(message);
                continue;
            }
            busValidatorResult.setMessage(busValidatorResult.getMessage() + '\n' + message);
        }
    }

    protected abstract String getMessage(BusValidatorResult var1, String var2);

    protected abstract Map<String, Object> getToleranceResult(List<Map<String, Object>> var1, String var2);

    protected Map<Long, BusValidatorParam> getSourceBusBillMap(Set<Long> srcBusBillIds, Set<Long> srcBusEntryIds, DataSet currentBills, Map<Long, Long> currentEntryIdToBusEntryIds, String operateKey) {
        Map<Long, Long> trgToBusEntryIds;
        String srcEntity = this.getSrcEntity();
        String targetEntity = this.getTargetEntity();
        HashSet<Long> otherSrcBillIds = new HashSet<Long>(16);
        HashSet<Long> otherSrcBillEntryIds = new HashSet<Long>(16);
        HashMap<Long, Tuple<BigDecimal, BigDecimal>> currentBillQtyAndAmt = new HashMap<Long, Tuple<BigDecimal, BigDecimal>>(16);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Object row : currentBills) {
            orgIds.add(row.getLong("org"));
            String string = row.getString("sourcebilltype");
            currentBillQtyAndAmt.put(row.getLong("entryid"), Tuple.create((Object)row.getBigDecimal("qty"), (Object)row.getBigDecimal("amount")));
            if (srcEntity.equals(string)) {
                srcBusBillIds.add(Long.valueOf(row.getString("srcbillid")));
                srcBusEntryIds.add(Long.valueOf(row.getString("srcentryid")));
                currentEntryIdToBusEntryIds.put(row.getLong("entryid"), Long.valueOf(row.getString("srcentryid")));
                continue;
            }
            otherSrcBillIds.add(row.getLong("id"));
            otherSrcBillEntryIds.add(row.getLong("entryid"));
        }
        if (otherSrcBillEntryIds.size() > 0 && (trgToBusEntryIds = BOTPNewHelper.loadNearSourceRowIds(targetEntity, this.getEntryKey(), otherSrcBillIds.toArray(new Long[0]), otherSrcBillEntryIds.toArray(new Long[0]), srcEntity)).size() > 0) {
            for (Map.Entry entry : trgToBusEntryIds.entrySet()) {
                srcBusEntryIds.add((Long)entry.getValue());
                currentEntryIdToBusEntryIds.put((Long)entry.getKey(), (Long)entry.getValue());
            }
        }
        logger.info("currentEntryIdToBusEntryIds:" + currentEntryIdToBusEntryIds);
        if (srcBusEntryIds.size() == 0) {
            return new HashMap<Long, BusValidatorParam>(2);
        }
        DataSet srcBills = QueryServiceHelper.queryDataSet((String)"paysecurity", (String)this.getSrcEntity(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBusEntryIds), new QFilter("org", "in", orgIds)}, null);
        for (Row row : srcBills) {
            srcBusBillIds.add(row.getLong("id"));
        }
        HashMap<Long, Set<Long>> busToCurrentEntryIds = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Long, Long> entrySet : currentEntryIdToBusEntryIds.entrySet()) {
            Long entryId = entrySet.getKey();
            Long busEntryId = entrySet.getValue();
            HashSet<Long> curEntryIds = (HashSet<Long>)busToCurrentEntryIds.get(busEntryId);
            if (curEntryIds == null) {
                curEntryIds = new HashSet<Long>(16);
                curEntryIds.add(entryId);
                busToCurrentEntryIds.put(busEntryId, curEntryIds);
                continue;
            }
            curEntryIds.add(entryId);
        }
        return this.buildBusValidatorParam(srcEntity, srcBusBillIds, srcBusEntryIds, busToCurrentEntryIds, currentBillQtyAndAmt);
    }

    protected Map<Long, BusValidatorParam> buildBusValidatorParam(String srcEntity, Set<Long> srcBusBillIds, Set<Long> srcBusEntryIds, Map<Long, Set<Long>> busToCurrentEntryIds, Map<Long, Tuple<BigDecimal, BigDecimal>> currentBillQtyAndAmt) {
        HashMap<Long, BusValidatorParam> params = new HashMap<Long, BusValidatorParam>(16);
        String busSelector = "id,org,asstacttype,currency,currency.priceprecision priceprecision,currency.amtprecision amtprecision,asstact,billno,payproperty.isbasedonamt isbasedonamt,entry.id entryid,entry.e_material material,entry.e_measureunit.precision unitprecision,entry.e_quantity qty,entry.e_unitprice price,entry.e_amount amount";
        DataSet busBills = QueryServiceHelper.queryDataSet((String)"paypecurity", (String)srcEntity, (String)busSelector, (QFilter[])new QFilter[]{new QFilter("entry.id", "in", srcBusEntryIds)}, null);
        ArrayList<Long> supplierIds = new ArrayList<Long>(16);
        ArrayList<Long> customerIds = new ArrayList<Long>(16);
        ArrayList<Long> materialIds = new ArrayList<Long>(16);
        for (Row row : busBills) {
            srcBusBillIds.add(row.getLong("id"));
            BusValidatorParam param = new BusValidatorParam();
            param.setBillId(row.getLong("id"));
            param.setEntryId(row.getLong("entryid"));
            param.setBasedonAmt(row.getBoolean("isbasedonamt"));
            param.setBillNo(row.getString("billno"));
            param.setAmount(row.getBigDecimal("amount"));
            param.setQuantity(row.getBigDecimal("qty"));
            param.setPrice(row.getBigDecimal("price"));
            param.setOrgId(row.getLong("org"));
            String asstactType = row.getString("asstacttype");
            Long asstactId = row.getLong("asstact");
            if ("bd_supplier".equals(asstactType)) {
                supplierIds.add(asstactId);
            }
            if ("bd_customer".equals(asstactType)) {
                customerIds.add(asstactId);
            }
            Long materialId = row.getLong("material");
            materialIds.add(materialId);
            param.setAsstactType(asstactType);
            param.setAsstactId(asstactId);
            param.setCurrencyId(row.getLong("currency"));
            param.setMaterialId(materialId);
            param.setPricePrecision(row.getInteger("priceprecision"));
            param.setAmtPrecision(row.getInteger("amtprecision"));
            Integer unitPrecision = row.getInteger("unitprecision");
            if (unitPrecision == null) {
                unitPrecision = 10;
            }
            param.setUnitPrecision(unitPrecision);
            Set<Long> curEntryIds = busToCurrentEntryIds.get(row.getLong("entryid"));
            if (curEntryIds != null) {
                for (Long entryId : curEntryIds) {
                    Tuple<BigDecimal, BigDecimal> tuple = currentBillQtyAndAmt.get(entryId);
                    if (tuple == null) continue;
                    param.setSumQty(param.getSumQty().add((BigDecimal)tuple.item1));
                    param.setSumAmount(param.getSumAmount().add((BigDecimal)tuple.item2));
                }
            }
            params.put(row.getLong("entryid"), param);
        }
        HashMap<Long, Long> supplierMasterIds = new HashMap<Long, Long>(16);
        HashMap<Long, Long> customerMasterIds = new HashMap<Long, Long>(16);
        if (supplierIds.size() > 0) {
            DataSet suppliers = QueryServiceHelper.queryDataSet((String)"paysecurity", (String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)}, null);
            for (Row row : suppliers) {
                supplierMasterIds.put(row.getLong("id"), row.getLong("masterid"));
            }
        }
        if (customerIds.size() > 0) {
            DataSet customers = QueryServiceHelper.queryDataSet((String)"paysecurety", (String)"bd_customer", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", customerIds)}, null);
            for (Row row : customers) {
                customerMasterIds.put(row.getLong("id"), row.getLong("masterid"));
            }
        }
        HashMap<Long, ArrayList<Long>> materialIdToMaterialgroup = new HashMap<Long, ArrayList<Long>>(16);
        DynamicObjectCollection materialGroups = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])new QFilter[]{new QFilter("material", "in", materialIds)});
        for (DynamicObject group : materialGroups) {
            Long materialId = group.getLong("material");
            ArrayList<Long> materialGroupIds = (ArrayList<Long>)materialIdToMaterialgroup.get(materialId);
            if (materialGroupIds == null) {
                materialGroupIds = new ArrayList<Long>(16);
                materialGroupIds.add(group.getLong("group"));
                materialIdToMaterialgroup.put(materialId, materialGroupIds);
                continue;
            }
            materialGroupIds.add(group.getLong("group"));
        }
        for (Map.Entry entrySet : params.entrySet()) {
            BusValidatorParam param = (BusValidatorParam)entrySet.getValue();
            String asstactType = param.getAsstactType();
            if ("bd_supplier".equals(asstactType)) {
                param.setAsstactId(supplierMasterIds.getOrDefault(param.getAsstactId(), param.getAsstactId()));
            } else {
                param.setAsstactId(customerMasterIds.getOrDefault(param.getAsstactId(), param.getAsstactId()));
            }
            param.setMaterialGroupIds((List)materialIdToMaterialgroup.get(param.getMaterialId()));
        }
        return params;
    }

    protected abstract void initValidataLevel();

    protected abstract String getTargetEntity();

    protected abstract String getSrcEntity();

    protected abstract QFilter getFilter();

    protected abstract String getSelector();

    protected String getEntryKey() {
        return "entry";
    }

    static class BusValidatorParam {
        private Long billId;
        private Long entryId;
        private String billNo;
        private boolean isBasedonAmt;
        private BigDecimal quantity;
        private BigDecimal amount;
        private BigDecimal price;
        private BigDecimal sumQty = BigDecimal.ZERO;
        private BigDecimal sumAmount = BigDecimal.ZERO;
        private BigDecimal taxUnitPrice;
        private boolean qtyOrAmtExcess;
        private boolean priceExcess;
        private String asstactType;
        private Long asstactId;
        private Long orgId;
        private Long materialId;
        private Long currencyId;
        private int pricePrecision;
        private int amtPrecision;
        private int unitPrecision;
        private List<Long> materialGroupIds = new ArrayList<Long>(2);

        BusValidatorParam() {
        }

        public Long getBillId() {
            return this.billId;
        }

        public void setBillId(Long billId) {
            this.billId = billId;
        }

        public Long getEntryId() {
            return this.entryId;
        }

        public void setEntryId(Long entryId) {
            this.entryId = entryId;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public boolean isBasedonAmt() {
            return this.isBasedonAmt;
        }

        public void setBasedonAmt(boolean basedonAmt) {
            this.isBasedonAmt = basedonAmt;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        public void setQuantity(BigDecimal quantity) {
            this.quantity = quantity;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public BigDecimal getTaxUnitPrice() {
            return this.taxUnitPrice;
        }

        public void setTaxUnitPrice(BigDecimal taxUnitPrice) {
            this.taxUnitPrice = taxUnitPrice;
        }

        public boolean isQtyOrAmtExcess() {
            return this.qtyOrAmtExcess;
        }

        public void setQtyOrAmtExcess(boolean qtyOrAmtExcess) {
            this.qtyOrAmtExcess = qtyOrAmtExcess;
        }

        public boolean isPriceExcess() {
            return this.priceExcess;
        }

        public void setPriceExcess(boolean priceExcess) {
            this.priceExcess = priceExcess;
        }

        public BigDecimal getSumQty() {
            return this.sumQty;
        }

        public void setSumQty(BigDecimal sumQty) {
            this.sumQty = sumQty;
        }

        public BigDecimal getSumAmount() {
            return this.sumAmount;
        }

        public void setSumAmount(BigDecimal sumAmount) {
            this.sumAmount = sumAmount;
        }

        public String getAsstactType() {
            return this.asstactType;
        }

        public void setAsstactType(String asstactType) {
            this.asstactType = asstactType;
        }

        public Long getAsstactId() {
            return this.asstactId;
        }

        public void setAsstactId(Long asstactId) {
            this.asstactId = asstactId;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public Long getMaterialId() {
            return this.materialId;
        }

        public void setMaterialId(Long materialId) {
            this.materialId = materialId;
        }

        public Long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(Long currencyId) {
            this.currencyId = currencyId;
        }

        public List<Long> getMaterialGroupIds() {
            return this.materialGroupIds;
        }

        public void setMaterialGroupIds(List<Long> materialGroupIds) {
            this.materialGroupIds = materialGroupIds;
        }

        public int getPricePrecision() {
            return this.pricePrecision;
        }

        public void setPricePrecision(int pricePrecision) {
            this.pricePrecision = pricePrecision;
        }

        public int getAmtPrecision() {
            return this.amtPrecision;
        }

        public void setAmtPrecision(int amtPrecision) {
            this.amtPrecision = amtPrecision;
        }

        public int getUnitPrecision() {
            return this.unitPrecision;
        }

        public void setUnitPrecision(int unitPrecision) {
            this.unitPrecision = unitPrecision;
        }

        public String toString() {
            return "BusValidatorParam{billId=" + this.billId + ", entryId=" + this.entryId + ", billNo='" + this.billNo + '\'' + ", isBasedonAmt=" + this.isBasedonAmt + ", quantity=" + this.quantity + ", amount=" + this.amount + ", price=" + this.price + ", sumQty=" + this.sumQty + ", sumAmount=" + this.sumAmount + ", taxUnitPrice=" + this.taxUnitPrice + ", qtyOrAmtExcess=" + this.qtyOrAmtExcess + ", priceExcess=" + this.priceExcess + ", asstactType='" + this.asstactType + '\'' + ", asstactId=" + this.asstactId + ", orgId=" + this.orgId + ", materialId=" + this.materialId + ", currencyId=" + this.currencyId + ", pricePrecision=" + this.pricePrecision + ", amtPrecision=" + this.amtPrecision + ", unitPrecision=" + this.unitPrecision + ", materialGroupIds=" + this.materialGroupIds + '}';
        }
    }
}

