/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator.paysecurity;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.service.ToleranceMatchService;
import kd.fi.arapcommon.validator.paysecurity.AbstractBusBillPaySecurityValidator;
import kd.fi.arapcommon.validator.paysecurity.BusValidatorResult;
import kd.fi.arapcommon.validator.paysecurity.FinArExcessBusValidator;

public class ArSimExcessBusValidator
extends FinArExcessBusValidator {
    @Override
    protected String getMessage(BusValidatorResult result, String validateType) {
        if ("price".equals(validateType)) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u76d1\u6d4b\u5230\u8d85\u989d\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u3002\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u6536\u5355%3$s\u67e5\u8be2\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5355\u4ef7\u4e0e\u6682\u4f30\u5e94\u6536\u5355\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"ArSimExcessBusValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
        }
        if ("amount".equals(validateType)) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u76d1\u6d4b\u5230\u8d85\u989d\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u3002\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u6536\u5355%3$s\u67e5\u8be2\u7684\u5f00\u7968\u7533\u8bf7\u5355\u3001\u624b\u5de5\u51b2\u56de\u7684\u6682\u4f30\u5e94\u6536\u51b2\u56de\u5355\u91d1\u989d\u7d2f\u8ba1\u503c\u4e0e\u6682\u4f30\u5e94\u6536\u5355\u91d1\u989d\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"ArSimExcessBusValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
        }
        return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u76d1\u6d4b\u5230\u8d85\u989d\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u3002\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u6536\u5355%3$s\u67e5\u8be2\u7684\u5f00\u7968\u7533\u8bf7\u5355\u3001\u624b\u5de5\u51b2\u56de\u7684\u6682\u4f30\u5e94\u6536\u51b2\u56de\u5355\u6570\u91cf\u7d2f\u8ba1\u503c\u4e0e\u6682\u4f30\u5e94\u6536\u5355\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"ArSimExcessBusValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
    }

    @Override
    protected Map<String, Object> getToleranceResult(List<Map<String, Object>> toleranceParams, String validateType) {
        ToleranceMatchService service = new ToleranceMatchService();
        if ("price".equals(validateType)) {
            return service.getAllResult("sim_original_bill", "ar_busbill", "unitprice", "e_unitprice", toleranceParams);
        }
        if ("amount".equals(validateType)) {
            return service.getAllResult("sim_original_bill", "ar_busbill", "amount", "e_amount", toleranceParams);
        }
        return service.getAllResult("sim_original_bill", "ar_busbill", "num", "e_quantity", toleranceParams);
    }

    @Override
    protected void initValidataLevel() {
        DynamicObjectCollection execcontrols = QueryServiceHelper.query((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"SZJK-PRE-0115", "SZJK-PRE-0116", "SZJK-PRE-0117"})});
        for (DynamicObject ctrl : execcontrols) {
            String number = ctrl.getString("number");
            if ("SZJK-PRE-0115".equals(number)) {
                if (!ctrl.getBoolean("enable")) continue;
                this.isValidataQty = true;
                continue;
            }
            if ("SZJK-PRE-0117".equals(number)) {
                if (!ctrl.getBoolean("enable")) continue;
                this.isValidataPrice = true;
                continue;
            }
            if (!"SZJK-PRE-0116".equals(number) || !ctrl.getBoolean("enable")) continue;
            this.isValidataAmt = true;
        }
    }

    @Override
    protected Map<Long, AbstractBusBillPaySecurityValidator.BusValidatorParam> getSourceBusBillMap(Set<Long> srcBusBillIds, Set<Long> srcBusEntryIds, DataSet currentBills, Map<Long, Long> currentEntryIdToBusEntryIds, String operateKey) {
        Map<Long, Long> trgToBusEntryIds;
        HashSet<Long> simBillIds = new HashSet<Long>(16);
        HashSet<Long> simEntryIds = new HashSet<Long>(16);
        HashMap<Long, Tuple<BigDecimal, BigDecimal>> currentBillQtyAndAmt = new HashMap<Long, Tuple<BigDecimal, BigDecimal>>(16);
        for (Object row : currentBills) {
            currentBillQtyAndAmt.put(row.getLong("entryid"), Tuple.create((Object)row.getBigDecimal("qty"), (Object)row.getBigDecimal("amount")));
            simBillIds.add(row.getLong("id"));
            simEntryIds.add(row.getLong("entryid"));
        }
        if (simEntryIds.size() > 0 && (trgToBusEntryIds = BOTPNewHelper.loadNearSourceRowIds("sim_original_bill", this.getEntryKey(), simBillIds.toArray(new Long[0]), simEntryIds.toArray(new Long[0]), "ar_busbill")).size() > 0) {
            for (Map.Entry entry : trgToBusEntryIds.entrySet()) {
                srcBusEntryIds.add((Long)entry.getValue());
                currentEntryIdToBusEntryIds.put((Long)entry.getKey(), (Long)entry.getValue());
            }
        }
        if (srcBusEntryIds.size() == 0) {
            return new HashMap<Long, AbstractBusBillPaySecurityValidator.BusValidatorParam>(2);
        }
        DataSet srcBills = QueryServiceHelper.queryDataSet((String)"paysecurity", (String)this.getSrcEntity(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBusEntryIds)}, null);
        for (Row row : srcBills) {
            srcBusBillIds.add(row.getLong("id"));
        }
        HashMap<Long, Set<Long>> busToCurrentEntryIds = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Long, Long> entrySet : currentEntryIdToBusEntryIds.entrySet()) {
            Long entryId = entrySet.getKey();
            Long busEntryId = entrySet.getValue();
            HashSet<Long> curEntryIds = (HashSet<Long>)busToCurrentEntryIds.get(busEntryId);
            if (curEntryIds == null) {
                curEntryIds = new HashSet<Long>(16);
                curEntryIds.add(entryId);
                busToCurrentEntryIds.put(busEntryId, curEntryIds);
                continue;
            }
            curEntryIds.add(entryId);
        }
        return this.buildBusValidatorParam("ar_busbill", srcBusBillIds, srcBusEntryIds, busToCurrentEntryIds, currentBillQtyAndAmt);
    }

    @Override
    protected void writeAmtMessage(BusValidatorResult result) {
        String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u6536\u5355%3$s\u67e5\u8be2\u7684\u5f00\u7968\u7533\u8bf7\u5355\u3001\u624b\u5de5\u51b2\u56de\u7684\u6682\u4f30\u5e94\u6536\u51b2\u56de\u5355\u91d1\u989d\u7d2f\u8ba1\u503c\u4e0e\u6682\u4f30\u5e94\u6536\u5355\u91d1\u989d\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u516c\u5171\u8bbe\u7f6e>\u53c2\u6570\u914d\u7f6e>\u7cfb\u7edf\u53c2\u6570>\u5e94\u6536-\u542f\u7528\u6682\u4f30\u5f00\u7968\u8d85\u989d\u63a7\u5236\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"ArSimExcessBusValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
        if (result.getMessage() == null) {
            result.setMessage(message);
        } else {
            result.setMessage(result.getMessage() + '\n' + message);
        }
    }

    @Override
    protected String getTargetEntity() {
        return "sim_original_bill";
    }

    @Override
    protected QFilter getFilter() {
        return new QFilter("billsourcetype", "=", (Object)"A");
    }

    @Override
    protected String getSelector() {
        return "id,billno,orgid org,sim_original_bill_item.num qty,sim_original_bill_item.unitprice price,sim_original_bill_item.id entryid,sim_original_bill_item.seq seq,sim_original_bill_item.taxamount taxamt,sim_original_bill_item.amount amount";
    }

    @Override
    protected String getEntryKey() {
        return "sim_original_bill_item";
    }

    @Override
    protected boolean needSetPayproperty() {
        return false;
    }

    @Override
    protected void validataPayproperty(List<BusValidatorResult> results, Map<Long, Long> currentEntryIdToBusEntryIds, Map<Long, AbstractBusBillPaySecurityValidator.BusValidatorParam> busValidatorParams) {
    }
}

