/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator.paysecurity;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.ToleranceMatchService;
import kd.fi.arapcommon.validator.paysecurity.AbstractBusBillPaySecurityValidator;
import kd.fi.arapcommon.validator.paysecurity.BusValidatorResult;
import org.apache.commons.lang.StringUtils;

public class FinApExcessBusValidator
extends AbstractBusBillPaySecurityValidator {
    @Override
    protected boolean needSetPayproperty() {
        return true;
    }

    @Override
    protected void validataPayproperty(List<BusValidatorResult> results, Map<Long, Long> currentEntryIdToBusEntryIds, Map<Long, AbstractBusBillPaySecurityValidator.BusValidatorParam> busValidatorParams) {
        DynamicObject execcontrol = QueryServiceHelper.queryOne((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"SZJK-PRE-0132"}), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (execcontrol != null) {
            super.validataPayproperty(results, currentEntryIdToBusEntryIds, busValidatorParams);
        }
    }

    @Override
    protected String getMessage(BusValidatorResult result, String validateType) {
        if ("price".equals(validateType)) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u76d1\u6d4b\u5230\u8d85\u989d\u786e\u8ba4\u8d22\u52a1\u5e94\u4ed8\u5355\u3002\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u4ed8\u5355%3$s\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u5355\u4ef7\u4e0e\u6682\u4f30\u5e94\u4ed8\u5355\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"FinApExcessBusValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
        }
        if ("amount".equals(validateType)) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u76d1\u6d4b\u5230\u8d85\u989d\u786e\u8ba4\u8d22\u52a1\u5e94\u4ed8\u5355\u3002\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u4ed8\u5355%3$s\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u3001\u624b\u5de5\u51b2\u56de\u7684\u6682\u4f30\u5e94\u4ed8\u51b2\u56de\u5355\u7684\u91d1\u989d\u7d2f\u8ba1\u503c\u4e0e\u6682\u4f30\u5e94\u4ed8\u5355\u91d1\u989d\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"FinApExcessBusValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
        }
        return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u76d1\u6d4b\u5230\u8d85\u989d\u786e\u8ba4\u8d22\u52a1\u5e94\u4ed8\u5355\u3002\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u4ed8\u5355%3$s\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u3001\u624b\u5de5\u51b2\u56de\u7684\u6682\u4f30\u5e94\u4ed8\u51b2\u56de\u5355\u6570\u91cf\u7d2f\u8ba1\u503c\u4e0e\u6682\u4f30\u5e94\u4ed8\u5355\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"FinApExcessBusValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
    }

    @Override
    protected void setPayPropertyMessage(BusValidatorResult result) {
        result.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s:\u6b3e\u9879\u6027\u8d28\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u9700\u4e0e\u4e0a\u6e38\u6682\u4f30\u5e94\u4ed8\u5355\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApExcessBusValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo()));
    }

    @Override
    protected void setDirectionMessage(BusValidatorResult result, List<Integer> seqs) {
        if (result.isBasedonAmt()) {
            result.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s:\u5b58\u5728\u4e0e\u4e0a\u6e38\u6682\u4f30\u5e94\u4ed8\u5355\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\u7684\u660e\u7ec6\u884c\uff08\u7b2c%2$s\u884c\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApExcessBusValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), StringUtils.join(seqs, (String)"\u3001")));
        } else {
            result.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s:\u5b58\u5728\u4e0e\u4e0a\u6e38\u6682\u4f30\u5e94\u4ed8\u5355\u6570\u91cf\u65b9\u5411\u4e0d\u4e00\u81f4\u7684\u660e\u7ec6\u884c\uff08\u7b2c%2$s\u884c\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApExcessBusValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), StringUtils.join(seqs, (String)"\u3001")));
        }
    }

    @Override
    protected Map<String, Object> getToleranceResult(List<Map<String, Object>> toleranceParams, String validateType) {
        ToleranceMatchService service = new ToleranceMatchService();
        if ("price".equals(validateType)) {
            return service.getAllResult("ap_finapbill", "ap_busbill", "price", "e_unitprice", toleranceParams);
        }
        if ("amount".equals(validateType)) {
            return service.getAllResult("ap_finapbill", "ap_busbill", "e_amount", "e_amount", toleranceParams);
        }
        return service.getAllResult("ap_finapbill", "ap_busbill", "quantity", "e_quantity", toleranceParams);
    }

    @Override
    protected void initValidataLevel() {
        DynamicObjectCollection execcontrols = QueryServiceHelper.query((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"SZJK-PRE-0091", "SZJK-PRE-0106", "SZJK-PRE-0107"})});
        for (DynamicObject ctrl : execcontrols) {
            String number = ctrl.getString("number");
            if ("SZJK-PRE-0091".equals(number)) {
                if (!ctrl.getBoolean("enable")) continue;
                this.isValidataQty = true;
                continue;
            }
            if ("SZJK-PRE-0106".equals(number)) {
                if (!ctrl.getBoolean("enable")) continue;
                this.isValidataPrice = true;
                continue;
            }
            if (!"SZJK-PRE-0107".equals(number) || !ctrl.getBoolean("enable")) continue;
            this.isValidataAmt = true;
        }
    }

    @Override
    protected String getTargetEntity() {
        return "ap_finapbill";
    }

    @Override
    protected String getSrcEntity() {
        return "ap_busbill";
    }

    @Override
    protected QFilter getFilter() {
        return new QFilter("istanspay", "=", (Object)Boolean.FALSE).and(new QFilter("ispremium", "=", (Object)Boolean.FALSE)).and("billtypeid.number", "!=", (Object)"ApFin_borr_BT_S");
    }

    @Override
    protected String getSelector() {
        return "id,billno,org,sourcebilltype,payproperty.isbasedonamt isbasedonamt,detailentry.quantity qty,detailentry.price price,detailentry.id entryid,detailentry.seq seq,detailentry.e_pricetaxtotal taxamt,detailentry.e_amount amount,detailentry.e_sourcebillid srcbillid,detailentry.e_sourcebillentryid srcentryid";
    }

    @Override
    protected String getEntryKey() {
        return "detailentry";
    }
}

