/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.vo;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;

public class ArApStandardOperateParam {
    private String opType;
    private String entityNumber;
    private String standardOpNumber;
    private String standardOpName;

    public ArApStandardOperateParam(String entityNumber, String opType) {
        this.entityNumber = entityNumber;
        this.opType = opType;
        this.initOperate();
    }

    private void initOperate() {
        List<String> billTypeList = Arrays.asList("ap_finapbill", "ap_busbill", "ap_invoice", "ap_paidbill", "ap_payapply", "ar_finarbill", "ar_busbill", "ar_revcfmbill", "ar_invoice", "ar_receivedbill", "ap_liquidation", "ar_liquidation", "ap_settlerecord", "ar_settlerecord", "ap_verifyrecord", "ar_verifyrecord");
        if (billTypeList.contains(this.entityNumber)) {
            switch (this.opType) {
                case "save": {
                    this.standardOpNumber = "save";
                    this.standardOpName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ArApStandardOperateParam_4", (String)"fi-arapcommon", (Object[])new Object[0]);
                    break;
                }
                case "submit": {
                    this.standardOpNumber = "submit";
                    this.standardOpName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ArApStandardOperateParam_5", (String)"fi-arapcommon", (Object[])new Object[0]);
                    break;
                }
                case "audit": {
                    this.standardOpNumber = "audit";
                    this.standardOpName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ArApStandardOperateParam_0", (String)"fi-arapcommon", (Object[])new Object[0]);
                    break;
                }
                case "unaudit": {
                    this.standardOpNumber = "unaudit";
                    this.standardOpName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"ArApStandardOperateParam_1", (String)"fi-arapcommon", (Object[])new Object[0]);
                    break;
                }
                case "delete": {
                    if (!this.entityNumber.equals("ap_liquidation") && !this.entityNumber.equals("ar_liquidation")) {
                        this.standardOpNumber = "delete";
                        this.standardOpName = ResManager.loadKDString((String)"\u5220\u9664", (String)"ArApStandardOperateParam_2", (String)"fi-arapcommon", (Object[])new Object[0]);
                        break;
                    }
                    this.standardOpNumber = "unkonw";
                    break;
                }
                case "invalid": {
                    if (this.entityNumber.equals("ap_liquidation") || this.entityNumber.equals("ar_liquidation")) {
                        this.standardOpNumber = "invalid";
                        this.standardOpName = ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"ArApStandardOperateParam_3", (String)"fi-arapcommon", (Object[])new Object[0]);
                        break;
                    }
                    this.standardOpNumber = "unkonw";
                    break;
                }
                default: {
                    this.standardOpNumber = "unkonw";
                    break;
                }
            }
        } else {
            this.standardOpNumber = "unkonw";
        }
    }

    public String getStandardOpNumber() {
        return this.standardOpNumber;
    }

    public String getStandardOpName() {
        return this.standardOpName;
    }
}

