/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.vo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.fi.arapcommon.eas.settle.EasSettleAnalysisFactory;
import kd.fi.arapcommon.eas.settle.IEasSettleRecordAnalysis;

public class EasSettleRecordContext {
    private PrimitiveIterator.OfLong uniqueKeyIterator = Arrays.stream(DB.genGlobalLongIds((int)100)).iterator();
    private Map<String, List<DynamicObject>> needSaveOtherBillsMap = new HashMap<String, List<DynamicObject>>(8);
    private final Map<String, IEasSettleRecordAnalysis> easSettleRecordAnalysisMap = new HashMap<String, IEasSettleRecordAnalysis>(16);
    private Map<String, Map<Long, DynamicObject>> billEntity4BillMap = new HashMap<String, Map<Long, DynamicObject>>(64);
    private Map<String, Map<Long, DynamicObject>> billEntity4EntryMap = new HashMap<String, Map<Long, DynamicObject>>(64);

    public long getUniqueKey() {
        if (this.uniqueKeyIterator == null || !this.uniqueKeyIterator.hasNext()) {
            this.uniqueKeyIterator = Arrays.stream(DB.genGlobalLongIds((int)100)).iterator();
        }
        return this.uniqueKeyIterator.next();
    }

    public Map<String, List<DynamicObject>> getNeedSaveOtherBillsMap() {
        return this.needSaveOtherBillsMap;
    }

    public void setNeedSaveOtherBillsMap(Map<String, List<DynamicObject>> needSaveOtherBillsMap) {
        this.needSaveOtherBillsMap = needSaveOtherBillsMap;
    }

    public Map<String, Map<Long, DynamicObject>> getBillEntity4BillMap() {
        return this.billEntity4BillMap;
    }

    public void setBillEntity4BillMap(Map<String, Map<Long, DynamicObject>> billEntity4BillMap) {
        this.billEntity4BillMap = billEntity4BillMap;
    }

    public Map<String, Map<Long, DynamicObject>> getBillEntity4EntryMap() {
        return this.billEntity4EntryMap;
    }

    public void setBillEntity4EntryMap(Map<String, Map<Long, DynamicObject>> billEntity4EntryMap) {
        this.billEntity4EntryMap = billEntity4EntryMap;
    }

    public IEasSettleRecordAnalysis getEasSettleRecordAnalysisMap(String key) {
        IEasSettleRecordAnalysis easSettleAnalysisImpl = this.easSettleRecordAnalysisMap.get(key);
        if (easSettleAnalysisImpl == null) {
            if ("easFinSelfSettle".equals(key)) {
                easSettleAnalysisImpl = EasSettleAnalysisFactory.getIEasSettleAnalysisImplByFinSelf();
            } else if (key.contains("easliquidate")) {
                String[] split = key.split("-");
                easSettleAnalysisImpl = EasSettleAnalysisFactory.getIEasSettleAnalysisImplByLiquidate(split[1]);
            } else {
                easSettleAnalysisImpl = EasSettleAnalysisFactory.getIEasSettleAnalysisImpl(key);
            }
            this.easSettleRecordAnalysisMap.put(key, easSettleAnalysisImpl);
        }
        return easSettleAnalysisImpl;
    }

    public String toString() {
        return "EasSettleRecordContext{needSaveOtherBills=" + this.needSaveOtherBillsMap.keySet() + ", easSettleRecordAnalysisMap=" + this.easSettleRecordAnalysisMap.keySet() + ", billEntity4BillMap=" + this.billEntity4BillMap.keySet() + ", billEntity4EntryMap=" + this.billEntity4EntryMap.keySet() + '}';
    }
}

