/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.vo.adjexch;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.helper.SettingMapperHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class AdjustExchangeContext {
    private Long orgId;
    private Long periodId;
    private Date startDate;
    private Date endDate;
    private Long lastPeriodId;
    private Long standardCurrencyId;
    private int precision;
    private boolean isPeriod = false;
    private String bizSystem;
    private boolean isMaterialSettle;
    private int billCount = 1000;
    private boolean includeCas = true;
    private Map<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>(16);
    private Map<String, String> quotationMap = new HashMap<String, String>(16);
    protected static final Log logger = LogFactory.getLog(AdjustExchangeContext.class);

    public AdjustExchangeContext(String bizSystem, long orgId, boolean isPeriod, Long adjExchPeriodId, Map<String, BigDecimal> rateMap, Map<String, String> quottationMap) {
        String batchCount;
        DynamicObject init = BusinessDataServiceHelper.loadSingle((String)("AR".equals(bizSystem) ? "ar_init" : "ap_init"), (String)"startperiod,standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        logger.info("AdjustExchangeContext:init:%s", EmptyUtils.isNotEmpty(init) ? init.get("id") : "0");
        this.bizSystem = bizSystem;
        this.orgId = orgId;
        this.exchangeRateMap = rateMap;
        this.quotationMap = quottationMap;
        DynamicObject startPeriod = init.getDynamicObject("startperiod");
        logger.info("AdjustExchangeContext:startPeriod:%s", EmptyUtils.isNotEmpty(startPeriod) ? startPeriod.get("name") : "0");
        if (isPeriod) {
            this.periodId = 0L;
            this.isPeriod = isPeriod;
            Date startPeriodFirstDate = startPeriod.getDate("begindate");
            this.startDate = DateUtils.getLastMonthDate(startPeriodFirstDate);
            this.endDate = DateUtils.getMaxMonthDate(this.startDate);
            this.lastPeriodId = null;
            this.standardCurrencyId = init.getDynamicObject("standardcurrency").getLong("id");
            this.precision = BusinessDataServiceHelper.loadSingleFromCache((Object)this.standardCurrencyId, (String)"bd_currency").getInt("amtprecision");
            logger.info("AdjustExchangeContext:precision1:%s", (Object)this.precision);
        } else {
            this.periodId = adjExchPeriodId;
            this.isPeriod = isPeriod;
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)this.periodId, (String)"bd_period");
            logger.info("AdjustExchangeContext:period:%s", EmptyUtils.isNotEmpty(period) ? period.get("name") : "0");
            this.startDate = period.getDate("begindate");
            this.endDate = period.getDate("enddate");
            logger.info("AdjustExchangeContext:startDate:%s,endDate:%s", (Object)this.startDate, (Object)this.endDate);
            this.lastPeriodId = startPeriod.getPkValue().equals(adjExchPeriodId) ? Long.valueOf(0L) : Long.valueOf(PeriodHelper.getPrevPeriod(this.periodId).getLong("id"));
            this.standardCurrencyId = init.getDynamicObject("standardcurrency").getLong("id");
            this.precision = BusinessDataServiceHelper.loadSingleFromCache((Object)this.standardCurrencyId, (String)"bd_currency").getInt("amtprecision");
            logger.info("AdjustExchangeContext:precision2:%s", (Object)this.precision);
        }
        this.isMaterialSettle = "AR".equals(bizSystem) ? "1".equals(SystemParameterHelper.getARAppParameter(orgId, "ar_003")) : "1".equals(SystemParameterHelper.getAPAppParameter(orgId, "ap_003"));
        String removeapps = SettingMapperHelper.getValueFromCache("adjustexchange", "removeapps");
        if (!ObjectUtils.isEmpty((Object)removeapps) && "cas".equals(removeapps.trim())) {
            this.includeCas = false;
        }
        if (!ObjectUtils.isEmpty((Object)(batchCount = SettingMapperHelper.getValueFromCache("adjustexchange", "batchcount"))) && batchCount.trim().matches("^[0-9]*$")) {
            this.billCount = Integer.parseInt(batchCount.trim());
        }
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getLastPeriodId() {
        return this.lastPeriodId;
    }

    public void setLastPeriodId(Long lastPeriodId) {
        this.lastPeriodId = lastPeriodId;
    }

    public Long getStandardCurrencyId() {
        return this.standardCurrencyId;
    }

    public void setStandardCurrencyId(Long standardCurrencyId) {
        this.standardCurrencyId = standardCurrencyId;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isPeriod() {
        return this.isPeriod;
    }

    public void setPeriod(boolean period) {
        this.isPeriod = period;
    }

    public String getBizSystem() {
        return this.bizSystem;
    }

    public void setBizSystem(String bizSystem) {
        this.bizSystem = bizSystem;
    }

    public boolean isMaterialSettle() {
        return this.isMaterialSettle;
    }

    public void setMaterialSettle(boolean materialSettle) {
        this.isMaterialSettle = materialSettle;
    }

    public int getBillCount() {
        return this.billCount;
    }

    public void setBillCount(int billCount) {
        this.billCount = billCount;
    }

    public boolean isIncludeCas() {
        return this.includeCas;
    }

    public void setIncludeCas(boolean includeCas) {
        this.includeCas = includeCas;
    }

    public Map<String, BigDecimal> getExchangeRateMap() {
        return this.exchangeRateMap;
    }

    public void setExchangeRateMap(Map<String, BigDecimal> exchangeRateMap) {
        this.exchangeRateMap = exchangeRateMap;
    }

    public Map<String, String> getQuotationMap() {
        return this.quotationMap;
    }

    public void setQuotationMap(Map<String, String> quotationMap) {
        this.quotationMap = quotationMap;
    }
}

