/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.support.util.ObjectUtils;
import kd.bos.ext.fi.ai.AbstractDapWriteBackImpl;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public abstract class AbstractDapVoucherWriteBack
extends AbstractDapWriteBackImpl {
    public static final String VOUCHERNUM = "vouchernum";
    private static final Log logger = LogFactory.getLog(AbstractDapVoucherWriteBack.class);

    public void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        super.writeBack(operation, billEntityNumber, billToVch);
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
        logger.info("billEntityNumber = " + billEntityNumber);
        if (mt.findProperty(VOUCHERNUM) == null) {
            return;
        }
        Object[] bills = BusinessDataServiceHelper.load((String)billEntityNumber, (String)"id, vouchernum,isvoucher", (QFilter[])new QFilter[]{new QFilter("id", "in", billToVch.keySet())});
        if (VoucherOperation.Create == operation || VoucherOperation.Submit == operation || VoucherOperation.AdjustBillno == operation) {
            for (DynamicObject dynamicObject : bills) {
                Voucher vch = billToVch.get(dynamicObject.getPkValue());
                dynamicObject.set(VOUCHERNUM, (Object)vch.getVoucherNo());
            }
        } else if (VoucherOperation.Delete == operation) {
            for (Object object : bills) {
                object.set(VOUCHERNUM, null);
            }
        } else if ("7".equals(operation.getValue())) {
            for (Object object : bills) {
                Voucher vch = billToVch.get(object.getPkValue());
                object.set(VOUCHERNUM, (Object)vch.getVoucherNo());
            }
            if ("ap_finapbill".equals(billEntityNumber)) {
                for (Object object : bills) {
                    object.set("isvoucher", (Object)Boolean.TRUE);
                }
            }
        }
        if (!ObjectUtils.isEmpty((Object[])bills)) {
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }

    protected String getVchStatusField() {
        return "fisvoucher";
    }

    protected Object getVchEnableStatus() {
        return Boolean.TRUE;
    }

    protected Object getVchDisableStatus() {
        return Boolean.FALSE;
    }

    protected DBRoute getDBRoute() {
        return DBRoute.of((String)"ap");
    }

    public Map<Long, String> validate(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        Map<Long, String> resultMap = new HashMap<Long, String>(billToVch.size());
        if (VoucherOperation.Delete == operation) {
            resultMap = this.validateDelete(billEntityNumber, billToVch);
        }
        return resultMap;
    }

    private Map<Long, String> validateDelete(String billEntityNumber, Map<Long, Voucher> billToVch) {
        String orgField = "ap_payapply".equals(billEntityNumber) ? "settleorg.id" : "org.id";
        DynamicObjectCollection billColl = QueryServiceHelper.query((String)billEntityNumber, (String)("id," + orgField), (QFilter[])new QFilter[]{new QFilter("id", "in", billToVch.keySet())});
        Set voucherIdSet = billToVch.values().stream().map(Voucher::getId).collect(Collectors.toSet());
        if (ObjectUtils.isEmpty(voucherIdSet)) {
            return null;
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(1);
        HashMap<Long, Long> idAndOrgIdMap = new HashMap<Long, Long>(billColl.size());
        for (DynamicObject bill : billColl) {
            long orgId = bill.getLong(orgField);
            long billId = bill.getLong("id");
            idAndOrgIdMap.put(billId, orgId);
            orgIdSet.add(orgId);
        }
        DynamicObjectCollection initColl = QueryServiceHelper.query((String)(this.isAp(billEntityNumber) ? "ap_init" : "ar_init"), (String)"org.id,currentdate,curperiod.enddate,periodtype.id", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIdSet).and(new QFilter("currentdate", "!=", null))});
        HashMap<Long, DynamicObject> orgIdAndInitInfoMap = new HashMap<Long, DynamicObject>(initColl.size());
        for (DynamicObject init : initColl) {
            long orgId = init.getLong("org.id");
            orgIdAndInitInfoMap.put(orgId, init);
        }
        DynamicObjectCollection voucherColl = QueryServiceHelper.query((String)"gl_voucher", (String)"id,period.id,booktype.id,org.id,period.periodtype,period.enddate", (QFilter[])new QFilter[]{new QFilter("id", "in", voucherIdSet)});
        HashMap<Long, DynamicObject> voucherIdAndVoucherMap = new HashMap<Long, DynamicObject>(voucherColl.size());
        for (DynamicObject voucher : voucherColl) {
            long voucherId = voucher.getLong("id");
            voucherIdAndVoucherMap.put(voucherId, voucher);
        }
        return this.buildResultMap(billToVch, idAndOrgIdMap, orgIdAndInitInfoMap, voucherIdAndVoucherMap, billEntityNumber);
    }

    private Map<Long, String> buildResultMap(Map<Long, Voucher> billToVch, Map<Long, Long> idAndOrgIdMap, Map<Long, DynamicObject> orgIdAndInitInfoMap, Map<Long, DynamicObject> voucherIdAndVoucherMap, String billEntityNumber) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(billToVch.size());
        Set<Long> orgIdSet = orgIdAndInitInfoMap.keySet();
        Map<Long, List<Long>> billOrgIdAndBooksTypeMap = this.getBooksType(orgIdSet);
        for (Map.Entry<Long, Voucher> entry : billToVch.entrySet()) {
            long voucherPeriodType;
            long initPeriodType;
            long voucherBookType;
            Long billId = entry.getKey();
            Voucher voucher = entry.getValue();
            Long billOrgId = idAndOrgIdMap.get(billId);
            long voucherId = voucher.getId();
            if (ObjectUtils.isEmpty((Object)billOrgId)) continue;
            DynamicObject initInfo = orgIdAndInitInfoMap.get(billOrgId);
            DynamicObject queryVoucher = voucherIdAndVoucherMap.get(voucherId);
            List<Long> billBooksType = billOrgIdAndBooksTypeMap.get(billOrgId);
            if (queryVoucher == null || billBooksType == null || !billBooksType.contains(voucherBookType = queryVoucher.getLong("booktype.id")) || (initPeriodType = initInfo.getLong("periodtype.id")) != (voucherPeriodType = queryVoucher.getLong("period.periodtype"))) continue;
            Date initInfoDate = initInfo.getDate("curperiod.enddate");
            Date voucherDate = queryVoucher.getDate("period.enddate");
            if (ObjectUtils.isEmpty((Object)initInfoDate) || ObjectUtils.isEmpty((Object)voucherDate) || initInfoDate.compareTo(voucherDate) <= 0) continue;
            String arMessage = ResManager.loadKDString((String)"\u51ed\u8bc1\u671f\u95f4\u5c0f\u4e8e\u5e94\u6536\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u51ed\u8bc1\u3002", (String)"AbstractDapVoucherWriteBack_0", (String)"fi-arapcommon", (Object[])new Object[0]);
            String apMessage = ResManager.loadKDString((String)"\u51ed\u8bc1\u671f\u95f4\u5c0f\u4e8e\u5e94\u4ed8\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u51ed\u8bc1\u3002", (String)"AbstractDapVoucherWriteBack_1", (String)"fi-arapcommon", (Object[])new Object[0]);
            resultMap.put(voucherId, this.isAp(billEntityNumber) ? apMessage : arMessage);
        }
        if (!ObjectUtils.isEmpty(resultMap)) {
            return resultMap;
        }
        return null;
    }

    private boolean isAp(String billEntityNumber) {
        return billEntityNumber.contains("ap_");
    }

    private Map<Long, List<Long>> getBooksType(Set<Long> orgIdSet) {
        DynamicObjectCollection accountBookColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype.id,org.id", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIdSet)});
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(accountBookColl.size());
        for (DynamicObject accountBook : accountBookColl) {
            Long orgId = accountBook.getLong("org.id");
            Long booksTypeId = accountBook.getLong("bookstype.id");
            List booksTypeIdList = resultMap.getOrDefault(orgId, new ArrayList(2));
            booksTypeIdList.add(booksTypeId);
            resultMap.put(orgId, booksTypeIdList);
        }
        return resultMap;
    }
}

