/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;

@Deprecated
public class BusBillWriteBackByFin
extends AbstractWriteBackPlugIn {
    private String selectorar = "id, isperiod, isfullinvoice, invoicedamt, entry.id, entry.e_recamount ";
    private String selectorap = "id, isperiod, isfullinvoice, invoicedamt, entry.id, entry.e_pricetaxtotal ";
    private boolean isAr = false;

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if ("ar_busbill".equals(e.getSrcMainType().getName())) {
            this.isAr = true;
        }
        List lst = e.getFieldKeys();
        lst.add("id");
        lst.add("isperiod");
        lst.add("isfullinvoice");
        lst.add("invoicedamt");
        lst.add("basecurrency");
    }

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("id");
        lst.add(this.isAr ? "entry.e_srcentryid" : "detailentry.e_sourcebillentryid");
        lst.add(this.isAr ? "entry.e_recamount" : "detailentry.e_pricetaxtotal");
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
        String busEntityKey = this.isAr ? "ar_busbill" : "ap_busbill";
        String opType = this.getOpType();
        DynamicObject srcActiveRow = e.getSrcActiveRow();
        DynamicObject srcBill = (DynamicObject)srcActiveRow.getParent();
        if (ObjectUtils.isEmpty((Object)srcBill) || !busEntityKey.equals(srcBill.getDataEntityType().getName())) {
            return;
        }
        boolean only = false;
        if ("Save".equals(opType) || "Draft".equals(opType)) {
            if (!only && busEntityKey.equals(e.getSrcSubMainType().getName())) {
                DynamicObject busBill = (DynamicObject)e.getSrcActiveRow().getParent();
                if (ObjectUtils.isEmpty((Object)e.getTargetActiveRow())) {
                    busBill.set("isfullinvoice", (Object)Boolean.FALSE);
                } else {
                    DynamicObject finbill = (DynamicObject)e.getTargetActiveRow().getParent();
                    BigDecimal actUnInvoicedAmt = BigDecimal.ZERO;
                    if (busBill.getBigDecimal("uninvoicedamt").compareTo(finbill.getBigDecimal(this.isAr ? "recamount" : "pricetaxtotal")) != 0) {
                        DynamicObject queryBusBill = null;
                        queryBusBill = this.isAr ? BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)busEntityKey, (String)this.selectorar) : BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)busEntityKey, (String)this.selectorap);
                        actUnInvoicedAmt = this.reCalcUnInvoicedAmt(queryBusBill, finbill);
                        if (actUnInvoicedAmt.compareTo(BigDecimal.ZERO) == 0) {
                            busBill.set("isfullinvoice", (Object)Boolean.TRUE);
                        } else {
                            busBill.set("isfullinvoice", (Object)Boolean.FALSE);
                        }
                        if (actUnInvoicedAmt.compareTo(busBill.getBigDecimal("invoicedamt")) != 0) {
                            queryBusBill.set("isfullinvoice", (Object)busBill.getBoolean("isfullinvoice"));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{queryBusBill});
                        }
                    } else {
                        busBill.set("isfullinvoice", (Object)Boolean.TRUE);
                    }
                }
                only = true;
            }
        } else if (!only && "Delete".equals(opType) && busEntityKey.equals(e.getSrcSubMainType().getName())) {
            DynamicObject busBill = (DynamicObject)e.getSrcActiveRow().getParent();
            if (busBill.getBoolean("isfullinvoice")) {
                busBill.set("isfullinvoice", (Object)Boolean.FALSE);
            }
            only = true;
        }
    }

    private BigDecimal reCalcUnInvoicedAmt(DynamicObject busBill, DynamicObject finbill) {
        BigDecimal unInvoicedAmt = BigDecimal.ZERO;
        long busPk = (Long)busBill.getPkValue();
        long finPk = (Long)finbill.getPkValue();
        DynamicObjectCollection finbillEntrys = finbill.getDynamicObjectCollection(this.isAr ? "entry" : "detailentry");
        for (DynamicObject busEntry : busBill.getDynamicObjectCollection("entry")) {
            long busEntryPk = (Long)busEntry.getPkValue();
            BigDecimal currentInvoicedAmt = BigDecimal.ZERO;
            for (DynamicObject finEntry : finbillEntrys) {
                if (busEntryPk != finEntry.getLong(this.isAr ? "e_srcentryid" : "e_sourcebillentryid")) continue;
                currentInvoicedAmt = finEntry.getBigDecimal(this.isAr ? "e_recamount" : "e_pricetaxtotal");
                break;
            }
            BigDecimal finInvoicedAmt = this.getFinInvoicedAmt(busPk, busEntryPk, finPk);
            BigDecimal e_unInvoicedAmt = busEntry.getBigDecimal(this.isAr ? "e_recamount" : "e_pricetaxtotal").subtract(finInvoicedAmt.add(currentInvoicedAmt));
            if (e_unInvoicedAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            unInvoicedAmt = unInvoicedAmt.add(e_unInvoicedAmt);
        }
        return unInvoicedAmt;
    }

    private BigDecimal getFinInvoicedAmt(long busPk, long busEntryPk, long finPk) {
        BigDecimal finInvoicedAmt = BigDecimal.ZERO;
        StringBuilder sql = new StringBuilder();
        Object[] params = null;
        if (this.isAr) {
            sql.append(" SELECT SUM(entrys.FRecAmount) as FRecAmount ");
            sql.append(" FROM T_AR_FinArBillEntry entrys ");
            sql.append(" WHERE entrys.FSRCID = ? ");
            sql.append(" AND entrys.FSRCENTRYID = ? ");
            sql.append(" AND entrys.FID <> ? ");
            params = new Object[]{busPk, busEntryPk, finPk};
        } else {
            sql.append(" SELECT SUM(entrys.FPriceTaxTotal) as FRecAmount ");
            sql.append(" FROM T_AP_FinApBillDetailEntry entrys ");
            sql.append(" WHERE entrys.FSOURCEBILLID = ? ");
            sql.append(" AND entrys.FSOURCEBILLENTRYID = ? ");
            sql.append(" AND entrys.FID <> ? ");
            params = new Object[]{String.valueOf(busPk), String.valueOf(busEntryPk), String.valueOf(finPk)};
        }
        try (DataSet ds = DB.queryDataSet((String)"getFinInvoicedAmt", (DBRoute)(this.isAr ? DBRouteConst.AR : DBRouteConst.AP), (String)sql.toString(), (Object[])params);){
            Iterator rowIterator = ds.iterator();
            if (rowIterator != null) {
                while (rowIterator.hasNext()) {
                    Row data = (Row)rowIterator.next();
                    finInvoicedAmt = data.getBigDecimal("FRecAmount") != null ? data.getBigDecimal("FRecAmount") : BigDecimal.ZERO;
                }
            }
        }
        return finInvoicedAmt;
    }
}

