/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.writeback.bill.DisposerInfo;
import kd.fi.arapcommon.service.writeback.bill.FinApLockWBServiceHelper;
import kd.fi.arapcommon.service.writeback.bill.FinArLockWBServiceHelper;

public class PayApplyWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(PayApplyWriteBackPlugin.class);
    private final Map<Long, List<DisposerInfo>> srcWriteBackFinApMap = new HashMap<Long, List<DisposerInfo>>(64);
    private final Map<Long, List<DisposerInfo>> srcWriteBackFinArMap = new HashMap<Long, List<DisposerInfo>>(64);
    private final List<String> fieldKeys = Arrays.asList("lockedamt", "planlockedamt", "planlockedamt", "e_lockedamt");
    private boolean isClose = false;

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        List disposerInfos;
        DisposerInfo info;
        if (!this.fieldKeys.contains(e.getSrcFieldKey())) {
            return;
        }
        String srcEntityKey = e.getSrcSubMainType().getName();
        DynamicObject srcBill = (DynamicObject)e.getSrcActiveRow().getParent();
        long sourceId = srcBill.getLong("id");
        long sourceEntryId = e.getSrcActiveRow().getLong("id");
        long tarRowId = e.getTargetRowId().getEntryId();
        BigDecimal disposeAmt = this.getNeedWriteBackAmount(e);
        if ("ap_finapbill".equals(srcEntityKey)) {
            info = new DisposerInfo(sourceId, sourceEntryId, disposeAmt);
            disposerInfos = this.srcWriteBackFinApMap.getOrDefault(tarRowId, new ArrayList(8));
            disposerInfos.add(info);
            this.srcWriteBackFinApMap.put(tarRowId, disposerInfos);
        }
        if ("ar_finarbill".equals(srcEntityKey)) {
            info = new DisposerInfo(sourceId, sourceEntryId, disposeAmt.negate());
            disposerInfos = this.srcWriteBackFinArMap.getOrDefault(tarRowId, new ArrayList(8));
            disposerInfos.add(info);
            this.srcWriteBackFinArMap.put(tarRowId, disposerInfos);
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        Map<Long, DisposerInfo> writeBackFinArMap;
        logger.info("PayApplyWriteBackPlugin afterSaveSourceBill start ");
        Object[] srcDataEntities = e.getSrcDataEntities();
        if (ObjectUtils.isEmpty((Object[])srcDataEntities)) {
            return;
        }
        String entityName = srcDataEntities[0].getDataEntityType().getName();
        if (!"ap_finapbill".equals(entityName) && !"ar_finarbill".equals(entityName)) {
            return;
        }
        logger.info("PayApplyWriteBackPlugin afterSaveSourceBill begin writeback finAp and finAr ");
        boolean isRelease = this.isRelease() || this.isClose;
        Map<Long, DisposerInfo> writeBackFinApMap = ArApHelper.processWriteBackMap(this.srcWriteBackFinApMap);
        if (!writeBackFinApMap.isEmpty() && "ap_finapbill".equals(entityName)) {
            logger.info("PayApplyWriteBackPlugin afterSaveSourceBill writeBackFinApMap not null ");
            Set<Long> finApBillIds = writeBackFinApMap.values().stream().map(DisposerInfo::getSourceId).collect(Collectors.toSet());
            CommonSettleServiceHelper.settleAddMutexCtrlInTX(finApBillIds, "ap_finapbill", false);
            if (isRelease) {
                FinApLockWBServiceHelper.inverseWriteBack(finApBillIds, writeBackFinApMap);
            } else {
                FinApLockWBServiceHelper.directWriteBack(finApBillIds, writeBackFinApMap);
            }
        }
        if (!(writeBackFinArMap = ArApHelper.processWriteBackMap(this.srcWriteBackFinArMap)).isEmpty() && "ar_finarbill".equals(entityName)) {
            logger.info("PayApplyWriteBackPlugin afterSaveSourceBill writeBackFinArMap not null ");
            Set<Long> finArBillIds = writeBackFinArMap.values().stream().map(DisposerInfo::getSourceId).collect(Collectors.toSet());
            CommonSettleServiceHelper.settleAddMutexCtrlInTX(finArBillIds, "ar_finarbill", false);
            if (isRelease) {
                FinArLockWBServiceHelper.inverseWriteBack(finArBillIds, writeBackFinArMap);
            } else {
                FinArLockWBServiceHelper.directWriteBack(finArBillIds, writeBackFinArMap);
            }
        }
    }

    private BigDecimal getNeedWriteBackAmount(AfterCommitAmountEventArgs e) {
        BigDecimal disposeAmt = e.getCurrVal();
        if (this.isRelease()) {
            disposeAmt = disposeAmt.negate();
        } else {
            DynamicObject targetActiveRow;
            if ("save".equalsIgnoreCase(this.getOpType()) && (targetActiveRow = e.getTargetActiveRow()) != null) {
                DynamicObject target = (DynamicObject)targetActiveRow.getParent();
                if ("D".equals(target.getString("billstatus")) || "E".equals(target.getString("billstatus"))) {
                    this.isClose = true;
                }
                if ("C".equals(target.getString("billstatus"))) {
                    disposeAmt = disposeAmt.negate();
                }
            }
            if ("UnCancel".equalsIgnoreCase(this.getOpType())) {
                disposeAmt = disposeAmt.negate();
            }
        }
        return disposeAmt;
    }

    private boolean isRelease() {
        String opType = this.getOpType();
        return "delete".equalsIgnoreCase(opType) || "invalid".equalsIgnoreCase(opType);
    }
}

