/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeTrackEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class PurInBill2BusBillWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static ThreadLocal<Set<Long>> hasApBusBillThreadLocal = new ThreadLocal();

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        e.getFieldKeys().add("sourcebilltype");
        e.getFieldKeys().add("isrevaluation");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("isadjust");
    }

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        e.getFieldKeys().add("hasapbusbill");
    }

    public void beforeTrack(BeforeTrackEventArgs e) {
        super.beforeTrack(e);
        DynamicObject entity = e.getDataEntity();
        boolean isRevaluation = entity.getBoolean("isrevaluation");
        String srcBillType = entity.getString("sourcebilltype");
        String billType = entity.getString("billtype.number");
        boolean isAdjust = entity.getBoolean("isadjust");
        if (!isAdjust && !isRevaluation && !"ap_busbill_purfee_BT_S".equals(billType) && "im_purinbill".equals(srcBillType)) {
            Set<Long> tarBillIds = hasApBusBillThreadLocal.get();
            if (tarBillIds == null) {
                tarBillIds = new HashSet<Long>(4);
            }
            hasApBusBillThreadLocal.set(tarBillIds);
            tarBillIds.add((Long)entity.getPkValue());
        }
    }

    public void afterReadSourceBill(AfterReadSourceBillEventArgs e) {
        super.afterReadSourceBill(e);
        DynamicObject[] srcDataEntities = e.getSrcDataEntities();
        if (srcDataEntities == null) {
            return;
        }
        Set<Long> apBusBillId = hasApBusBillThreadLocal.get();
        if (apBusBillId == null) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(srcDataEntities.length);
        for (DynamicObject srcDataEntity : srcDataEntities) {
            ids.add((Long)srcDataEntity.getPkValue());
        }
        Set<Long> linkDownApBusBillIds = this.getLinkDownApBusBillIds(ids);
        linkDownApBusBillIds.removeAll(apBusBillId);
        QFilter filter = new QFilter("id", "in", linkDownApBusBillIds);
        DataSet apBusBills = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ap_busbill", (String)"id,isrevaluation,isadjust,billtype.number", (QFilter[])filter.toArray(), null);
        while (apBusBills.hasNext()) {
            Row entity = apBusBills.next();
            boolean isRevaluation = entity.getBoolean("isrevaluation");
            String billType = entity.getString("billtype.number");
            boolean isAdjust = entity.getBoolean("isadjust");
            if (!isRevaluation && !isAdjust && !"ap_busbill_purfee_BT_S".equals(billType)) continue;
            linkDownApBusBillIds.remove(entity.getLong("id"));
        }
        if (linkDownApBusBillIds.size() > 0) {
            hasApBusBillThreadLocal.remove();
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u5931\u8d25\uff0c\u91c7\u8d2d\u5165\u5e93\u5355\u5df2\u751f\u6210\u53e6\u59161\u5f20\u6682\u4f30\u5e94\u4ed8\u5355\u3002", (String)"PurInBill2BusBillWriteBackPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        hasApBusBillThreadLocal.remove();
    }

    private Set<Long> getLinkDownApBusBillIds(List<Long> srcBillIds) {
        List bfRows = BFTrackerServiceHelper.loadBillLinkDown((String)"im_purinbill", (Long[])srcBillIds.toArray(new Long[0]), (boolean)true);
        HashSet<Long> linkDownBillIds = new HashSet<Long>(bfRows.size());
        Iterator iterator = bfRows.iterator();
        while (iterator.hasNext()) {
            ConvertDataService reader = new ConvertDataService();
            BFRow tarBfRow = (BFRow)iterator.next();
            BFRowId rowId = tarBfRow.getId();
            Long mainTableId = rowId.getMainTableId();
            TableDefine tableDefine = reader.loadTableDefine(mainTableId);
            String entityNumber = tableDefine.getEntityNumber();
            if (!"ap_busbill".equals(entityNumber)) continue;
            linkDownBillIds.add(rowId.getBillId());
        }
        return linkDownBillIds;
    }
}

