/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeSaveSourceBillEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;

public class RevCfmBillWriteBack
extends AbstractWriteBackPlugIn {
    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        List lst = e.getFieldKeys();
        lst.add("id");
        lst.add("payproperty");
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        DynamicObject[] srcDataEntities = e.getSrcDataEntities();
        HashSet<Long> finArbillIds = new HashSet<Long>(srcDataEntities.length);
        for (DynamicObject srcBill : srcDataEntities) {
            if (!"ar_finarbill".equals(srcBill.getDataEntityType().getName())) continue;
            finArbillIds.add(srcBill.getLong("id"));
        }
        if (finArbillIds.size() > 0) {
            this.writeBackFinAr(finArbillIds);
        }
    }

    private void writeBackFinAr(Set<Long> finArbillIds) {
        DynamicObject[] srcBills;
        for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", finArbillIds)})) {
            this.executeWriteBack(srcBill);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{srcBill});
        }
    }

    private void executeWriteBack(DynamicObject srcBill) {
        for (DynamicObject entry : srcBill.getDynamicObjectCollection("entry")) {
            BigDecimal e_confirmedamt = entry.getBigDecimal("e_confirmedamt");
            BigDecimal e_confirmedqty = entry.getBigDecimal("e_confirmedqty");
            BigDecimal e_quantity = entry.getBigDecimal("e_quantity");
            BigDecimal e_recamount = entry.getBigDecimal("e_recamount");
            BigDecimal e_baseunitqty = entry.getBigDecimal("e_baseunitqty");
            DynamicObject e_baseunit = entry.getDynamicObject("e_baseunit");
            BigDecimal e_unitcoefficient = entry.getBigDecimal("e_unitcoefficient");
            if (e_confirmedqty.compareTo(e_quantity) == 0) {
                entry.set("e_confirmedbaseqty", (Object)e_baseunitqty);
                entry.set("e_unconfirmbaseqty", (Object)BigDecimal.ZERO);
                continue;
            }
            if (e_confirmedqty.compareTo(BigDecimal.ZERO) == 0) {
                entry.set("e_confirmedbaseqty", (Object)BigDecimal.ZERO);
                entry.set("e_unconfirmbaseqty", (Object)e_baseunitqty);
                continue;
            }
            BigDecimal e_confirmedbaseqty = UnitConvertHelper.getBaseunitqty(e_confirmedqty, e_unitcoefficient, e_baseunit);
            entry.set("e_confirmedbaseqty", (Object)e_confirmedbaseqty);
            entry.set("e_unconfirmbaseqty", (Object)e_baseunitqty.subtract(e_confirmedbaseqty));
        }
    }

    private List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("e_confirmedamt");
        lst.add("e_confirmedqty");
        lst.add("e_recamount");
        lst.add("e_baseunitqty");
        lst.add("e_quantity");
        lst.add("e_localamt");
        lst.add("e_baseunit");
        lst.add("e_unitcoefficient");
        lst.add("e_confirmedbaseqty");
        lst.add("e_unconfirmbaseqty");
        lst.add("e_confirmedlocamt");
        lst.add("e_unconfirmlocamt");
        return lst;
    }

    public void beforeSaveSourceBill(BeforeSaveSourceBillEventArgs e) {
        e.getSrcDataEntities();
    }
}

