/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.FinishWriteBackEventArgs;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.helper.UpgradeConfigHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;

public class RevCfmSrcBillWriteBackRepair
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(RevCfmSrcBillWriteBackRepair.class);
    private Set<Long> busArBaseAmtbillIds = new HashSet<Long>(2);
    private Set<Long> busArBaseQtybillIds = new HashSet<Long>(2);

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        List lst = e.getFieldKeys();
        lst.add("id");
        lst.add("createtime");
        lst.add("payproperty");
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        DynamicObject[] srcDataEntities;
        super.afterSaveSourceBill(e);
        for (DynamicObject srcBill : srcDataEntities = e.getSrcDataEntities()) {
            if (!"ar_busbill".equals(srcBill.getDataEntityType().getName()) || !UpgradeConfigHelper.isHistoryBill("BIZ_V5.0.018_DataUpgrade", srcBill.getDate("createtime"))) continue;
            if (srcBill.getBoolean("payproperty.isbasedonamt")) {
                this.busArBaseAmtbillIds.add(srcBill.getLong("id"));
                continue;
            }
            this.busArBaseQtybillIds.add(srcBill.getLong("id"));
        }
    }

    public void finishWriteBack(FinishWriteBackEventArgs e) {
        super.finishWriteBack(e);
        if (this.busArBaseAmtbillIds.size() > 0 || this.busArBaseQtybillIds.size() > 0) {
            this.invokeRepairService();
        }
    }

    private void invokeRepairService() {
        try (TXHandle tx = TX.requiresNew();){
            try {
                long uniqueKey = DB.genGlobalLongId();
                CommonParam param = new CommonParam();
                param.put((Object)"uniquekey", (Object)uniqueKey);
                param.put((Object)"methodName", (Object)"repairBusArBills");
                param.put((Object)"busArBaseAmtbillIds", this.busArBaseAmtbillIds);
                param.put((Object)"busArBaseQtybillIds", this.busArBaseQtybillIds);
                logger.info("invoke.DataUpgradeRepairService.repairBills begin");
                ECServiceHelper.beginAndRegister("arap_dataupgrade_repair", "ar_busar_repaircfmqty", "fi", "ar", "DataUpgradeRepairService", (Param)param, "");
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public void beforeSaveSourceBill(BeforeSaveSourceBillEventArgs e) {
        e.getSrcDataEntities();
    }
}

