/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback.settle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.EntryWBTypeEnum;
import kd.fi.arapcommon.enums.SettleEntryEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.PaySettle4ScmcHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.entry.EntryWBParam;
import kd.fi.arapcommon.writeback.entry.PrePlanWBService;
import kd.fi.arapcommon.writeback.settle.AbstractSettleWBService;

public class ArPreSettleWBService
extends AbstractSettleWBService {
    private static final Log logger = LogFactory.getLog(ArPreSettleWBService.class);
    protected Map<Long, SettleRecordVO> settleRecordMap;
    protected Map<Long, Integer> settleRecordSize4MaterialMap = new HashMap<Long, Integer>(16);
    protected Map<Long, Integer> settleRecordSize4PlanMap = new HashMap<Long, Integer>(16);
    protected PrePlanWBService prePlanWBService;

    @Override
    public void writeBack(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        this.settleRecordMap = this.getSettleRecordGroupMap(voList);
        logger.info("ArPremSettleWBService writeback as main start");
        this.writeBack0(voList, scheme, true);
        logger.info("ArPremSettleWBService writeback as main end");
    }

    private List<SettleRecordVO> writeBack0(List<SettleRecordVO> voList, SettleSchemeVO scheme, boolean isMain) {
        this.prePlanWBService = BeanFactory.getBean(PrePlanWBService.class, new Object[0]);
        HashSet<Long> billIdSet = new HashSet<Long>(voList.size());
        for (SettleRecordVO result : voList) {
            billIdSet.add(result.getMainBillId());
        }
        if (scheme.getSettleEntryParam() == 0) {
            scheme.setSettleEntryParam(voList.get(0).getSettleEntry());
        }
        DynamicObject[] arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, DynamicObject> arBillMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> arBillEntryMap = new HashMap<Long, DynamicObject>(64);
        boolean isSettleByMaterial = SettleEntryEnum.DETAIL.getValue() == voList.get(0).getSettleEntry();
        for (DynamicObject arBill : arBills) {
            DynamicObjectCollection entries;
            arBillMap.put(arBill.getLong("id"), arBill);
            if (isSettleByMaterial) {
                entries = arBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    arBillEntryMap.put(entry.getLong("id"), entry);
                }
                continue;
            }
            entries = arBill.getDynamicObjectCollection("planentity");
            for (DynamicObject entry : entries) {
                arBillEntryMap.put(entry.getLong("id"), entry);
            }
        }
        boolean isSettle = scheme.isSettle();
        Set<Long> recEntryIdSet = this.getConfirmRecSet(voList);
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>(voList.size());
        this.initPreParamMap(arBillMap, scheme);
        logger.info("ArPreSettleWBService writeback entry start");
        for (SettleRecordVO result : voList) {
            long mainBillId = result.getMainBillId();
            long mainBillEntryId = result.getMainBillEntryId();
            BigDecimal settleAmt = result.getTotalSettleAmt();
            BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
            if (!result.getEntrys().isEmpty()) {
                scheme.setAsstBillId(result.getEntrys().get(0).getBillId());
                scheme.setAsstEntity(result.getEntrys().get(0).getBillEntity());
            }
            if (!isSettle) {
                settleAmt = settleAmt.negate();
                localSettleAmt = localSettleAmt.negate();
            }
            DynamicObject bill = (DynamicObject)arBillMap.get(mainBillId);
            this.wbHead(bill, settleAmt, localSettleAmt);
            if (isMain) {
                this.processCoreBillParam(rowList, bill, settleAmt, (DynamicObject)arBillEntryMap.get(mainBillEntryId), scheme, result, recEntryIdSet);
            }
            boolean isWBLock = this.needWBLock(result, scheme, "ar_finarbill");
            this.wbEntry(bill, result, scheme, isWBLock);
        }
        logger.info("FinArSettleWBService writeback entry end");
        for (DynamicObject bill : arBills) {
            bill.set("settlestatus", (Object)this.getBillSettleStatus(bill));
        }
        logger.info("FinArSettleWBService writeback ICallOrderConInvoker start");
        Settle4ScmcHelper.newWriteBackPurAndCon(voList, arBills, scheme, null);
        logger.info("FinArSettleWBService writeback ICallOrderConInvoker end");
        DynamicObject[] dynamicObjects = arBillMap.values().toArray(new DynamicObject[0]);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        logger.info("FinArSettleWBService writeback coreBill start");
        if (isMain) {
            PaySettle4ScmcHelper.disposeCoreBillExceptScmc(rowList, isSettle);
        }
        logger.info("FinArSettleWBService writeback coreBill end");
        logger.info("FinArSettleWBService writeback reservebaddebt start");
        ArrayList<DynamicObject> needReserveArBills = new ArrayList<DynamicObject>(8);
        for (Map.Entry arBillEntrySet : arBillMap.entrySet()) {
            DynamicObject arBill = (DynamicObject)arBillEntrySet.getValue();
            if (!arBill.getBoolean("isperiod")) continue;
            needReserveArBills.add(arBill);
        }
        if (needReserveArBills.size() > 0) {
            this.disposeReserveBill(needReserveArBills);
        }
        logger.info("FinArSettleWBService writeback reservebaddebt end");
        OpLogServiceHelper.addLog(isSettle ? "settle" : "unsettle", (Object)scheme.toString(), dynamicObjects, false);
        return voList;
    }

    private void disposeReserveBill(List<DynamicObject> periodBills) {
        DynamicObject[] initReserves;
        HashMap<Long, DynamicObject> needReverseBillMap = new HashMap<Long, DynamicObject>(1);
        for (DynamicObject wbAfterBill : periodBills) {
            needReverseBillMap.put(wbAfterBill.getLong("id"), wbAfterBill);
        }
        if (needReverseBillMap.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("sourcebillid", "in", needReverseBillMap.keySet());
        for (DynamicObject initReserve : initReserves = BusinessDataServiceHelper.load((String)"ar_baddebtreservebill", (String)"id, sourcebillid, unsettleamt, unsettlelocalamt, baddebtreserveamt, referencerate", (QFilter[])new QFilter[]{qFilter})) {
            long finArBillId = initReserve.getLong("sourcebillid");
            DynamicObject bill = (DynamicObject)needReverseBillMap.get(finArBillId);
            initReserve.set("unsettleamt", (Object)bill.getBigDecimal("unsettleamount"));
            BigDecimal unSettleLocAmt = bill.getBigDecimal("unsettlelocalamt");
            initReserve.set("unsettlelocalamt", (Object)unSettleLocAmt);
            int precision = bill.getBigDecimal("exchangerate").scale();
            if (unSettleLocAmt.compareTo(BigDecimal.ZERO) != 0) {
                initReserve.set("referencerate", (Object)initReserve.getBigDecimal("baddebtreserveamt").divide(initReserve.getBigDecimal("unsettlelocalamt"), 2 + precision, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(precision, RoundingMode.HALF_UP));
                continue;
            }
            initReserve.set("referencerate", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])initReserves);
    }

    private String getBillSettleStatus(DynamicObject bill) {
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("entry");
        boolean settled = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal unsettleAmt = entry.getBigDecimal("e_unsettleamt");
            if (unsettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            settled = false;
            break;
        }
        if (settled) {
            return "settled";
        }
        boolean unSettle = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal settledAmt = entry.getBigDecimal("e_settledamt");
            if (settledAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            unSettle = false;
            break;
        }
        if (unSettle) {
            return "unsettle";
        }
        return "partsettle";
    }

    private void wbEntry(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        this.wbEntryByPlan(bill, result, scheme, isWBLock);
        this.wbEntryByMaterial(bill, result, scheme, isWBLock);
    }

    protected void wbEntryByPlan(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        long id = bill.getLong("id");
        EntryWBParam param = new EntryWBParam();
        param.setNeedWBLock(isWBLock);
        param.setForward(scheme.isSettle());
        param.setWbType(EntryWBTypeEnum.SETTLE.getValue());
        param.setWbAmt(result.getTotalSettleAmt());
        param.setWbLocalAmt(result.getLocalTotalSettleamt());
        if (this.settleRecordMap != null && this.settleRecordMap.get(id) != null) {
            Integer settleRecordSize = this.settleRecordSize4PlanMap.get(id);
            if (settleRecordSize == 1) {
                SettleRecordVO settleRecordVO = this.settleRecordMap.get(id);
                param.setWbAmt(settleRecordVO.getTotalSettleAmt());
                param.setWbLocalAmt(settleRecordVO.getLocalTotalSettleamt());
                this.prePlanWBService.execute(bill, param);
            } else {
                settleRecordSize = settleRecordSize - 1;
                this.settleRecordSize4PlanMap.put(id, settleRecordSize);
            }
        } else {
            this.prePlanWBService.execute(bill, param);
        }
    }

    private void wbEntryByMaterial(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        long id = bill.getLong("id");
        if (this.settleRecordMap != null && this.settleRecordMap.get(id) != null) {
            Integer settleRecordSize = this.settleRecordSize4MaterialMap.get(id);
            if (settleRecordSize == 1) {
                SettleRecordVO settleRecordVO = this.settleRecordMap.get(id);
                this.wbMaterialEntryByStrategy(bill, settleRecordVO, scheme, isWBLock);
            } else {
                settleRecordSize = settleRecordSize - 1;
                this.settleRecordSize4MaterialMap.put(id, settleRecordSize);
            }
        } else {
            this.wbMaterialEntryByStrategy(bill, result, scheme, isWBLock);
        }
    }

    private void wbMaterialEntryByStrategy(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        BigDecimal settleAmt = result.getTotalSettleAmt();
        BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
        if (!scheme.isSettle()) {
            settleAmt = settleAmt.negate();
            localSettleAmt = localSettleAmt.negate();
        }
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        DynamicObject currency = bill.getDynamicObject("currency");
        int scale = currency == null ? 2 : currency.getInt("amtprecision");
        DynamicObject basecurrency = bill.getDynamicObject("basecurrency");
        int baseScale = basecurrency == null ? 2 : basecurrency.getInt("amtprecision");
        String quotation = bill.getString("quotation");
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
        List noPresenEntries = entries.stream().filter(entry -> entry.getBigDecimal("e_recamount").compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        BigDecimal headAmt = bill.getBigDecimal("recamount");
        boolean isSettleDisposeAll = bill.getBigDecimal("unsettleamount").compareTo(BigDecimal.ZERO) == 0;
        boolean isUnSettleDisposeAll = bill.getBigDecimal("settleamount").compareTo(BigDecimal.ZERO) == 0;
        DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
        BigDecimal remainPlanLockAmt = BigDecimal.ZERO;
        for (DynamicObject planEntry : planEntries) {
            remainPlanLockAmt = remainPlanLockAmt.add(planEntry.getBigDecimal("planlockedamt"));
        }
        boolean isWriteBackLockAll = remainPlanLockAmt.compareTo(BigDecimal.ZERO) == 0;
        int entryCount = 0;
        BigDecimal remainSettleAmt = settleAmt;
        BigDecimal remainLocalSettleAmt = localSettleAmt;
        BigDecimal remainLockAmt = settleAmt;
        for (DynamicObject entry2 : noPresenEntries) {
            ++entryCount;
            BigDecimal entryAmt = entry2.getBigDecimal("e_recamount");
            BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
            BigDecimal curSettleAmt = settleAmt.multiply(proportion).setScale(scale, RoundingMode.HALF_UP);
            if (isSettleDisposeAll) {
                entry2.set("e_unsettleamt", (Object)BigDecimal.ZERO);
                entry2.set("e_settledamt", (Object)entryAmt);
                entry2.set("e_unsettlelocalamt", (Object)BigDecimal.ZERO);
                entry2.set("e_settledlocalamt", (Object)entry2.getBigDecimal("e_reclocalamt"));
            } else if (isUnSettleDisposeAll) {
                entry2.set("e_unsettleamt", (Object)entryAmt);
                entry2.set("e_settledamt", (Object)BigDecimal.ZERO);
                entry2.set("e_unsettlelocalamt", (Object)entry2.getBigDecimal("e_reclocalamt"));
                entry2.set("e_settledlocalamt", (Object)BigDecimal.ZERO);
            } else if (entryCount == noPresenEntries.size()) {
                entry2.set("e_unsettleamt", (Object)entry2.getBigDecimal("e_unsettleamt").subtract(remainSettleAmt));
                entry2.set("e_settledamt", (Object)entry2.getBigDecimal("e_settledamt").add(remainSettleAmt));
                entry2.set("e_unsettlelocalamt", (Object)entry2.getBigDecimal("e_unsettlelocalamt").subtract(remainLocalSettleAmt));
                entry2.set("e_settledlocalamt", (Object)entry2.getBigDecimal("e_settledlocalamt").add(remainLocalSettleAmt));
            } else {
                entry2.set("e_unsettleamt", (Object)entry2.getBigDecimal("e_unsettleamt").subtract(curSettleAmt));
                entry2.set("e_settledamt", (Object)entry2.getBigDecimal("e_settledamt").add(curSettleAmt));
                BigDecimal curLocalSettleAmt = CommonSettleServiceHelper.getLocamtByQuotation(quotation, curSettleAmt, exchangeRate, baseScale);
                entry2.set("e_unsettlelocalamt", (Object)entry2.getBigDecimal("e_unsettlelocalamt").subtract(curLocalSettleAmt));
                entry2.set("e_settledlocalamt", (Object)entry2.getBigDecimal("e_settledlocalamt").add(curLocalSettleAmt));
                remainSettleAmt = remainSettleAmt.subtract(curSettleAmt);
                remainLocalSettleAmt = remainLocalSettleAmt.subtract(curLocalSettleAmt);
            }
            if (!isWBLock) continue;
            if (isSettleDisposeAll) {
                entry2.set("e_unlockamt", (Object)BigDecimal.ZERO);
                entry2.set("e_lockedamt", (Object)entryAmt);
                continue;
            }
            if (isUnSettleDisposeAll && isWriteBackLockAll) {
                entry2.set("e_unlockamt", (Object)entryAmt);
                entry2.set("e_lockedamt", (Object)BigDecimal.ZERO);
                continue;
            }
            if (entryCount == noPresenEntries.size()) {
                entry2.set("e_unlockamt", (Object)entry2.getBigDecimal("e_unlockamt").subtract(remainLockAmt));
                entry2.set("e_lockedamt", (Object)entry2.getBigDecimal("e_lockedamt").add(remainLockAmt));
                continue;
            }
            entry2.set("e_unlockamt", (Object)entry2.getBigDecimal("e_unlockamt").subtract(curSettleAmt));
            entry2.set("e_lockedamt", (Object)entry2.getBigDecimal("e_lockedamt").add(curSettleAmt));
            remainLockAmt = remainLockAmt.subtract(curSettleAmt);
        }
    }

    public void processCoreBillParam(List<Map<String, Object>> rowList, DynamicObject bill, BigDecimal settleAmt, DynamicObject entry, SettleSchemeVO scheme, SettleRecordVO result, Set<Long> recEntryIdSet) {
        String settleRelation = result.getSettleRela();
        if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARPAYSETTLE.getValue().equals(settleRelation)) {
            DynamicObject currency = bill.getDynamicObject("currency");
            if (1 == result.getSettleEntry()) {
                if (entry == null) {
                    return;
                }
                String corebillType = entry.getString("e_corebilltype");
                String corebillNo = entry.getString("e_corebillno");
                long corebillId = entry.getLong("corebillid");
                if (corebillId != 0L && !ObjectUtils.isEmpty((Object)corebillType) && !ObjectUtils.isEmpty((Object)corebillNo)) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("mainbilltype", corebillType);
                    row.put("mainbillid", corebillId);
                    row.put("mainbillentryid", entry.getLong("corebillentryid"));
                    row.put("apbillid", bill.getLong("id"));
                    row.put("apbillentryid", entry.getLong("id"));
                    row.put("currencyid", currency.getLong("id"));
                    row.put("orgid", bill.getLong("org.id"));
                    row.put("asstactid", bill.getLong("asstact.id"));
                    row.put("asstacttype", bill.getString("asstacttype"));
                    BigDecimal confirmAmt = this.getConfirmAmt(settleRelation, scheme, recEntryIdSet, result, currency);
                    settleAmt = settleAmt.subtract(confirmAmt);
                    row.put("paidamount", settleAmt);
                    row.put("confirmlogo", Boolean.FALSE);
                    rowList.add(row);
                }
            } else {
                DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("entry");
                BigDecimal headAmt = bill.getBigDecimal("recamount");
                BigDecimal headUnSettle = bill.getBigDecimal("unsettleamount");
                BigDecimal confirmAmt = this.getConfirmAmt(settleRelation, scheme, recEntryIdSet, result, currency);
                settleAmt = settleAmt.subtract(confirmAmt);
                headUnSettle = headUnSettle.add(confirmAmt);
                int count = 0;
                BigDecimal remainDisposeAmount = settleAmt;
                for (DynamicObject detailEntry : detailColl) {
                    BigDecimal disposeAmt;
                    BigDecimal entryAmt = detailEntry.getBigDecimal("e_recamount");
                    String corebillType = detailEntry.getString("e_corebilltype");
                    String corebillNo = detailEntry.getString("e_corebillno");
                    long corebillId = detailEntry.getLong("corebillid");
                    if (corebillId == 0L || ObjectUtils.isEmpty((Object)corebillType) || ObjectUtils.isEmpty((Object)corebillNo)) continue;
                    if (headUnSettle.compareTo(headAmt) == 0) {
                        disposeAmt = scheme.isSettle() ? detailEntry.getBigDecimal("e_settledamt") : detailEntry.getBigDecimal("e_settledamt").negate();
                    } else if (headUnSettle.compareTo(BigDecimal.ZERO) == 0) {
                        disposeAmt = scheme.isSettle() ? detailEntry.getBigDecimal("e_unsettleamt") : detailEntry.getBigDecimal("e_unsettleamt").negate();
                    } else if (++count == detailColl.size()) {
                        disposeAmt = remainDisposeAmount;
                    } else {
                        BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
                        disposeAmt = settleAmt.multiply(proportion).setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                        remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("mainbilltype", corebillType);
                    row.put("mainbillid", corebillId);
                    row.put("mainbillentryid", detailEntry.getLong("corebillentryid"));
                    row.put("apbillid", bill.getLong("id"));
                    row.put("apbillentryid", detailEntry.getLong("id"));
                    row.put("currencyid", currency.getLong("id"));
                    row.put("orgid", bill.getLong("org.id"));
                    row.put("asstactid", bill.getLong("asstact.id"));
                    row.put("asstacttype", bill.getString("asstacttype"));
                    row.put("paidamount", disposeAmt);
                    row.put("confirmlogo", Boolean.FALSE);
                    rowList.add(row);
                }
            }
        }
    }

    private BigDecimal getConfirmAmt(String settleRelation, SettleSchemeVO scheme, Set<Long> recEntryIdSet, SettleRecordVO result, DynamicObject currency) {
        BigDecimal confirmAmt = BigDecimal.ZERO;
        if (!SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation)) {
            return confirmAmt;
        }
        List<SettleRecordEntryVO> entrys = result.getEntrys();
        if (entrys.get(0).getCurrencyId() != currency.getLong("id")) {
            return confirmAmt;
        }
        for (SettleRecordEntryVO entry : entrys) {
            long billEntryId = entry.getBillEntryId();
            if (!recEntryIdSet.contains(billEntryId)) continue;
            confirmAmt = confirmAmt.add(entry.getSettleAmt());
        }
        return scheme.isSettle() ? confirmAmt : confirmAmt.negate();
    }

    private void wbHead(DynamicObject bill, BigDecimal settleAmt, BigDecimal localSettleAmt) {
        boolean isUnSettleDisposeAll;
        bill.set("unsettleamount", (Object)bill.getBigDecimal("unsettleamount").subtract(settleAmt));
        bill.set("settleamount", (Object)bill.getBigDecimal("settleamount").add(settleAmt));
        boolean isSettleDisposeAll = bill.getBigDecimal("unsettleamount").compareTo(BigDecimal.ZERO) == 0;
        boolean bl = isUnSettleDisposeAll = bill.getBigDecimal("settleamount").compareTo(BigDecimal.ZERO) == 0;
        if (isSettleDisposeAll) {
            bill.set("unsettlelocalamt", (Object)BigDecimal.ZERO);
            bill.set("settlelocalamt", (Object)bill.getBigDecimal("reclocalamt"));
        } else if (isUnSettleDisposeAll) {
            bill.set("unsettlelocalamt", (Object)bill.getBigDecimal("reclocalamt"));
            bill.set("settlelocalamt", (Object)BigDecimal.ZERO);
        } else {
            bill.set("unsettlelocalamt", (Object)bill.getBigDecimal("unsettlelocalamt").subtract(localSettleAmt));
            bill.set("settlelocalamt", (Object)bill.getBigDecimal("settlelocalamt").add(localSettleAmt));
        }
    }

    private Set<Long> getConfirmRecSet(List<SettleRecordVO> voList) {
        HashSet<Long> idSet = new HashSet<Long>(64);
        String settleRela = voList.get(0).getSettleRela();
        if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRela)) {
            for (SettleRecordVO result : voList) {
                List<SettleRecordEntryVO> entrys = result.getEntrys();
                for (SettleRecordEntryVO entry : entrys) {
                    idSet.add(entry.getBillId());
                }
            }
            DynamicObjectCollection recColl = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet), new QFilter("confirmlogo", "=", (Object)Boolean.TRUE), new QFilter("entry.e_corebilltype", "=", (Object)"sm_salorder")});
            DynamicObjectCollection recScmColl = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet), new QFilter("entry.e_matchselltag", "=", (Object)Boolean.TRUE)});
            recColl.addAll((Collection)recScmColl);
            idSet.clear();
            for (DynamicObject rec : recColl) {
                idSet.add(rec.getLong("entry.id"));
            }
            logger.info("getConfirmRecSet idSet:" + idSet);
        }
        return idSet;
    }

    private void initPreParamMap(Map<Long, DynamicObject> arBillMap, SettleSchemeVO scheme) {
        block6: {
            List<Long> preSettledPks;
            DynamicObjectCollection result;
            boolean settle = scheme.isSettle();
            if (settle && 2 == scheme.getSettleEntryParam()) {
                return;
            }
            ArrayList<Long> arBillIds = new ArrayList<Long>(arBillMap.size());
            Set<Map.Entry<Long, DynamicObject>> entrySet = arBillMap.entrySet();
            for (Map.Entry<Long, DynamicObject> entry : entrySet) {
                DynamicObject bill = entry.getValue();
                if (bill.getBigDecimal("premiumamt").compareTo(BigDecimal.ZERO) == 0) continue;
                arBillIds.add(entry.getKey());
            }
            if (arBillIds.isEmpty()) break block6;
            QFilter settleFilter = new QFilter("mainbillid", "in", arBillIds);
            settleFilter.and(new QFilter("settlerelation", "=", (Object)SettleRelationEnum.ARPREMSETTLE.getValue()));
            if (settle) {
                result = QueryServiceHelper.query((String)"ar_settlerecord", (String)"mainbillid as id", (QFilter[])settleFilter.toArray(), (String)"");
                preSettledPks = ArApHelper.getPks(result);
                for (Long arBillId : arBillIds) {
                    if (preSettledPks.contains(arBillId)) continue;
                    DynamicObject arBill = arBillMap.get(arBillId);
                    int basePrecison = arBill.getInt("basecurrency.amtprecision");
                    EntryWBParam param = new EntryWBParam();
                    param.setForward(true);
                    param.setWbType(EntryWBTypeEnum.SETTLE.getValue());
                    param.setWbAmt(arBill.getBigDecimal("premiumamt"));
                    param.setWbLocalAmt(arBill.getBigDecimal("premiumamt").multiply(arBill.getBigDecimal("exchangerate").setScale(basePrecison, RoundingMode.HALF_UP)));
                }
            } else {
                settleFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
                result = QueryServiceHelper.query((String)"ar_settlerecord", (String)"mainbillid as id", (QFilter[])settleFilter.toArray(), (String)"");
                preSettledPks = ArApHelper.getPks(result);
                for (Long arBillId : arBillIds) {
                    if (!preSettledPks.contains(arBillId)) continue;
                    DynamicObject arBill = arBillMap.get(arBillId);
                    int basePrecison = arBill.getInt("basecurrency.amtprecision");
                    EntryWBParam param = new EntryWBParam();
                    param.setForward(false);
                    param.setWbType(EntryWBTypeEnum.SETTLE.getValue());
                    param.setWbAmt(arBill.getBigDecimal("premiumamt"));
                    param.setWbLocalAmt(arBill.getBigDecimal("premiumamt").multiply(arBill.getBigDecimal("exchangerate").setScale(basePrecison, RoundingMode.HALF_UP)));
                }
            }
        }
    }

    private Map<Long, SettleRecordVO> getSettleRecordGroupMap(List<SettleRecordVO> voList) {
        HashMap<Long, SettleRecordVO> settleRecordGroupMap = new HashMap<Long, SettleRecordVO>(2);
        Map<Long, List<SettleRecordVO>> recordMap = voList.stream().collect(Collectors.groupingBy(record -> record.getMainBillId()));
        for (Map.Entry<Long, List<SettleRecordVO>> entry : recordMap.entrySet()) {
            Long billId = entry.getKey();
            List<SettleRecordVO> value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            if (value.size() == 1) {
                settleRecordGroupMap.put(billId, value.get(0));
            } else {
                String firstRecordJson = SerializationUtils.toJsonString((Object)value.get(0));
                SettleRecordVO wbRecordVO = (SettleRecordVO)SerializationUtils.fromJsonString((String)firstRecordJson, SettleRecordVO.class);
                wbRecordVO.setTotalSettleAmt(BigDecimal.ZERO);
                wbRecordVO.setLocalTotalSettleamt(BigDecimal.ZERO);
                for (SettleRecordVO settleRecordVO : value) {
                    wbRecordVO.setTotalSettleAmt(wbRecordVO.getTotalSettleAmt().add(settleRecordVO.getTotalSettleAmt()));
                    wbRecordVO.setLocalTotalSettleamt(wbRecordVO.getLocalTotalSettleamt().add(settleRecordVO.getLocalTotalSettleamt()));
                }
                settleRecordGroupMap.put(billId, wbRecordVO);
            }
            this.settleRecordSize4MaterialMap.put(billId, value.size());
            this.settleRecordSize4PlanMap.put(billId, value.size());
        }
        return settleRecordGroupMap;
    }

    private List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("org");
        selector.add("billno");
        selector.add("settlestatus");
        selector.add("currency");
        selector.add("billtype");
        selector.add("sourcebillid");
        selector.add("basecurrency");
        selector.add("quotation");
        selector.add("exchangerate");
        selector.add("asstacttype");
        selector.add("istransfer");
        selector.add("asstact");
        selector.add("recamount");
        selector.add("reclocalamt");
        selector.add("unsettleamount");
        selector.add("unsettlelocalamt");
        selector.add("settleamount");
        selector.add("settlelocalamt");
        selector.add("isperiod");
        selector.add("isbaddebt");
        selector.add("e_recamount");
        selector.add("e_reclocalamt");
        selector.add("e_unlockamt");
        selector.add("e_lockedamt");
        selector.add("e_unsettleamt");
        selector.add("e_unsettlelocalamt");
        selector.add("e_settledamt");
        selector.add("e_settledlocalamt");
        selector.add("e_corebilltype");
        selector.add("e_corebillno");
        selector.add("corebillid");
        selector.add("corebillentryid");
        selector.add("planpricetax");
        selector.add("planpricetaxloc");
        selector.add("unplanlockamt");
        selector.add("planlockedamt");
        selector.add("unplansettleamt");
        selector.add("unplansettlelocamt");
        selector.add("plansettledamt");
        selector.add("plansettledlocamt");
        selector.add("e_conbillentity");
        selector.add("e_conbillid");
        selector.add("e_conbillentryid");
        selector.add("e_ispresent");
        selector.add("premiumamt");
        return selector;
    }

    @Override
    protected boolean needWBLock(SettleRecordVO result, SettleSchemeVO scheme, String ... possibleSources) {
        return scheme.isUnSettleByListOP();
    }
}

