/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback.settle;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.arapcommon.enums.EntryWBTypeEnum;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.entry.EntryWBParam;
import kd.fi.arapcommon.writeback.settle.FinApSettleWBService;

public class PreSettleWBService
extends FinApSettleWBService {
    protected Map<Long, SettleRecordVO> settleRecordMap;
    @Deprecated
    protected Set<Long> wbMaterialBillIdSet = new HashSet<Long>(2);
    @Deprecated
    protected Set<Long> wbPlanBillIdSet = new HashSet<Long>(2);
    protected Map<Long, Integer> settleRecordSize4MaterialMap = new HashMap<Long, Integer>(16);
    protected Map<Long, Integer> settleRecordSize4PlanMap = new HashMap<Long, Integer>(16);

    @Override
    public void writeBack(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        this.settleRecordMap = this.getSettleRecordGroupMap(voList);
        super.writeBack(voList, scheme);
    }

    @Override
    protected void wbMaterialEntry(DynamicObject bill, DynamicObject entry, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        long id = bill.getLong("id");
        if (this.settleRecordMap != null && this.settleRecordMap.get(id) != null) {
            Integer settleRecordSize = this.settleRecordSize4MaterialMap.get(id);
            if (settleRecordSize == 1) {
                SettleRecordVO settleRecordVO = this.settleRecordMap.get(id);
                super.wbMaterialEntryByStrategy(bill, settleRecordVO, scheme, isWBLock);
            } else {
                settleRecordSize = settleRecordSize - 1;
                this.settleRecordSize4MaterialMap.put(id, settleRecordSize);
            }
        } else {
            super.wbMaterialEntryByStrategy(bill, result, scheme, isWBLock);
        }
    }

    @Override
    protected void wbPlanEntry(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        long id = bill.getLong("id");
        EntryWBParam param = new EntryWBParam();
        param.setNeedWBLock(isWBLock);
        param.setForward(scheme.isSettle());
        param.setWbType(EntryWBTypeEnum.SETTLE.getValue());
        param.setWbAmt(result.getTotalSettleAmt());
        param.setWbLocalAmt(result.getLocalTotalSettleamt());
        if (this.settleRecordMap != null && this.settleRecordMap.get(id) != null) {
            Integer settleRecordSize = this.settleRecordSize4PlanMap.get(id);
            if (settleRecordSize == 1) {
                SettleRecordVO settleRecordVO = this.settleRecordMap.get(id);
                param.setWbAmt(settleRecordVO.getTotalSettleAmt());
                param.setWbLocalAmt(settleRecordVO.getLocalTotalSettleamt());
                this.prePlanWBService.execute(bill, param);
            } else {
                settleRecordSize = settleRecordSize - 1;
                this.settleRecordSize4PlanMap.put(id, settleRecordSize);
            }
        } else {
            this.prePlanWBService.execute(bill, param);
        }
    }

    @Override
    protected boolean needWBLock(SettleRecordVO result, SettleSchemeVO scheme, String ... possibleSources) {
        return scheme.isUnSettleByListOP();
    }

    private Map<Long, SettleRecordVO> getSettleRecordGroupMap(List<SettleRecordVO> voList) {
        HashMap<Long, SettleRecordVO> settleRecordGroupMap = new HashMap<Long, SettleRecordVO>(voList.size());
        Map<Long, List<SettleRecordVO>> recordMap = voList.stream().collect(Collectors.groupingBy(record -> record.getMainBillId()));
        for (Map.Entry<Long, List<SettleRecordVO>> entry : recordMap.entrySet()) {
            Long billId = entry.getKey();
            List<SettleRecordVO> value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            if (value.size() == 1) {
                settleRecordGroupMap.put(billId, value.get(0));
            } else {
                String firstRecordJson = SerializationUtils.toJsonString((Object)value.get(0));
                SettleRecordVO wbRecordVO = (SettleRecordVO)SerializationUtils.fromJsonString((String)firstRecordJson, SettleRecordVO.class);
                wbRecordVO.setTotalSettleAmt(BigDecimal.ZERO);
                wbRecordVO.setLocalTotalSettleamt(BigDecimal.ZERO);
                for (SettleRecordVO settleRecordVO : value) {
                    wbRecordVO.setTotalSettleAmt(wbRecordVO.getTotalSettleAmt().add(settleRecordVO.getTotalSettleAmt()));
                    wbRecordVO.setLocalTotalSettleamt(wbRecordVO.getLocalTotalSettleamt().add(settleRecordVO.getLocalTotalSettleamt()));
                }
                settleRecordGroupMap.put(billId, wbRecordVO);
            }
            this.settleRecordSize4MaterialMap.put(billId, value.size());
            this.settleRecordSize4PlanMap.put(billId, value.size());
        }
        return settleRecordGroupMap;
    }
}

