/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.settle.AbstractSettleWBService;

public class RecBillSettleWBService
extends AbstractSettleWBService {
    private static final Log logger = LogFactory.getLog(RecBillSettleWBService.class);
    private static final String REC_ENTITY = "cas_recbill";
    private static final String RECEIVED_ENTITY = "ar_receivedbill";

    @Override
    public void writeBack(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        logger.info("RecBillSettleWBService writeback as main start");
        if (ObjectUtils.isEmpty(voList) || scheme == null) {
            return;
        }
        List<SettleRecordVO> receivedSRList = voList.stream().filter(sr -> RECEIVED_ENTITY.equals(sr.getBillEntity())).collect(Collectors.toList());
        DynamicObject[] receivedBills = new DynamicObject[]{};
        if (!ObjectUtils.isEmpty(receivedSRList)) {
            Set billIds = receivedSRList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
            receivedBills = BusinessDataServiceHelper.load((String)RECEIVED_ENTITY, (String)String.join((CharSequence)",", this.getReceivedWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        }
        this.writeBackReceived(receivedSRList, receivedBills, scheme);
        List<SettleRecordVO> recSRList = voList.stream().filter(sr -> REC_ENTITY.equals(sr.getBillEntity())).collect(Collectors.toList());
        DynamicObject[] bills = new DynamicObject[]{};
        if (!ObjectUtils.isEmpty(recSRList)) {
            Set billIds = recSRList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
            bills = BusinessDataServiceHelper.load((String)REC_ENTITY, (String)String.join((CharSequence)",", this.getRecWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        }
        this.writeBackRec(recSRList, bills, scheme);
        logger.info("RecBillSettleWBService writeback as main end");
    }

    @Override
    public void writeBackAsst(List<SettleRecordEntryVO> entryVOList, SettleSchemeVO scheme) {
        logger.info("RecBillSettleWBService writeback as asst start");
        if (ObjectUtils.isEmpty(entryVOList) || scheme == null) {
            return;
        }
        List<SettleRecordEntryVO> receivedSREntryList = entryVOList.stream().filter(sre -> RECEIVED_ENTITY.equals(sre.getBillEntity())).collect(Collectors.toList());
        List<SettleRecordVO> receivedSRList = this.convert2SRList(receivedSREntryList);
        DynamicObject[] receivedBills = new DynamicObject[]{};
        if (!ObjectUtils.isEmpty(receivedSRList)) {
            Set billIds = receivedSRList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
            receivedBills = BusinessDataServiceHelper.load((String)RECEIVED_ENTITY, (String)String.join((CharSequence)",", this.getReceivedWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        }
        receivedSRList = this.writeBackReceived(receivedSRList, receivedBills, scheme);
        int receivedSRCount = 0;
        for (SettleRecordEntryVO settleRecordEntryVO : entryVOList) {
            if (!RECEIVED_ENTITY.equals(settleRecordEntryVO.getBillEntity())) continue;
            settleRecordEntryVO.setLocalSettleAmt(receivedSRList.get(receivedSRCount).getLocalTotalSettleamt());
            ++receivedSRCount;
        }
        List<SettleRecordEntryVO> recSREntryList = entryVOList.stream().filter(sre -> REC_ENTITY.equals(sre.getBillEntity())).collect(Collectors.toList());
        List<SettleRecordVO> recSRList = this.convert2SRList(recSREntryList);
        DynamicObject[] bills = new DynamicObject[]{};
        if (!ObjectUtils.isEmpty(recSRList)) {
            Set billIds = recSRList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
            bills = BusinessDataServiceHelper.load((String)REC_ENTITY, (String)String.join((CharSequence)",", this.getRecWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        }
        recSRList = this.writeBackRec(recSRList, bills, scheme);
        int recSRCount = 0;
        for (SettleRecordEntryVO settleRecordEntryVO : entryVOList) {
            if (!REC_ENTITY.equals(settleRecordEntryVO.getBillEntity())) continue;
            settleRecordEntryVO.setLocalSettleAmt(recSRList.get(recSRCount).getLocalTotalSettleamt());
            ++recSRCount;
        }
        logger.info("RecBillSettleWBService writeback as asst end");
    }

    protected List<SettleRecordVO> writeBackRec(List<SettleRecordVO> voList, DynamicObject[] bills, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(voList) || ObjectUtils.isEmpty((Object[])bills)) {
            return voList;
        }
        HashMap<Long, DynamicObject> billEntryMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> recBillMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject bill : bills) {
            String billstatus = bill.getString("billstatus");
            String billno = bill.getString("billno");
            if (scheme.isUnSettleByWriteOff() && !"D".equals(billstatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u6536\u6b3e\u5355\uff1a%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u6536\u6b3e\u3002", (String)"RecBillSettleWBService_0", (String)"fi-arapcommon", (Object[])new Object[]{billno}));
            }
            recBillMap.put(bill.getLong("id"), bill);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : entrys) {
                billEntryMap.put(dynamicObject.getLong("id"), dynamicObject);
            }
        }
        boolean isExistHeadProp = this.isExistHeadProp(bills[0]);
        HashSet<Long> needDeleteBOTPIds = new HashSet<Long>(64);
        HashSet<Long> needDeleteBOTPEntryIds = new HashSet<Long>(64);
        HashSet<Long> sourceIds = new HashSet<Long>(64);
        boolean isSettle = scheme.isSettle();
        for (SettleRecordVO result : voList) {
            String autoSettleType;
            String settleType;
            boolean isUnSettleDisposeAll;
            long entryId = result.getMainBillEntryId();
            BigDecimal settleAmt = result.getTotalSettleAmt();
            BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
                localSettleAmt = localSettleAmt.negate();
            }
            if (isExistHeadProp) {
                DynamicObject bill = (DynamicObject)recBillMap.get(result.getMainBillId());
                this.wbHead(bill, settleAmt, localSettleAmt);
            }
            DynamicObject entry = (DynamicObject)billEntryMap.get(entryId);
            boolean needWBLock = this.needWBLock(result, scheme, "ar_finarbill");
            if (needWBLock) {
                entry.set("e_lockamt", (Object)entry.getBigDecimal("e_lockamt").add(settleAmt));
                entry.set("e_unlockamt", (Object)entry.getBigDecimal("e_unlockamt").subtract(settleAmt));
            }
            entry.set("e_settledamt", (Object)entry.getBigDecimal("e_settledamt").add(settleAmt));
            entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_unsettledamt").subtract(settleAmt));
            boolean isSettleDisposeAll = entry.getBigDecimal("e_unsettledamt").compareTo(BigDecimal.ZERO) == 0;
            boolean bl = isUnSettleDisposeAll = entry.getBigDecimal("e_settledamt").compareTo(BigDecimal.ZERO) == 0;
            if (isSettleDisposeAll) {
                result.setLocalTotalSettleamt(entry.getBigDecimal("e_receivablelocamt").subtract(entry.getBigDecimal("e_settledlocalamt")));
                entry.set("e_settledlocalamt", (Object)entry.getBigDecimal("e_receivablelocamt"));
                entry.set("e_unsettledlocalamt", (Object)BigDecimal.ZERO);
            } else if (isUnSettleDisposeAll) {
                entry.set("e_settledlocalamt", (Object)BigDecimal.ZERO);
                entry.set("e_unsettledlocalamt", (Object)entry.getBigDecimal("e_receivablelocamt"));
            } else {
                entry.set("e_settledlocalamt", (Object)entry.getBigDecimal("e_settledlocalamt").add(localSettleAmt));
                entry.set("e_unsettledlocalamt", (Object)entry.getBigDecimal("e_unsettledlocalamt").subtract(localSettleAmt));
            }
            if (!this.isNeedDeleteBOTP(isSettle, settleType = result.getSettleType(), autoSettleType = result.getAutoSettleType(), scheme)) continue;
            Long billId = result.getMainBillId();
            needDeleteBOTPIds.add(billId);
            needDeleteBOTPEntryIds.add(entryId);
            sourceIds.add(entry.getLong("e_sourcebillid"));
        }
        if (isExistHeadProp) {
            this.wbHeadSettleStatus(bills);
        }
        logger.info("RecBillSettleWBService writeback ICallOrderConInvoker start");
        Settle4ScmcHelper.newWriteBackPurAndCon(voList, bills, scheme, null);
        logger.info("RecBillSettleWBService writeback ICallOrderConInvoker end");
        SaveServiceHelper.save((DynamicObject[])bills);
        if (needDeleteBOTPIds.size() > 0) {
            Map<Long, List<Long>> srcBillMap = BOTPHelper.loadNearUpBillIds(REC_ENTITY, "entry", needDeleteBOTPIds.toArray(new Long[0]), needDeleteBOTPEntryIds.toArray(new Long[0]), "ar_finarbill");
            Set<Map.Entry<Long, List<Long>>> entries = srcBillMap.entrySet();
            for (Map.Entry<Long, List<Long>> entry : entries) {
                Long billId = entry.getKey();
                HashSet srcBillIds = new HashSet(entry.getValue());
                for (Long srcBillId : srcBillIds) {
                    if (!sourceIds.contains(srcBillId)) continue;
                    BOTPHelper.deleteRelation(REC_ENTITY, billId, srcBillId);
                }
            }
        }
        return voList;
    }

    private void wbHead(DynamicObject bill, BigDecimal settleAmt, BigDecimal localSettleAmt) {
        boolean isUnSettleDisposeAll;
        bill.set("unsettleamount", (Object)bill.getBigDecimal("unsettleamount").subtract(settleAmt));
        bill.set("settleamount", (Object)bill.getBigDecimal("settleamount").add(settleAmt));
        boolean isSettleDisposeAll = bill.getBigDecimal("unsettleamount").compareTo(BigDecimal.ZERO) == 0;
        boolean bl = isUnSettleDisposeAll = bill.getBigDecimal("settleamount").compareTo(BigDecimal.ZERO) == 0;
        if (isSettleDisposeAll) {
            bill.set("unsettleamountbase", (Object)BigDecimal.ZERO);
            bill.set("settleamountbase", (Object)bill.getBigDecimal("localamt"));
        } else if (isUnSettleDisposeAll) {
            bill.set("unsettleamountbase", (Object)bill.getBigDecimal("localamt"));
            bill.set("settleamountbase", (Object)BigDecimal.ZERO);
        } else {
            bill.set("unsettleamountbase", (Object)bill.getBigDecimal("unsettleamountbase").subtract(localSettleAmt));
            bill.set("settleamountbase", (Object)bill.getBigDecimal("settleamountbase").add(localSettleAmt));
        }
    }

    private void wbHeadSettleStatus(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            String settleStatus = "partsettle";
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            boolean settled = true;
            for (DynamicObject entry : entries) {
                BigDecimal unsettleAmt = entry.getBigDecimal("e_unsettledamt");
                if (unsettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                settled = false;
                break;
            }
            if (settled) {
                settleStatus = "settled";
            }
            boolean unSettle = true;
            for (DynamicObject entry : entries) {
                BigDecimal settledAmt = entry.getBigDecimal("e_settledamt");
                if (settledAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                unSettle = false;
                break;
            }
            if (unSettle) {
                settleStatus = "unsettle";
            }
            bill.set("settlestatus", (Object)settleStatus);
        }
    }

    @Deprecated
    protected List<SettleRecordVO> writeBackRec(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(voList)) {
            return voList;
        }
        Set billIds = voList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)REC_ENTITY, (String)String.join((CharSequence)",", this.getRecWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        return this.writeBackRec(voList, bills, scheme);
    }

    protected List<SettleRecordVO> writeBackReceived(List<SettleRecordVO> voList, DynamicObject[] bills, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(voList) || ObjectUtils.isEmpty((Object[])bills)) {
            return voList;
        }
        HashSet<Long> billIds = new HashSet<Long>(8);
        HashMap<Long, DynamicObject[]> billEntryMap = new HashMap<Long, DynamicObject[]>(64);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject[] entry : entrys) {
                billEntryMap.put(entry.getLong("id"), entry);
            }
            billIds.add(bill.getLong("id"));
        }
        String selectors = CommonSettleServiceHelper.getSettleRecordSelector();
        QFilter filterForMain = new QFilter("mainbillid", "in", billIds);
        DynamicObject[] resultForMain = BusinessDataServiceHelper.load((String)"ar_settlerecord", (String)selectors, (QFilter[])filterForMain.toArray());
        QFilter filterForAsst = new QFilter("entry.billid", "in", billIds);
        DynamicObject[] resultForAsst = SettleRecordQueryHelper.getSettleRecords("ar_settlerecord", selectors, RECEIVED_ENTITY, new Object[]{billIds}, filterForAsst);
        HashMap<Long, BigDecimal> billEntryToLocalAmtMap = new HashMap<Long, BigDecimal>();
        for (DynamicObject result : resultForMain) {
            Long entryId = result.getLong("mainbillentryid");
            BigDecimal localSettleAmt = result.getBigDecimal("localtotalsettleamt");
            billEntryToLocalAmtMap.merge(entryId, localSettleAmt, BigDecimal::add);
        }
        for (DynamicObject result : resultForAsst) {
            DynamicObjectCollection entries = result.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("billentryid");
                BigDecimal localSettleAmt = entry.getBigDecimal("localsettleamt");
                billEntryToLocalAmtMap.merge(entryId, localSettleAmt, BigDecimal::add);
            }
        }
        boolean isSettle = scheme.isSettle();
        for (SettleRecordVO result : voList) {
            DynamicObject entry;
            long entryId = result.getMainBillEntryId();
            BigDecimal settleAmt = result.getTotalSettleAmt();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
            }
            entry = (DynamicObject)billEntryMap.get(entryId);
            entry.set("e_settledamt", (Object)entry.getBigDecimal("e_settledamt").add(settleAmt));
            entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_unsettledamt").subtract(settleAmt));
            if (entry.getBigDecimal("e_unsettledamt").compareTo(BigDecimal.ZERO) == 0) {
                if (billEntryToLocalAmtMap.get(entryId) != null) {
                    result.setLocalTotalSettleamt(entry.getBigDecimal("e_localamount").subtract((BigDecimal)billEntryToLocalAmtMap.get(entryId)));
                } else {
                    result.setLocalTotalSettleamt(entry.getBigDecimal("e_localamount"));
                }
            } else {
                billEntryToLocalAmtMap.merge(entryId, result.getLocalTotalSettleamt(), BigDecimal::add);
            }
            entry.set("e_modifier", (Object)RequestContext.get().getCurrUserId());
            entry.set("e_modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])bills);
        return voList;
    }

    @Deprecated
    private boolean isExistSettleLocalProp(DynamicObject bill) {
        if (bill == null) {
            return false;
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
        DynamicObject entry = (DynamicObject)entrys.get(0);
        return EntityMetadataUtils.isExistProperty(entry, "e_settledlocalamt") && EntityMetadataUtils.isExistProperty(entry, "e_unsettledlocalamt");
    }

    private boolean isExistHeadProp(DynamicObject bill) {
        if (bill == null) {
            return false;
        }
        return EntityMetadataUtils.isExistProperty(bill, "settlestatus");
    }

    private boolean isNeedDeleteBOTP(boolean isSettle, String settleType, String autoSettleType, SettleSchemeVO scheme) {
        return !isSettle && scheme.isUnSettleByListOP() && SettleTypeEnum.AUTO.getValue().equals(settleType) && ("1".equals(autoSettleType) || "0".equals(autoSettleType));
    }

    protected List<String> getRecWBSelector() {
        ArrayList<String> selector = new ArrayList<String>(20);
        selector.add("e_receivablelocamt");
        selector.add("e_lockamt");
        selector.add("e_unlockamt");
        selector.add("e_settledamt");
        selector.add("e_settledlocalamt");
        selector.add("e_unsettledamt");
        selector.add("e_unsettledlocalamt");
        selector.add("e_sourcebillid");
        selector.add("receivingtype");
        selector.add("confirmlogo");
        selector.add("e_corebilltype");
        selector.add("e_corebillid");
        selector.add("e_corebillentryid");
        selector.add("payer");
        selector.add("e_settleorg");
        selector.add("currency");
        selector.add("conbillid");
        selector.add("conbillentryid");
        selector.add("sourcebilltype");
        selector.add("billstatus");
        selector.add("settlestatus");
        selector.add("unsettleamount");
        selector.add("unsettleamountbase");
        selector.add("settleamount");
        selector.add("settleamountbase");
        selector.add("localamt");
        selector.add("e_receivingtype");
        selector.add("billno");
        return selector;
    }

    protected List<String> getReceivedWBSelector() {
        ArrayList<String> selector = new ArrayList<String>(8);
        selector.add("e_settledamt");
        selector.add("e_unsettledamt");
        selector.add("e_localamount");
        selector.add("e_modifier");
        selector.add("e_modifytime");
        selector.add("rectype");
        selector.add("e_corebilltype");
        selector.add("billstatus");
        return selector;
    }
}

