/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.webapi.chkcheck.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.webapi.chkcheck.model.QueryChkCheckReportParam;
import kd.fi.bcm.webapi.chkcheck.model.QueryChkCheckReportResult;
import org.apache.commons.collections.CollectionUtils;

public class ChkCheckAPIService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ChkCheckAPIService.class);
    public static final String QUERY_FIELDS = "chkresulttype,chkformula.number,chkformula.name,chkformula.allowamount,chkformula.chkeffecttype,leftresult,rightresult,calcresultexpr,year.name,period.name,currency.name,org.number,org.name,chineseformula";

    public CustomApiResult<List<QueryChkCheckReportResult>> queryChkCheckReport(QueryChkCheckReportParam param) {
        try {
            DynamicObjectCollection query = this.getDynamicObjects(param);
            if (!query.isEmpty()) {
                List<QueryChkCheckReportResult> resultList = this.buildResultsByDyns(query);
                return CustomApiResult.success(resultList);
            }
        }
        catch (Exception e) {
            log.error("queryChkCheckReport API execute fail: " + ThrowableHelper.toString((Exception)e));
            return CustomApiResult.fail((String)"999", (String)ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10));
        }
        return CustomApiResult.success(Collections.emptyList());
    }

    private DynamicObjectCollection getDynamicObjects(QueryChkCheckReportParam param) {
        Long modelId = MemberReader.findModelIdByShowNum((String)param.getModelNum());
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(new QFilter("scenario.number", "=", (Object)param.getSceneNum()));
        qf.and(new QFilter("year.number", "=", (Object)param.getYearNum()));
        qf.and(new QFilter("period.number", "=", (Object)param.getPeriodNum()));
        qf.and(new QFilter("org.number", "=", (Object)param.getOrgNum()));
        QFilter qf1 = new QFilter("chkresulttype", "=", (Object)String.valueOf(ChkResultTypeEnum.UNPASS.getIndex()));
        if (CollectionUtils.isNotEmpty(param.getChkFormulaNums())) {
            qf1.and(new QFilter("chkformula.number", "in", param.getChkFormulaNums()));
        }
        if (param.isQueryNotEffectReport()) {
            qf1.or(new QFilter("chkresulttype", "=", (Object)String.valueOf(ChkResultTypeEnum.UNPASSBUTNOTEFFECT.getIndex())));
        }
        qf.and(qf1);
        return QueryServiceHelper.query((String)"bcm_chkreport", (String)QUERY_FIELDS, (QFilter[])qf.toArray());
    }

    private List<QueryChkCheckReportResult> buildResultsByDyns(DynamicObjectCollection query) {
        ArrayList<QueryChkCheckReportResult> resultList = new ArrayList<QueryChkCheckReportResult>(query.size());
        for (DynamicObject dyn : query) {
            QueryChkCheckReportResult result = new QueryChkCheckReportResult();
            result.setChkResultType(dyn.getString("chkresulttype"));
            result.setChkFormulaNum(dyn.getString("chkformula.number"));
            result.setChkFormulaName(dyn.getString("chkformula.name"));
            result.setChkFormulaEffect(dyn.getString("chkformula.chkeffecttype"));
            result.setLeftResult(dyn.getString("leftresult"));
            result.setRightResult(dyn.getString("rightresult"));
            result.setCalcResult(dyn.getString("calcresultexpr"));
            result.setAllowAmount(dyn.getBigDecimal("chkformula.allowamount"));
            result.setYearName(dyn.getString("year.name"));
            result.setPeriodName(dyn.getString("period.name"));
            result.setCcyName(dyn.getString("currency.name"));
            result.setOrgNum(dyn.getString("org.number"));
            result.setOrgName(dyn.getString("org.name"));
            result.setChineseFormula(dyn.getString("chineseformula"));
            resultList.add(result);
        }
        return resultList;
    }
}

