/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.webapi.dimension.controller;

import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.serviceHelper.ModelPermHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.webapi.dimension.model.BizChangeRecord;
import kd.fi.bcm.webapi.dimension.model.Consolidation;
import kd.fi.bcm.webapi.dimension.model.NameChangeRecord;
import kd.fi.bcm.webapi.dimension.model.OrgBaseResult;
import kd.fi.bcm.webapi.dimension.model.OrgQueryParam;
import kd.fi.bcm.webapi.dimension.model.OrgQueryResult;
import kd.fi.bcm.webapi.dimension.model.QueryOrgByPeriodParam;
import kd.fi.bcm.webapi.dimension.model.QueryOrgByPeriodResult;
import org.apache.commons.lang3.StringUtils;

@ApiController(value="dimension", desc="\u7ef4\u5ea6\u7ba1\u7406")
@ApiMapping(value="dimension")
public class DimensionController {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DimensionController.class);

    @ApiPostMapping(value="/getOrgInfo", desc="\u67e5\u8be2\u7ec4\u7ec7\u67b6\u6784\u4fe1\u606f")
    public CustomApiResult<List<OrgQueryResult>> getOrgInfo(@ApiParam(value="\u7ec4\u7ec7\u67b6\u6784\u4fe1\u606f\u67e5\u8be2\u53c2\u6570", required=true) @ApiParam(value="\u7ec4\u7ec7\u67b6\u6784\u4fe1\u606f\u67e5\u8be2\u53c2\u6570", required=true) OrgQueryParam param) {
        log.startWatch();
        log.info("member query api start,params:" + param);
        try {
            DynamicObject[] orgList;
            Optional<String> validate = this.validateParam(param);
            if (validate.isPresent()) {
                return CustomApiResult.fail((String)"001", (String)validate.get());
            }
            Multimap mergeStruct = MemberServiceHelper.getAllMergeStructInfo((String)param.getModelNum(), (String)param.getSceneNum());
            if (StringUtils.isNotEmpty((CharSequence)param.getModifyTime())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date modifyTime = dateFormat.parse(param.getModifyTime());
                Set numbers = mergeStruct.values().stream().filter(m -> m.getDate("modifytime").after(modifyTime)).map(m -> m.getString("orgnumber")).collect(Collectors.toSet());
                orgList = MemberServiceHelper.getOrgInfoByScheme((String)param.getModelNum(), (String)param.getSchemeNum(), (Date)modifyTime, numbers);
            } else {
                orgList = MemberServiceHelper.getOrgInfoByScheme((String)param.getModelNum(), (String)param.getSchemeNum(), null, null);
            }
            if (orgList == null || orgList.length == 0) {
                return CustomApiResult.fail((String)"002", (String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u7ec4\u7ec7\u3002", (String)"DimensionController_1", (String)"fi-bcm-webapi", (Object[])new Object[0]));
            }
            ArrayList<OrgQueryResult> resultList = new ArrayList<OrgQueryResult>(orgList.length);
            for (DynamicObject org : orgList) {
                OrgQueryResult result = new OrgQueryResult();
                this.initBaseResult(org, result);
                DynamicObjectCollection bizRecords = org.getDynamicObjectCollection("bizchangerds");
                ArrayList<BizChangeRecord> bizChangeRecords = new ArrayList<BizChangeRecord>(bizRecords.size());
                result.setBizChangeRecords(bizChangeRecords);
                for (DynamicObject biz : bizRecords) {
                    bizChangeRecords.add(new BizChangeRecord(biz.getString("changetype"), this.formatNull(biz.getString("bizeffdate")), this.formatNull(biz.getString("bizexpdate")), biz.getLong("bizmodifier.id"), this.formatNull(biz.getString("bizmodifytime"))));
                }
                DynamicObjectCollection nameRecords = org.getDynamicObjectCollection("namechangerds");
                ArrayList<NameChangeRecord> nameChangeRecords = new ArrayList<NameChangeRecord>(nameRecords.size());
                result.setNameChangeRecords(nameChangeRecords);
                for (DynamicObject name : nameRecords) {
                    nameChangeRecords.add(new NameChangeRecord(name.getString("namerds"), name.getString("simplenamerds"), this.formatNull(name.getString("nameeffdate")), this.formatNull(name.getString("nameexpdate")), name.getLong("namemodifier.id"), this.formatNull(name.getString("namemodifytime"))));
                }
                ArrayList<Consolidation> consolidationList = new ArrayList<Consolidation>(16);
                result.setConsolidations(consolidationList);
                mergeStruct.get((Object)(org.getString("parent.number") + "|" + org.getString("number"))).forEach(m -> consolidationList.add(new Consolidation(m.getString("orgpnumber"), m.getString("orgnumber"), m.getString("year.number"), m.getString("period.number"), this.formatVal(m.getBoolean("ismerge")), this.formatNull(m.getString("modifytime")))));
                resultList.add(result);
            }
            log.infoEnd("member query api end,member size:" + orgList.length);
            return CustomApiResult.success(resultList);
        }
        catch (Exception ex) {
            log.error("member query api error." + ThrowableHelper.toString((Exception)ex));
            return CustomApiResult.fail((String)"003", (String)ex.getMessage());
        }
    }

    private void initBaseResult(DynamicObject org, OrgBaseResult result) {
        result.setId(org.getLong("id"));
        result.setNumber(org.getString("number"));
        result.setName(org.getString("name"));
        result.setSimpleName(org.getString("simplename"));
        result.setLongNumber(org.getString("longnumber"));
        result.setShowNumber(org.getString("shownumber"));
        result.setOrgCode(org.getString("orgcode"));
        result.setParentID(org.getLong("parent.id"));
        result.setParentNumber(org.getString("parent.number"));
        result.setParentName(org.getString("parent.name"));
        result.setCreator(org.getLong("creator.id"));
        result.setCreateTime(this.formatNull(org.getString("createtime")));
        result.setModifier(org.getLong("modifier.id"));
        result.setModifyTime(this.formatNull(org.getString("modifytime")));
        result.setEnable(this.formatVal(org.getBoolean("enable")));
        result.setStatus(org.getString("status"));
        result.setMasterId(org.getLong("masterid"));
        result.setStorageType(org.getString("storagetype"));
        result.setAggoprt(org.getString("aggoprt"));
        result.setIsIndependentOrg(this.formatVal(org.getBoolean("isindependentorg")));
        result.setCtrlOrgId(org.getLong("ctrlorg.id"));
        result.setCurrencyCode(org.getString("currency.number"));
        result.setCurrencyName(org.getString("currency.name"));
        result.setIsInnerOrg(this.formatVal(org.getBoolean("isinnerorg")));
        DynamicObject entityPart = org.getDynamicObject("entitypart");
        if (entityPart != null) {
            String accountType = entityPart.getString("accounttype.number");
            result.setAccountType(accountType == null ? "" : accountType);
            result.setIsOuterOrg(this.formatVal(entityPart.getBoolean("isouterorg")));
        } else {
            result.setAccountType("");
            result.setIsOuterOrg("0");
        }
        result.setIsClearOrg(this.formatVal(org.getBoolean("isclearorg")));
        result.setIsLeaf(this.formatVal(org.getBoolean("isleaf")));
        result.setDescription(org.getString("description"));
    }

    private String formatVal(Boolean val) {
        if (val == null || val == Boolean.FALSE) {
            return "0";
        }
        return "1";
    }

    private String formatNull(String str) {
        return str == null ? "" : str;
    }

    private Optional<String> validateParam(OrgQueryParam param) {
        if (StringUtils.isEmpty((CharSequence)param.getModelNum())) {
            return Optional.of("modelNum is required.");
        }
        long modelId = MemberReader.findModelIdByNum((String)param.getModelNum());
        if (modelId == 0L) {
            return Optional.of("modelNum is invalid.");
        }
        if (!ModelPermHelper.hasModelPerm((long)modelId)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u4f53\u7cfb\u4f7f\u7528\u6743\u9650\u3002", (String)"AbstractMsService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)param.getSceneNum())) {
            return Optional.of("sceneNum is required.");
        }
        if (MemberReader.findScenaMemberByNum((String)param.getModelNum(), (String)param.getSceneNum()) == IDNumberTreeNode.NotFoundTreeNode) {
            return Optional.of("sceneNum is invalid.");
        }
        if (StringUtils.isEmpty((CharSequence)param.getSchemeNum())) {
            return Optional.of("schemeNum is required.");
        }
        QFilter filter = new QFilter("model.number", "=", (Object)param.getModelNum());
        filter.and(new QFilter("number", "=", (Object)param.getSchemeNum()));
        if (!QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])new QFilter[]{filter})) {
            return Optional.of("schemeNum is invalid.");
        }
        return Optional.empty();
    }

    @ApiPostMapping(value="/getOrgInfoByPeriod", desc="\u6839\u636e\u671f\u95f4\u67e5\u8be2\u6709\u6548\u7ec4\u7ec7\u67b6\u6784\u4fe1\u606f")
    public CustomApiResult<List<QueryOrgByPeriodResult>> getOrgInfoByPeriod(@ApiParam(value="\u7ec4\u7ec7\u67b6\u6784\u4fe1\u606f\u67e5\u8be2\u53c2\u6570", required=true) @ApiParam(value="\u7ec4\u7ec7\u67b6\u6784\u4fe1\u606f\u67e5\u8be2\u53c2\u6570", required=true) QueryOrgByPeriodParam param) {
        log.startWatch();
        log.info("member query by period api start,params:" + param);
        try {
            Optional<String> validate = this.validatePeriodParam(param);
            if (validate.isPresent()) {
                return CustomApiResult.fail((String)"001", (String)validate.get());
            }
            DynamicObject[] dynamicObjects = MemberServiceHelper.getOrgInfoByScheme((String)param.getModelNum(), (String)param.getSchemeNum(), null, null);
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return CustomApiResult.fail((String)"002", (String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u7ec4\u7ec7\u3002", (String)"DimensionController_1", (String)"fi-bcm-webapi", (Object[])new Object[0]));
            }
            ArrayList<DynamicObject> orgList = new ArrayList<DynamicObject>(Arrays.asList(dynamicObjects));
            long modelId = MemberReader.findModelIdByNum((String)param.getModelNum());
            long sceneId = MemberReader.findScenaMemberByNum((String)param.getModelNum(), (String)param.getSceneNum()).getId();
            long yearId = MemberReader.findFyMemberByNum((String)param.getModelNum(), (String)param.getYear()).getId();
            long periodId = MemberReader.findPeriodMemberByNum((String)param.getModelNum(), (String)param.getPeriod()).getId();
            FilterOrgStructParam versionParam = new FilterOrgStructParam(modelId, sceneId, yearId, periodId);
            EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)versionParam, orgList);
            if (orgList.size() == 0) {
                return CustomApiResult.fail((String)"002", (String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u7ec4\u7ec7\u3002", (String)"DimensionController_1", (String)"fi-bcm-webapi", (Object[])new Object[0]));
            }
            Table mergeStruct = InvestServiceHelper.getMergeStructInfoSetting((Long)modelId, (Long)sceneId, (Long)yearId, (Long)periodId);
            ArrayList<QueryOrgByPeriodResult> resultList = new ArrayList<QueryOrgByPeriodResult>(orgList.size());
            for (DynamicObject org : orgList) {
                QueryOrgByPeriodResult result = new QueryOrgByPeriodResult();
                this.initBaseResult(org, result);
                Boolean isMerge = (Boolean)mergeStruct.get((Object)org.getString("parent.number"), (Object)org.getString("number"));
                result.setIsMerge(isMerge == null || isMerge == Boolean.TRUE ? "1" : "0");
                resultList.add(result);
            }
            log.infoEnd("member query by period api end,member size:" + orgList.size());
            return CustomApiResult.success(resultList);
        }
        catch (Exception ex) {
            log.error("member query by period api fail." + ThrowableHelper.toString((Exception)ex));
            return CustomApiResult.fail((String)"003", (String)ThrowableHelper.toString((Exception)ex));
        }
    }

    private Optional<String> validatePeriodParam(QueryOrgByPeriodParam param) {
        if (StringUtils.isEmpty((CharSequence)param.getModelNum())) {
            return Optional.of("modelNum is required.");
        }
        long modelId = MemberReader.findModelIdByNum((String)param.getModelNum());
        if (modelId == 0L) {
            return Optional.of("modelNum is invalid.");
        }
        if (!ModelPermHelper.hasModelPerm((long)modelId)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u4f53\u7cfb\u4f7f\u7528\u6743\u9650\u3002", (String)"AbstractMsService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)param.getSceneNum())) {
            return Optional.of("sceneNum is required.");
        }
        if (MemberReader.findScenaMemberByNum((String)param.getModelNum(), (String)param.getSceneNum()) == IDNumberTreeNode.NotFoundTreeNode) {
            return Optional.of("sceneNum is invalid.");
        }
        if (StringUtils.isEmpty((CharSequence)param.getSchemeNum())) {
            return Optional.of("schemeNum is required.");
        }
        QFilter filter = new QFilter("model.number", "=", (Object)param.getModelNum());
        filter.and(new QFilter("number", "=", (Object)param.getSchemeNum()));
        if (!QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])new QFilter[]{filter})) {
            return Optional.of("schemeNum is invalid.");
        }
        if (StringUtils.isEmpty((CharSequence)param.getYear())) {
            return Optional.of("year is required.");
        }
        if (MemberReader.findFyMemberByNum((String)param.getModelNum(), (String)param.getYear()) == IDNumberTreeNode.NotFoundTreeNode) {
            return Optional.of("year is invalid.");
        }
        if (StringUtils.isEmpty((CharSequence)param.getPeriod())) {
            return Optional.of("period is required.");
        }
        if (MemberReader.findPeriodMemberByNum((String)param.getModelNum(), (String)param.getPeriod()) == IDNumberTreeNode.NotFoundTreeNode) {
            return Optional.of("period is invalid.");
        }
        return Optional.empty();
    }
}

