/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.webapi.dimension.controller;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.fi.bcm.business.dimension.api.ApiResultDTO;
import kd.fi.bcm.business.dimension.api.QueryOlapDataDTO;
import kd.fi.bcm.business.olap.OlapDataQueryHelper;
import kd.fi.bcm.business.serviceHelper.ModelPermHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.webapi.dimension.model.QueryOlapDataParam;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

@ApiController(value="dimension", desc="\u7ef4\u5ea6\u7ba1\u7406")
@ApiMapping(value="olap")
public class QueryOlapController {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, QueryOlapController.class);

    @ApiPostMapping(value="/queryOlapDatas", desc="\u67e5\u8be2\u591a\u7ef4\u6570\u636e")
    public CustomApiResult<Object> queryOlapDatas(@ApiParam(value="\u4f53\u7cfb\u7f16\u7801", required=true, example="CUBElhg2022011733378444001057792") @ApiParam(value="\u4f53\u7cfb\u7f16\u7801", required=true, example="CUBElhg2022011733378444001057792") String modelNum, @ApiParam(value="\u8fc7\u6ee4\u6761\u4ef6", required=true) @ApiParam(value="\u8fc7\u6ee4\u6761\u4ef6", required=true) QueryOlapDataParam parmas) {
        log.startWatch();
        log.info("query olap data start,modelNum:" + modelNum);
        try {
            if (StringUtils.isEmpty((CharSequence)modelNum)) {
                return CustomApiResult.fail((String)"001", (String)"modelNum is required.");
            }
            Long modelId = MemberReader.findModelIdByNum((String)modelNum);
            if (modelId == 0L) {
                return CustomApiResult.fail((String)"001", (String)"modelNum is not exists.");
            }
            if (!ModelPermHelper.hasModelPerm((long)modelId)) {
                return CustomApiResult.fail((String)"001", (String)ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u4f53\u7cfb\u4f7f\u7528\u6743\u9650\u3002", (String)"AbstractMsService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            QueryOlapDataDTO dto = new QueryOlapDataDTO();
            BeanUtils.copyProperties((Object)dto, (Object)parmas);
            ApiResultDTO result = OlapDataQueryHelper.queryData((String)modelNum, (QueryOlapDataDTO)dto);
            log.infoEnd("query olap data end,isSuccess:" + result.isSuccess());
            if (result.isSuccess()) {
                return CustomApiResult.success((Object)result.getData());
            }
            return CustomApiResult.fail((String)"002", (String)result.getMessage());
        }
        catch (Exception ex) {
            log.error("query olap data error." + ThrowableHelper.toString((Exception)ex));
            return CustomApiResult.fail((String)"003", (String)ex.getMessage());
        }
    }
}

