/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.webapi.extenddata.controller;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.ModelPermHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.webapi.extenddata.model.QueryExtendDataParam;

@ApiController(value="cm_extenddata", desc="\u62d3\u5c55\u7ef4\u6570\u636e")
@ApiMapping(value="extenddata")
public class QueryExtendDataController {
    @ApiPostMapping(value="/queryExtendDataData", desc="\u67e5\u8be2\u62d3\u5c55\u7ef4\u6570\u636e")
    public CustomApiResult<List<List<Object>>> queryExtendDataData(@ApiParam(value="\u67e5\u8be2\u4fe1\u606f", required=true) @ApiParam(value="\u67e5\u8be2\u4fe1\u606f", required=true) QueryExtendDataParam queryInfo) {
        try {
            CustomApiResult<List<List<Object>>> fail = QueryExtendDataController.checkParam(queryInfo);
            if (fail != null) {
                return fail;
            }
            EdQueryComInfo edQueryComInfo = new EdQueryComInfo(queryInfo.getShowNumber(), queryInfo.getExtGroup(), queryInfo.getDatamodel());
            queryInfo.getDimFilter().forEach((arg_0, arg_1) -> ((EdQueryComInfo)edQueryComInfo).addDimFilter(arg_0, arg_1));
            queryInfo.getFilter().forEach((arg_0, arg_1) -> ((EdQueryComInfo)edQueryComInfo).addFilter(arg_0, arg_1));
            edQueryComInfo.setDimselects(queryInfo.getDimselects());
            edQueryComInfo.setExtselects(queryInfo.getExtselects());
            edQueryComInfo.setParentOrg(queryInfo.getParentOrg());
            edQueryComInfo.setNeedSum(queryInfo.isNeedSum());
            EDResultSet rs = ExtDataServiceHelper.queryData((EdQueryComInfo)edQueryComInfo);
            ArrayList result = new ArrayList();
            rs.iteratorRows(row -> result.add(row.getValues()));
            return CustomApiResult.success(result);
        }
        catch (Exception ex) {
            return CustomApiResult.fail((String)"003", (String)ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)ex, (int)10));
        }
    }

    private static CustomApiResult<List<List<Object>>> checkParam(QueryExtendDataParam queryInfo) {
        long modelId;
        try {
            modelId = MemberReader.findModelIdByShowNum((String)queryInfo.getShowNumber());
        }
        catch (Exception ex) {
            return CustomApiResult.fail((String)"001", (String)"showNumber is not exists.");
        }
        if (modelId == 0L) {
            return CustomApiResult.fail((String)"001", (String)"showNumber is not exists.");
        }
        if (!ModelPermHelper.hasModelPerm((long)modelId)) {
            return CustomApiResult.fail((String)"002", (String)ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u4f53\u7cfb\u4f7f\u7528\u6743\u9650\u3002", (String)"AbstractMsService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!(queryInfo.getDimFilter().containsKey(DimTypesEnum.SCENARIO.getNumber()) && queryInfo.getDimFilter().containsKey(DimTypesEnum.YEAR.getNumber()) && queryInfo.getDimFilter().containsKey(DimTypesEnum.PERIOD.getNumber()) && queryInfo.getDimFilter().containsKey(DimTypesEnum.ENTITY.getNumber()) && queryInfo.getDimFilter().containsKey(DimTypesEnum.CURRENCY.getNumber()) && queryInfo.getDimFilter().containsKey(DimTypesEnum.PROCESS.getNumber()) && queryInfo.getDimFilter().containsKey(DimTypesEnum.AUDITTRIAL.getNumber()))) {
            return CustomApiResult.fail((String)"001", (String)"dimfilter is Incomplete.");
        }
        if (queryInfo.getDimFilter().get(DimTypesEnum.SCENARIO.getNumber()).length > 1 || queryInfo.getDimFilter().get(DimTypesEnum.YEAR.getNumber()).length > 1 || queryInfo.getDimFilter().get(DimTypesEnum.PERIOD.getNumber()).length > 1 || queryInfo.getDimFilter().get(DimTypesEnum.ENTITY.getNumber()).length > 1 || queryInfo.getDimFilter().get(DimTypesEnum.CURRENCY.getNumber()).length > 1 || queryInfo.getDimFilter().get(DimTypesEnum.PROCESS.getNumber()).length > 1 || queryInfo.getDimFilter().get(DimTypesEnum.AUDITTRIAL.getNumber()).length > 1) {
            return CustomApiResult.fail((String)"001", (String)"The number of dimfilter members exceeds the limit");
        }
        if (!MemberPermHelper.isModelAdmin((Long)modelId)) {
            long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)"Entity", (String)queryInfo.getDimFilter().get(DimTypesEnum.ENTITY.getNumber())[0]);
            if (!PermissionServiceImpl.getInstance((Long)modelId).hasWriteOrReadPerm(Long.valueOf(dimId), node.getId())) {
                return CustomApiResult.fail((String)"002", (String)String.format("Entity:%s don't have read or write permission.", node.getNumber()));
            }
        }
        return null;
    }
}

