/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.webapi.intergration.di.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.di.servicehelper.DIIntegrateServiceHelper;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;

@ApiController(value="didataintergration", desc="\u6570\u636e\u96c6\u6210\u5bf9\u5916\u63a5\u53e3")
@ApiMapping(value="didataintergration")
@ApiErrorCodes(value={@ApiErrorCode(code="002", desc="\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7"), @ApiErrorCode(code="004", desc="\u4e1a\u52a1\u6821\u9a8c\u4e0d\u901a\u8fc7"), @ApiErrorCode(code="006", desc="\u5df2\u5b8c\u6210\uff0c\u5b58\u5728\u5931\u8d25\u7684\u6267\u884c\u8bb0\u5f55"), @ApiErrorCode(code="007", desc="\u65e0\u53ef\u7528\u65b9\u6848"), @ApiErrorCode(code="008", desc="\u672a\u5b8c\u6210"), @ApiErrorCode(code="999", desc="\u5185\u90e8\u5f02\u5e38")})
public class DIDataIntergrationController {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DIDataIntergrationController.class);

    @ApiPostMapping(value="/start", desc="\u53d1\u8d77\u6570\u636e\u96c6\u6210")
    public CustomApiResult<Map<String, Object>> dataIntergration(@ApiParam(value="\u4f53\u7cfb\u5c55\u793a\u7f16\u7801", required=true) @ApiParam(value="\u4f53\u7cfb\u5c55\u793a\u7f16\u7801", required=true) String modelNum, @ApiParam(value="\u60c5\u666f\u7f16\u7801", required=true) @ApiParam(value="\u60c5\u666f\u7f16\u7801", required=true) String sceneNum, @ApiParam(value="\u8d22\u5e74\u7f16\u7801", required=true) @ApiParam(value="\u8d22\u5e74\u7f16\u7801", required=true) String yearNum, @ApiParam(value="\u671f\u95f4\u7f16\u7801", required=true) @ApiParam(value="\u671f\u95f4\u7f16\u7801", required=true) String periodNum, @ApiParam(value="\u5e01\u79cd\u7f16\u7801", required=true) @ApiParam(value="\u5e01\u79cd\u7f16\u7801", required=true) String currencyNum, @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801(\u62db\u5546\u5546\u8ba8\u65f6\u652f\u6301\u4e00\u4e2a\uff0c\u8bf7\u6682\u4f20\u4e00\u4e2a)", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801(\u62db\u5546\u5546\u8ba8\u65f6\u652f\u6301\u4e00\u4e2a\uff0c\u8bf7\u6682\u4f20\u4e00\u4e2a)", required=true) List<String> orgNums, @ApiParam(value="\u65b9\u6848\u7f16\u7801,\u4f20null\u6267\u884c\u4f53\u7cfb\u5185\u6240\u6709\u542f\u7528\u65b9\u6848", required=false) @ApiParam(value="\u65b9\u6848\u7f16\u7801,\u4f20null\u6267\u884c\u4f53\u7cfb\u5185\u6240\u6709\u542f\u7528\u65b9\u6848", required=false) List<String> schemeNums, @ApiParam(value="\u5907\u7528\u53c2\u6570\uff0c\u65b9\u4fbf\u540e\u671f\u5feb\u6377\u8c03\u6574", required=false) @ApiParam(value="\u5907\u7528\u53c2\u6570\uff0c\u65b9\u4fbf\u540e\u671f\u5feb\u6377\u8c03\u6574", required=false) Map<String, Object> paramMap) {
        log.info("DiDataIntergrationController-start,param is:" + modelNum + ";" + sceneNum + ";" + yearNum + ";" + periodNum + ";" + currencyNum + ";" + DIIntegrateServiceHelper.getJsonStr(orgNums) + ";" + schemeNums == null ? "null" : (DIIntegrateServiceHelper.getJsonStr(schemeNums) + ";" + paramMap == null ? "null" : DIIntegrateServiceHelper.getJsonStr(paramMap) + ";"));
        CustomApiResult car = new CustomApiResult();
        try {
            Long modelId = MemberReader.findModelIdByShowNum((String)modelNum);
            boolean isHasOpPermission = DIIntegrateServiceHelper.checkOpPermission((long)modelId, (String)"di_executejob", (String)"1T8/1A25NK8=");
            if (!isHasOpPermission) {
                car.setStatus(false);
                car.setErrorCode("002");
                car.setMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\uff01", (String)"MemberPermHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                return car;
            }
            Pair<Boolean, String> isHasOrgPermission = this.checkOrgPermission(modelId, orgNums);
            if (!((Boolean)isHasOrgPermission.p1).booleanValue()) {
                car.setStatus(false);
                car.setErrorCode("002");
                car.setMessage(String.format(ResManager.loadKDString((String)"\u4f60\u65e0%1$s\u5199\u5165\u6743\u9650", (String)"InvRelationSearchHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), isHasOrgPermission.p2));
                return car;
            }
            Pair<List<String>, List<String>> schemePair = this.removeUnableSchemeIds(modelId, schemeNums);
            if (CollectionUtil.isEmpty((Collection)((Collection)schemePair.p1))) {
                car.setStatus(false);
                car.setErrorCode("007");
                car.setMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u65b9\u6848\u3002", (String)"DIIntegrationNewServiceHelper_18", (String)"fi-bcm-business", (Object[])new Object[0]));
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("unableScheme", schemePair.p2);
                car.setData(dataMap);
                return car;
            }
            String orgNumStatus = this.checkPeriodStatus(modelId, sceneNum, yearNum, periodNum, orgNums);
            if (orgNumStatus != null) {
                car.setStatus(false);
                car.setErrorCode("004");
                car.setMessage(String.format(ResManager.loadKDString((String)"[%s]\u7ec4\u7ec7\u671f\u95f4\u672a\u5f00\u542f\u3002", (String)"DIIntegrationNewServiceHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]), orgNumStatus));
                return car;
            }
            String orgNum = this.checkIsSubmit(modelId, sceneNum, yearNum, periodNum, currencyNum, orgNums);
            if (orgNum != null) {
                car.setStatus(false);
                car.setErrorCode("004");
                car.setMessage(String.format(ResManager.loadKDString((String)"[%s]\u7ec4\u7ec7\u62a5\u8868\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u5df2\u63d0\u4ea4\u6216\u5df2\u5f52\u6863\u3002", (String)"DIIntegrationNewServiceHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]), orgNum));
                return car;
            }
            orgNum = this.checkScenVer(modelId, sceneNum, yearNum, periodNum, currencyNum, orgNums);
            if (orgNum != null) {
                car.setStatus(false);
                car.setErrorCode("004");
                car.setMessage(String.format(ResManager.loadKDString((String)"[%s]\u7ec4\u7ec7\u672a\u7248\u672c\u5316\uff0c\u4e0d\u80fd\u6267\u884c\u91c7\u96c6\u3002", (String)"DIIntegrationNewServiceHelper_23", (String)"fi-bcm-business", (Object[])new Object[0]), orgNum));
                return car;
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("unableScheme", schemePair.p2);
            car.setData(dataMap);
            Pair<Long, Map<String, Object>> mark = this.start(modelId, sceneNum, yearNum, periodNum, currencyNum, orgNums, (List)schemePair.p1, paramMap);
            dataMap.put("mark", mark.p1);
            dataMap.put("unableRecord", ((Map)mark.p2).get("unableRecord"));
            car.setStatus(true);
            log.info("DiDataIntergrationController-start res is:" + DIIntegrateServiceHelper.getJsonStr((Object)car));
            return car;
        }
        catch (Throwable e) {
            log.error("DiDataIntergrationController-start is error:", e);
            car.setStatus(false);
            car.setErrorCode("999");
            return car;
        }
    }

    private String checkScenVer(Long modelId, String sceneNum, String yearNum, String periodNum, String currencyNum, List<String> orgNums) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode scen = MemberReader.findScenaMemberByNum((String)modelNumber, (String)sceneNum);
        IDNumberTreeNode fy = MemberReader.findFyMemberByNum((String)modelNumber, (String)yearNum);
        IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)periodNum);
        for (String orgNum : orgNums) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberByNum((String)modelNumber, (String)orgNum);
            boolean isEnver = MergeControlHelper.isQuoteLocked((Long)modelId, (Long)scen.getId(), (Long)fy.getId(), (Long)period.getId(), (Long)entity.getBaseTreeNode().getId());
            if (!isEnver) continue;
            return orgNum;
        }
        return null;
    }

    private String checkPeriodStatus(Long modelId, String sceneNum, String yearNum, String periodNum, List<String> orgNums) {
        boolean periodManage = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012");
        if (periodManage) {
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode scen = MemberReader.findScenaMemberByNum((String)modelNumber, (String)sceneNum);
            IDNumberTreeNode fy = MemberReader.findFyMemberByNum((String)modelNumber, (String)yearNum);
            IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)periodNum);
            Set orgnumberset = orgNums.stream().collect(Collectors.toSet());
            Set periodOpenOrgSet = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)modelId, orgnumberset, (Long)scen.getId(), (Long)fy.getId(), (Long)period.getId(), (String)"datastatus");
            for (String orgNum : orgNums) {
                if (periodOpenOrgSet.contains(orgNum)) continue;
                return orgNum;
            }
        }
        return null;
    }

    private String checkIsSubmit(Long modelId, String sceneNum, String yearNum, String periodNum, String currencyNum, List<String> orgNums) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode scen = MemberReader.findScenaMemberByNum((String)modelNumber, (String)sceneNum);
        IDNumberTreeNode fy = MemberReader.findFyMemberByNum((String)modelNumber, (String)yearNum);
        IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)periodNum);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        HashMap<String, Long> orgNum2Id = new HashMap<String, Long>(16);
        for (String string : orgNums) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberByNum((String)modelNumber, (String)string);
            orgIds.add(entity.getBaseTreeNode().getId());
            orgNum2Id.put(string, entity.getBaseTreeNode().getId());
        }
        Set orgSet = IntegrationUtil.getMergeECFlowstatusOfOrgs((Long)modelId, (Long)scen.getId(), (Long)fy.getId(), (Long)period.getId(), (Long[])orgIds.toArray(new Long[0]));
        if ("EC".equals(currencyNum) || "DC".equals(currencyNum)) {
            for (String orgNum : orgNums) {
                if (!orgSet.contains(orgNum2Id.get(orgNum))) continue;
                return orgNum;
            }
        } else {
            Map map = DimensionServiceHelper.getCurrencyDynaByOrgIds((Long)modelId, (Long[])orgIds.toArray(new Long[0]));
            for (String orgNum : orgNums) {
                if (!orgSet.contains(orgNum2Id.get(orgNum)) || !currencyNum.equals(((Pair)map.get(orgNum2Id.get((Object)orgNum))).p2)) continue;
                return orgNum;
            }
        }
        return null;
    }

    @ApiPostMapping(value="/status", desc="\u67e5\u8be2\u6570\u636e\u96c6\u6210\u72b6\u6001")
    public CustomApiResult<List<String>> intergrationStatus(@ApiParam(value="\u6267\u884c\u6807\u8bc6", required=true) @ApiParam(value="\u6267\u884c\u6807\u8bc6", required=true) Long mark, @ApiParam(value="\u5907\u7528\u53c2\u6570\uff0c\u65b9\u4fbf\u540e\u671f\u5feb\u6377\u8c03\u6574", required=false) @ApiParam(value="\u5907\u7528\u53c2\u6570\uff0c\u65b9\u4fbf\u540e\u671f\u5feb\u6377\u8c03\u6574", required=false) Map<String, Object> paramMap) {
        QFilter markFilter = new QFilter("schedulelog", "=", (Object)mark);
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{"2", "8"});
        boolean exists = QueryServiceHelper.exists((String)"bcm_schedule_statuslog", (QFilter[])new QFilter[]{markFilter, statusFilter});
        CustomApiResult car = new CustomApiResult();
        car.setStatus(true);
        if (exists) {
            car.setStatus(false);
            car.setErrorCode("008");
            car.setMessage(ResManager.loadKDString((String)"\u672a\u5b8c\u6210\u3002", (String)"DIIntegrationNewServiceHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
            return car;
        }
        QFilter failFilter = new QFilter("status", "=", (Object)"4");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_schedule_statuslog", (String)"integrateexeclog.org.number, integrateexeclog.scheme.number", (QFilter[])new QFilter[]{markFilter, failFilter});
        if (CollectionUtil.isEmpty((Collection)query)) {
            return car;
        }
        ArrayList logList = new ArrayList(16);
        query.forEach(e -> logList.add(e.getString("integrateexeclog.org.number") + ";" + e.getString("integrateexeclog.scheme.number")));
        car.setStatus(false);
        car.setErrorCode("006");
        car.setMessage(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff0c\u5b58\u5728\u5931\u8d25\u7684\u6267\u884c\u8bb0\u5f55\u3002", (String)"DIIntegrationNewServiceHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]));
        car.setData(logList);
        return car;
    }

    private Pair<Long, Map<String, Object>> start(Long modelId, String sceneNum, String yearNum, String periodNum, String currencyNum, List<String> orgNums, List<String> schemeNums, Map<String, Object> paramMap) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode scen = MemberReader.findScenaMemberByNum((String)modelNumber, (String)sceneNum);
        IDNumberTreeNode fy = MemberReader.findFyMemberByNum((String)modelNumber, (String)yearNum);
        IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)periodNum);
        IDNumberTreeNode currency = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)currencyNum);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (String orgNum : orgNums) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberByNum((String)modelNumber, (String)orgNum);
            orgIds.add(entity.getBaseTreeNode().getId());
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter numberFilter = new QFilter("number", "in", schemeNums);
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id", (QFilter[])new QFilter[]{modelFilter, numberFilter});
        ArrayList schemeIds = new ArrayList(16);
        schemes.forEach(e -> schemeIds.add(e.getLong("id")));
        Long mark = GlobalIdUtil.genGlobalLongId();
        HashSet<String> tarCollectStatus = new HashSet<String>(16);
        tarCollectStatus.add(CollectStatusEnum.READY.getValue() + "");
        tarCollectStatus.add(CollectStatusEnum.SUCCESS.getValue() + "");
        tarCollectStatus.add(CollectStatusEnum.FAIL.getValue() + "");
        tarCollectStatus.add(CollectStatusEnum.COMPLETE.getValue() + "");
        String addParam = paramMap == null ? null : (String)paramMap.get("addParam");
        Map resMap = DIIntegrateServiceHelper.doCollect((Long)mark, (Long)modelId, orgIds, (Long)scen.getId(), (Long)fy.getId(), (Long)period.getId(), (Long)currency.getId(), schemeIds, tarCollectStatus, (String)addParam);
        return Pair.onePair((Object)mark, (Object)resMap);
    }

    private Pair<Boolean, String> checkOrgPermission(Long modelId, @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801(\u62db\u5546\u5546\u8ba8\u65f6\u652f\u6301\u4e00\u4e2a\uff0c\u8bf7\u6682\u4f20\u4e00\u4e2a)", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801(\u62db\u5546\u5546\u8ba8\u65f6\u652f\u6301\u4e00\u4e2a\uff0c\u8bf7\u6682\u4f20\u4e00\u4e2a)", required=true) List<String> orgs) {
        Long entityDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        for (String org : orgs) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberByNum((String)modelNumber, (String)org);
            if (PermissionServiceImpl.getInstance((Long)modelId).hasWritePerm(entityDimId, entity.getBaseTreeNode().getId())) continue;
            return Pair.onePair((Object)false, (Object)org);
        }
        return Pair.onePair((Object)true, null);
    }

    private Pair<List<String>, List<String>> removeUnableSchemeIds(Long modelId, List<String> schemeNums) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter enableFilter = new QFilter("status", "=", (Object)"1");
        QFilter catalogFilter = new QFilter("templatecatalog.type", "=", (Object)"2");
        if (CollectionUtil.isEmpty(schemeNums)) {
            DynamicObjectCollection schemeObj = QueryServiceHelper.query((String)"bcm_isscheme", (String)"number", (QFilter[])new QFilter[]{modelFilter, catalogFilter, enableFilter});
            ArrayList numberList = new ArrayList(16);
            schemeObj.forEach(e -> numberList.add(e.getString("number")));
            return Pair.onePair(numberList, null);
        }
        QFilter numberFilter = new QFilter("number", "in", schemeNums);
        DynamicObjectCollection schemeObj = QueryServiceHelper.query((String)"bcm_isscheme", (String)"number", (QFilter[])new QFilter[]{modelFilter, numberFilter, catalogFilter, enableFilter});
        ArrayList numberList = new ArrayList(16);
        schemeObj.forEach(e -> numberList.add(e.getString("number")));
        schemeNums.removeAll(numberList);
        return Pair.onePair(numberList, schemeNums);
    }
}

