/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.webapi.mergecontrol.controller;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.mergecontrol.MergeCondition;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.olap.verify.OlapDataVerifyServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ExtConvertServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.webapi.mergecontrol.model.CommonParam;
import kd.fi.bcm.webapi.mergecontrol.model.FlowOperateParam;
import kd.fi.bcm.webapi.mergecontrol.model.OperateParam;

@ApiController(value="cm_mergecontrol", desc="\u667a\u80fd\u5408\u5e76")
@ApiMapping(value="mergecontrol")
public class MergeController {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, MergeController.class);
    public static final String RESULT_CODE_MODEL_ERROR = "001";
    public static final String RESULT_CODE_AUTH_ERROR = "002";
    public static final String RESULT_CODE_PARAM_ERROR = "003";
    public static final String RESULT_CODE_BIS_ERROR = "004";
    public static final String RESULT_CODE_CHECKUP_ERROR = "005";
    public static final String RESULT_CODE_ERROR = "999";
    public static final String APP_ID = "cm";
    public static final String AUTH_COMMIT = "804f6478000000ac";
    public static final String AUTH_BACK = "4730fc9f000000ae";
    public static final String AUTH_CALCULATE = "4730fc9f000025ae";
    public static final String AUTH_CONVERT = "1G8TQAB22MU6";

    @ApiPostMapping(value="/flowOperate", desc="\u667a\u80fd\u5408\u5e76\u6d41\u7a0b\u63d0\u4ea4\u6216\u6253\u56de")
    @ApiErrorCodes(value={@ApiErrorCode(code="001", desc="\u4f53\u7cfb\u4e0d\u5b58\u5728"), @ApiErrorCode(code="002", desc="\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7"), @ApiErrorCode(code="003", desc="\u53c2\u6570\u4e0d\u6b63\u786e"), @ApiErrorCode(code="004", desc="\u4e1a\u52a1\u6821\u9a8c\u4e0d\u901a\u8fc7"), @ApiErrorCode(code="005", desc="\u52fe\u7a3d\u6821\u9a8c\u4e0d\u901a\u8fc7"), @ApiErrorCode(code="999", desc="\u5185\u90e8\u5f02\u5e38")})
    public CustomApiResult<Boolean> flowOperate(@ApiParam(value="\u6d41\u7a0b\u4fe1\u606f", required=true) @ApiParam(value="\u6d41\u7a0b\u4fe1\u606f", required=true) FlowOperateParam param) {
        log.startWatch();
        log.info("\u8c03\u7528\u667a\u80fd\u5408\u5e76\u6d41\u7a0b\u63d0\u4ea4\u6216\u6253\u56de\u63a5\u53e3\u7684\u53c2\u6570\uff1a" + param);
        long modelId = 0L;
        try {
            modelId = MemberReader.findModelIdByShowNum((String)param.getModelSNum());
        }
        catch (Exception ex) {
            return CustomApiResult.fail((String)RESULT_CODE_MODEL_ERROR, (String)String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"MergeFlowController_1", (String)"fi-bcm-webapi", (Object[])new Object[0]), param.getModelSNum()));
        }
        if (modelId == 0L) {
            return CustomApiResult.fail((String)RESULT_CODE_MODEL_ERROR, (String)String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"MergeFlowController_1", (String)"fi-bcm-webapi", (Object[])new Object[0]), param.getModelSNum()));
        }
        String failMsg = this.checkFlowParam(param);
        if (!StringUtils.isBlank((CharSequence)failMsg)) {
            return CustomApiResult.fail((String)RESULT_CODE_PARAM_ERROR, (String)failMsg);
        }
        String authFailMsg = this.checkFlowAuth(param);
        if (!StringUtils.isBlank((CharSequence)authFailMsg)) {
            return CustomApiResult.fail((String)RESULT_CODE_AUTH_ERROR, (String)authFailMsg);
        }
        try {
            MergeControlService mergeControlService = MergeControlService.getInstance();
            FixedItem fixedItem = this.createFixedItem(param);
            HashMap<String, Object> stageConditionMap = new HashMap<String, Object>(16);
            stageConditionMap.put("stepid", null);
            stageConditionMap.put("includeson", "1");
            stageConditionMap.put("stageoptype", param.getOperate());
            stageConditionMap.put("isApiCall", true);
            stageConditionMap.put("apiCallCurrency", param.getCurrencyNum());
            String currency = "PC";
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberByShowNum((String)param.getModelSNum()), (String)param.getOrgNum());
            if (param.getCurrencyNum().equals(orgNode.getCurrency())) {
                currency = "EC";
            }
            stageConditionMap.put("isEc", currency);
            stageConditionMap.put("isIgnoreOrgEffect", Boolean.TRUE);
            ResultBox resultBox = mergeControlService.stageOp(fixedItem, stageConditionMap);
            log.infoEnd("api\u8c03\u7528\u667a\u80fd\u5408\u5e76\u6d41\u7a0b\u63d0\u4ea4\u6216\u6253\u56de\u603b\u8017\u65f6\u3002");
            if (!resultBox.isSuccess()) {
                if (MergeMessage.NOT_CHECKUP.getCode().equals(resultBox.getCode())) {
                    return CustomApiResult.fail((String)RESULT_CODE_CHECKUP_ERROR, (String)resultBox.getMessageText());
                }
                return CustomApiResult.fail((String)RESULT_CODE_BIS_ERROR, (String)resultBox.getMessageText());
            }
        }
        catch (Exception e) {
            log.error("API\u8c03\u7528\u667a\u80fd\u5408\u5e76\u6d41\u7a0b\u63d0\u4ea4\u6216\u6253\u56de\u51fa\u9519\u3002", (Throwable)e);
            return CustomApiResult.fail((String)RESULT_CODE_ERROR, (String)e.getMessage());
        }
        return CustomApiResult.success((Object)true);
    }

    @ApiPostMapping(value="/calAndConvert", desc="\u62a5\u8868\u8ba1\u7b97\u6298\u7b97")
    @ApiErrorCodes(value={@ApiErrorCode(code="001", desc="\u4f53\u7cfb\u4e0d\u5b58\u5728"), @ApiErrorCode(code="002", desc="\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7"), @ApiErrorCode(code="003", desc="\u53c2\u6570\u4e0d\u6b63\u786e"), @ApiErrorCode(code="004", desc="\u4e1a\u52a1\u6821\u9a8c\u4e0d\u901a\u8fc7"), @ApiErrorCode(code="005", desc="\u52fe\u7a3d\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0cdata\u4e2d\u8fd4\u56de\u4e0d\u901a\u8fc7\u7684\u62a5\u544a\u7f16\u7801"), @ApiErrorCode(code="999", desc="\u5185\u90e8\u5f02\u5e38")})
    public CustomApiResult<Set<String>> calAndConvert(@ApiParam(value="\u8ba1\u7b97\u4fe1\u606f", required=true) @ApiParam(value="\u8ba1\u7b97\u4fe1\u606f", required=true) OperateParam param) {
        log.startWatch();
        log.info("\u8c03\u7528\u667a\u80fd\u5408\u5e76\u62a5\u8868\u8ba1\u7b97\u6298\u7b97\u63a5\u53e3\u7684\u53c2\u6570\uff1a" + param);
        long modelId = 0L;
        try {
            modelId = MemberReader.findModelIdByShowNum((String)param.getModelSNum());
        }
        catch (Exception ex) {
            return CustomApiResult.fail((String)RESULT_CODE_MODEL_ERROR, (String)String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"MergeFlowController_1", (String)"fi-bcm-webapi", (Object[])new Object[0]), param.getModelSNum()));
        }
        if (modelId == 0L) {
            return CustomApiResult.fail((String)RESULT_CODE_MODEL_ERROR, (String)String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"MergeFlowController_1", (String)"fi-bcm-webapi", (Object[])new Object[0]), param.getModelSNum()));
        }
        String failMsg = this.checkOperateParam(param);
        if (!StringUtils.isBlank((CharSequence)failMsg)) {
            return CustomApiResult.fail((String)RESULT_CODE_PARAM_ERROR, (String)failMsg);
        }
        String authFailMsg = this.checkOperateAuth(param);
        if (!StringUtils.isBlank((CharSequence)authFailMsg)) {
            return CustomApiResult.fail((String)RESULT_CODE_AUTH_ERROR, (String)authFailMsg);
        }
        try {
            Set<String> formulaNumbers;
            ExecuteContext ctx;
            FixedItem fixedItem = this.createFixedItem(param);
            SimpleItem orgItem = (SimpleItem)fixedItem.getOrgList().stream().findFirst().get();
            if (!OlapDataVerifyServiceHelper.checkPeriodOpenStatus((long)((Long)fixedItem.getModel().getId()), (String)fixedItem.getModel().getNumber(), (String)orgItem.getNumber(), (long)((Long)fixedItem.getScenario().getId()), (long)((Long)fixedItem.getFy().getId()), (long)((Long)fixedItem.getPeriod().getId()))) {
                return CustomApiResult.fail((String)RESULT_CODE_BIS_ERROR, (String)String.format(ResManager.loadKDString((String)"%s\u88ab\u8df3\u8fc7\u5904\u7406\uff1a\u6570\u636e\u671f\u95f4\u672a\u6253\u5f00\u3002", (String)"MergeController_8", (String)"fi-bcm-webapi", (Object[])new Object[0]), orgItem.getNumber()));
            }
            McStatus status = MergeStatusHelper.getMcStatusByCurrencyNumber((Long)fixedItem.getModelId(), (Long)fixedItem.getScenarioId(), (Long)fixedItem.getFyId(), (Long)fixedItem.getPeriodId(), (Long)((Long)orgItem.getId()), (String)param.getCurrencyNum());
            MergeCondition condition = new MergeCondition();
            String modelNum = MemberReader.findModelNumberByShowNum((String)param.getModelSNum());
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)param.getOrgNum());
            if (param.getCurrencyNum().equals(orgNode.getCurrency())) {
                if (status.getFlow().isSubmit()) {
                    return CustomApiResult.fail((String)RESULT_CODE_BIS_ERROR, (String)String.format(ResManager.loadKDString((String)"%1$s\u88ab\u8df3\u8fc7\u5904\u7406\uff1a\u9ed8\u8ba4\u5e01%2$s\u7684\u6d41\u7a0b\u5df2\u63d0\u4ea4\u3002", (String)"MergeController_9", (String)"fi-bcm-webapi", (Object[])new Object[0]), orgItem.getNumber(), param.getCurrencyNum()));
                }
                condition.setEcRuleCondition(2);
                ctx = MergeControlService.getInstance().fillExecuteContextForTask(fixedItem, condition);
                ctx.setOrg((SimpleItem)fixedItem.getOrgList().stream().findFirst().get());
                ctx.setSingleCalc(true);
                MergeControlService.getInstance().fillCtxProgressIdByLeafOrg(fixedItem, ctx, MergeTaskTypeEnum.Calculate.getCode());
                String reulst = MsServiceHelper.invokeMcCalculateService((String)ctx.toString());
                if (!StringUtils.isBlank((CharSequence)reulst)) {
                    log.error("api\u8c03\u7528\u62a5\u8868\u8ba1\u7b97\u6267\u884c\u5931\u8d25\u3002 param=" + param + ", result=" + reulst);
                    return CustomApiResult.fail((String)RESULT_CODE_BIS_ERROR, (String)ResManager.loadKDString((String)"\u62a5\u8868\u8ba1\u7b97\u6267\u884c\u5931\u8d25\u3002", (String)"MergeController_5", (String)"fi-bcm-webapi", (Object[])new Object[0]));
                }
            } else {
                if (status.getPcFlow().isSubmit()) {
                    return CustomApiResult.fail((String)RESULT_CODE_BIS_ERROR, (String)String.format(ResManager.loadKDString((String)"%1$s\u88ab\u8df3\u8fc7\u5904\u7406\uff1a\u6298\u7b97\u5e01%2$s\u7684\u6d41\u7a0b\u5df2\u63d0\u4ea4\u3002", (String)"MergeController_10", (String)"fi-bcm-webapi", (Object[])new Object[0]), orgItem.getNumber(), param.getCurrencyNum()));
                }
                condition.setPcRuleCondition(2);
                ctx = MergeControlService.getInstance().fillExecuteContextForTask(fixedItem, condition);
                ctx.setOrg((SimpleItem)fixedItem.getOrgList().stream().findFirst().get());
                ctx.setSingleCalc(true);
                ArrayList<Pair> convertPath = new ArrayList<Pair>(2);
                IDNumberTreeNode sourceNode = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)orgNode.getCurrency());
                convertPath.add(Pair.onePair((Object)sourceNode.getId(), (Object)sourceNode.getNumber()));
                IDNumberTreeNode targetNode = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)param.getCurrencyNum());
                convertPath.add(Pair.onePair((Object)targetNode.getId(), (Object)targetNode.getNumber()));
                ctx.setNowPaths(convertPath);
                StringBuilder errorMsg = new StringBuilder();
                ResultBox resultBox = ExtConvertServiceHelper.convertExtModels((ExecuteContext)ctx, (boolean)true);
                if (!resultBox.isSuccess()) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6298\u7b97\uff1a%s ", (String)"MergeController_1", (String)"fi-bcm-webapi", (Object[])new Object[0]), resultBox.getMessageText()));
                }
                MergeControlService.getInstance().fillCtxProgressIdByLeafOrg(fixedItem, ctx, MergeTaskTypeEnum.Convert.getCode());
                String error = MsServiceHelper.invokeMcConvertService((String)ctx.toString());
                if (!StringUtils.isBlank((CharSequence)error)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6298\u7b97\uff1a%s", (String)"MergeController_2", (String)"fi-bcm-webapi", (Object[])new Object[0]), error));
                }
                log.infoEnd("api\u8c03\u7528\u667a\u80fd\u5408\u5e76\u62a5\u8868\u8ba1\u7b97\u6298\u7b97\u63a5\u53e3\u603b\u8017\u65f6\u3002");
                if (errorMsg.length() > 0) {
                    return CustomApiResult.fail((String)RESULT_CODE_BIS_ERROR, (String)errorMsg.toString());
                }
            }
            if (!CollectionUtil.isEmpty(formulaNumbers = this.getCheckUpReport(fixedItem, param))) {
                CustomApiResult fail = CustomApiResult.fail((String)RESULT_CODE_CHECKUP_ERROR, (String)ResManager.loadKDString((String)"\u52fe\u7a3d\u6821\u9a8c\u4e0d\u901a\u8fc7", (String)"MergeController_6", (String)"fi-bcm-webapi", (Object[])new Object[0]));
                fail.setData(formulaNumbers);
                return fail;
            }
        }
        catch (Exception e) {
            log.error("API\u8c03\u7528\u62a5\u8868\u8ba1\u7b97\u6298\u7b97\u51fa\u9519\u3002", (Throwable)e);
            return CustomApiResult.fail((String)RESULT_CODE_ERROR, (String)e.getMessage());
        }
        return CustomApiResult.success(null);
    }

    private Set<String> getCheckUpReport(FixedItem fixedItem, OperateParam param) {
        IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberByShowNum((String)param.getModelSNum()), (String)param.getCurrencyNum());
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_chkreport", (String)"id, chkformula.number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)fixedItem.getModelId()), new QFilter("scenario", "=", (Object)fixedItem.getScenarioId()), new QFilter("org", "=", ((SimpleItem)fixedItem.getOrgList().stream().findFirst().get()).getId()), new QFilter("year", "=", (Object)fixedItem.getFyId()), new QFilter("period", "=", (Object)fixedItem.getPeriodId()), new QFilter("currency", "=", (Object)currencyNode.getId()), new QFilter("chkresulttype", "=", (Object)String.valueOf(ChkResultTypeEnum.UNPASS.getIndex()))});
        return reports.stream().map(e -> e.getString("chkformula.number")).collect(Collectors.toSet());
    }

    private FixedItem createFixedItem(CommonParam param) {
        long modelId = MemberReader.findModelIdByShowNum((String)param.getModelSNum());
        String modelCudeNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberByNum((String)modelCudeNum, (String)param.getSceneNum());
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)modelCudeNum, (String)param.getYearNum());
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelCudeNum, (String)param.getPeriodNum());
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelCudeNum, (String)param.getOrgNum());
        FixedItem fixedItem = FixedItem.newOne((SimpleItem)SimpleItem.newOne((Object)modelId, (String)modelCudeNum), (SimpleItem)SimpleItem.newOne((Object)sceneNode.getId(), (String)sceneNode.getNumber()), (SimpleItem)SimpleItem.newOne((Object)yearNode.getId(), (String)yearNode.getNumber()), (SimpleItem)SimpleItem.newOne((Object)periodNode.getId(), (String)periodNode.getNumber()));
        fixedItem.setOrgList((List)Lists.newArrayList((Object[])new SimpleItem[]{SimpleItem.newOne((Object)orgNode.getId(), (String)orgNode.getNumber())}));
        return fixedItem;
    }

    private String checkFlowParam(FlowOperateParam param) {
        String result = this.checkCommonParam(param);
        if (!StringUtils.isBlank((CharSequence)result)) {
            return result;
        }
        String modelCudeNum = MemberReader.findModelNumberByShowNum((String)param.getModelSNum());
        IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberByNum((String)modelCudeNum, (String)param.getCurrencyNum());
        if (IDNumberTreeNode.NotFoundTreeNode == currencyNode) {
            return String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u5e01\u79cd\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"MergeFlowController_6", (String)"fi-bcm-webapi", (Object[])new Object[0]), param.getCurrencyNum());
        }
        if ("EC".equalsIgnoreCase(param.getCurrencyNum()) || "PC".equalsIgnoreCase(param.getCurrencyNum()) || "DC".equalsIgnoreCase(param.getCurrencyNum())) {
            return ResManager.loadKDString((String)"\u5e01\u79cd\u7f16\u7801\u5fc5\u987b\u662f\u660e\u786e\u7684\u7f16\u7801\uff0c\u4e0d\u80fd\u662fEC\u3001PC\u6216\u8005DC", (String)"MergeFlowController_8", (String)"fi-bcm-webapi", (Object[])new Object[0]);
        }
        StageOpTypeEnum typeEnum = StageOpTypeEnum.getEnumByCode((String)param.getOperate());
        if (StageOpTypeEnum.COMMIT != typeEnum && StageOpTypeEnum.BACK != typeEnum) {
            return ResManager.loadKDString((String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u586b\u201cC\u201d\uff08\u63d0\u4ea4\uff09\u6216\u8005\u201cH\u201d\uff08\u6253\u56de\uff09\u3002", (String)"MergeFlowController_9", (String)"fi-bcm-webapi", (Object[])new Object[0]);
        }
        return null;
    }

    private String checkOperateParam(OperateParam param) {
        String result = this.checkCommonParam(param);
        if (!StringUtils.isBlank((CharSequence)result)) {
            return result;
        }
        String modelCudeNum = MemberReader.findModelNumberByShowNum((String)param.getModelSNum());
        IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberByNum((String)modelCudeNum, (String)param.getCurrencyNum());
        if (IDNumberTreeNode.NotFoundTreeNode == currencyNode) {
            return String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u5e01\u79cd\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"MergeFlowController_6", (String)"fi-bcm-webapi", (Object[])new Object[0]), param.getCurrencyNum());
        }
        if ("EC".equalsIgnoreCase(param.getCurrencyNum()) || "PC".equalsIgnoreCase(param.getCurrencyNum()) || "DC".equalsIgnoreCase(param.getCurrencyNum())) {
            return ResManager.loadKDString((String)"\u5e01\u79cd\u7f16\u7801\u5fc5\u987b\u662f\u660e\u786e\u7684\u7f16\u7801\uff0c\u4e0d\u80fd\u662fEC\u3001PC\u6216\u8005DC", (String)"MergeFlowController_8", (String)"fi-bcm-webapi", (Object[])new Object[0]);
        }
        return null;
    }

    private String checkCommonParam(CommonParam param) {
        long modelId = MemberReader.findModelIdByShowNum((String)param.getModelSNum());
        if (StringUtils.isBlank((CharSequence)param.getSceneNum()) || StringUtils.isBlank((CharSequence)param.getYearNum()) || StringUtils.isBlank((CharSequence)param.getPeriodNum()) || param.getOrgNum() == null) {
            return ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MergeFlowController_2", (String)"fi-bcm-webapi", (Object[])new Object[0]);
        }
        String modelCudeNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberByNum((String)modelCudeNum, (String)param.getSceneNum());
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)modelCudeNum, (String)param.getYearNum());
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelCudeNum, (String)param.getPeriodNum());
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelCudeNum, (String)param.getOrgNum());
        if (IDNumberTreeNode.NotFoundTreeNode == sceneNode) {
            return String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u60c5\u666f\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"MergeFlowController_3", (String)"fi-bcm-webapi", (Object[])new Object[0]), param.getSceneNum());
        }
        if (IDNumberTreeNode.NotFoundTreeNode == yearNode) {
            return String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u8d22\u5e74\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"MergeFlowController_4", (String)"fi-bcm-webapi", (Object[])new Object[0]), param.getYearNum());
        }
        if (IDNumberTreeNode.NotFoundTreeNode == periodNode) {
            return String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u671f\u95f4\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"MergeFlowController_5", (String)"fi-bcm-webapi", (Object[])new Object[0]), param.getPeriodNum());
        }
        if (IDNumberTreeNode.NotFoundTreeNode == orgNode) {
            return String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"MergeFlowController_7", (String)"fi-bcm-webapi", (Object[])new Object[0]), param.getOrgNum());
        }
        return null;
    }

    private String checkFlowAuth(FlowOperateParam param) {
        long modelId = MemberReader.findModelIdByShowNum((String)param.getModelSNum());
        if (!MemberPermHelper.isModelAdmin((Long)modelId)) {
            String result = this.checkCommonAuth(param);
            if (!StringUtils.isBlank((CharSequence)result)) {
                return result;
            }
            StageOpTypeEnum typeEnum = StageOpTypeEnum.getEnumByCode((String)param.getOperate());
            String authItem = StageOpTypeEnum.COMMIT == typeEnum ? AUTH_COMMIT : AUTH_BACK;
            int auth = BcmBasePluginUtil.checkPermission((long)LongUtil.toLong((Object)RequestContext.get().getCurrUserId()), (long)modelId, (String)AppMetadataCache.getAppInfo((String)APP_ID).getId(), (String)"bcm_mergecontrollist", (String)authItem);
            if (auth == 0) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u201c%s\u201d\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"MergeFlowController_11", (String)"fi-bcm-webapi", (Object[])new Object[0]), typeEnum.getText());
            }
        }
        return null;
    }

    private String checkOperateAuth(OperateParam param) {
        long modelId = MemberReader.findModelIdByShowNum((String)param.getModelSNum());
        if (!MemberPermHelper.isModelAdmin((Long)modelId)) {
            int auth;
            String result = this.checkCommonAuth(param);
            if (!StringUtils.isBlank((CharSequence)result)) {
                return result;
            }
            String authItem = AUTH_CALCULATE;
            String action = ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u8ba1\u7b97", (String)"MergeController_3", (String)"fi-bcm-webapi", (Object[])new Object[0]);
            String modelNum = MemberReader.findModelNumberByShowNum((String)param.getModelSNum());
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)param.getOrgNum());
            if (!param.getCurrencyNum().equals(orgNode.getCurrency())) {
                authItem = AUTH_CONVERT;
                action = ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6298\u7b97", (String)"MergeController_4", (String)"fi-bcm-webapi", (Object[])new Object[0]);
            }
            if ((auth = BcmBasePluginUtil.checkPermission((long)LongUtil.toLong((Object)RequestContext.get().getCurrUserId()), (long)modelId, (String)AppMetadataCache.getAppInfo((String)APP_ID).getId(), (String)"bcm_mergecontrollist", (String)authItem)) == 0) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u201c%s\u201d\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"MergeFlowController_11", (String)"fi-bcm-webapi", (Object[])new Object[0]), action);
            }
        }
        return null;
    }

    private String checkCommonAuth(CommonParam param) {
        long modelId = MemberReader.findModelIdByShowNum((String)param.getModelSNum());
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermDimObjResult permission = PermissionServiceHelper.getUserHasPermDimObjs((long)currUserId, (String)"bcm_model");
        List usePerm = permission.getHasPermDimObjs();
        if (!permission.hasAllDimObjPerm() && !usePerm.contains(modelId)) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4f53\u7cfb\u7684\u4f7f\u7528\u6743\u3002", (String)"MergeController_7", (String)"fi-bcm-webapi", (Object[])new Object[0]);
        }
        long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)param.getOrgNum());
        if (!PermissionServiceImpl.getInstance((Long)modelId).hasWritePerm(Long.valueOf(dimId), orgNode.getId())) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ec4\u7ec7\u201c%s\u201d\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"MergeFlowController_10", (String)"fi-bcm-webapi", (Object[])new Object[0]), orgNode.getNumber());
        }
        return null;
    }
}

