/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.webapi.report.controller;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.report.floatreport.CTMOTService;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.webapi.report.model.ReportDataQueryParam;
import kd.fi.bcm.webapi.report.model.ReportQueryResult;

@ApiController(value="report", desc="\u62a5\u8868\u7ba1\u7406")
@ApiMapping(value="report")
public class ReportDataQueryController {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ReportDataQueryController.class);

    @ApiPostMapping(value="/queryReportData", desc="\u67e5\u8be2\u62a5\u8868\u6570\u636e")
    public CustomApiResult<List<ReportQueryResult>> getReportData(@ApiParam(value="\u67e5\u8be2\u62a5\u8868\u6570\u636eAPI\u53c2\u6570", required=true) @ApiParam(value="\u67e5\u8be2\u62a5\u8868\u6570\u636eAPI\u53c2\u6570", required=true) ReportDataQueryParam param) {
        ArrayList<ReportQueryResult> results = new ArrayList<ReportQueryResult>(16);
        long modelId = MemberReader.findModelIdByShowNum((String)param.getModelNum());
        String modelNum = MemberReader.findModelNumberByShowNum((String)param.getModelNum());
        IDNumberTreeNode scene = MemberReader.findScenaMemberByNum((String)modelNum, (String)param.getSceneNum());
        IDNumberTreeNode year = MemberReader.findFyMemberByNum((String)modelNum, (String)param.getYear());
        IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)modelNum, (String)param.getPeriod());
        if (param.getDim2Mems() == null) {
            param.setDim2Mems(new HashMap<String, String>(16));
        }
        param.getDim2Mems().put(DimTypesEnum.SCENARIO.getNumber(), scene.getNumber());
        param.getDim2Mems().put(DimTypesEnum.YEAR.getNumber(), year.getNumber());
        param.getDim2Mems().put(DimTypesEnum.PERIOD.getNumber(), period.getNumber());
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter tempFilter = new QFilter("number", "in", param.getTmps());
        tempFilter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        DynamicObjectCollection tempDoc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{modelFilter, tempFilter});
        Set tmpIds = tempDoc.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        Map source2Right = TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)year.getId(), (Long)period.getId(), tmpIds, (boolean)true);
        QFilter orgFilter = new QFilter("number", "in", param.getOrgs());
        orgFilter.and("storagetype", "=", (Object)StorageTypeEnum.STORAGE.index);
        DynamicObjectCollection orgDoc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{modelFilter, orgFilter});
        List orgIds = orgDoc.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        List orgNodes = MemberReader.getSomeNodeByDimNum((String)DimTypesEnum.ENTITY.getNumber(), (String)modelNum, orgIds);
        for (IDNumberTreeNode orgNode : orgNodes) {
            for (Long tmpId : source2Right.values()) {
                results.add(ReportDataQueryController.getTemplateData(param, modelId, orgNode, tmpId));
            }
        }
        return CustomApiResult.success(results);
    }

    private static ReportQueryResult getTemplateData(ReportDataQueryParam param, long modelId, IDNumberTreeNode orgNode, Long tmpId) {
        Map<String, String> dim2Mems = param.getDim2Mems();
        dim2Mems.put(DimTypesEnum.ENTITY.getNumber(), orgNode.getNumber());
        Pair sm2TmpModel = CTMOTService.getAndInitSpread((Long)tmpId, dim2Mems);
        String modelNum = MemberReader.findModelNumberByShowNum((String)param.getModelNum());
        CTMOTService.autoFloat((String)modelNum, (long)modelId, (boolean)false, (long)orgNode.getId(), (String)orgNode.getNumber(), (SpreadManager)((SpreadManager)sm2TmpModel.p1), (TemplateModel)((TemplateModel)sm2TmpModel.p2));
        List commonDims = ((SpreadManager)sm2TmpModel.p1).getFilter().getCommonFilterDimNums();
        List commonDimMembs = ((SpreadManager)sm2TmpModel.p1).getFilter().getCommonFilterDimMembNums();
        Sheet sheet = ((SpreadManager)sm2TmpModel.p1).getBook().getSheet(0);
        ArrayList<ReportQueryResult.PositionDataInfo> areaInfos = new ArrayList<ReportQueryResult.PositionDataInfo>(16);
        for (PositionInfo posInfo : ((SpreadManager)sm2TmpModel.p1).getAreaManager().getPostionInfoSet()) {
            ColumnDimDomain colDimDoman;
            ReportQueryResult.PositionDataInfo posDataInfo = new ReportQueryResult.PositionDataInfo(posInfo.getAreaRange());
            ArrayList<List<Object>> datas = new ArrayList<List<Object>>(16);
            if (posInfo.getExtendInfo() != null) {
                posDataInfo.setExtModel(posInfo.getExtendInfo().getExtModelNumber());
                posDataInfo.setExtendDims(posInfo.getExtendInfo().getCols(posInfo.getExtendInfo().isShowDataSourceOrg()));
                RangeModel rangeModel = new RangeModel(posInfo.getAreaRange());
                for (int i = rangeModel.getY_start(); i <= rangeModel.getY_end(); ++i) {
                    ArrayList<Object> data = new ArrayList<Object>(16);
                    List row = sheet.getRow(i, true);
                    for (Cell cell : row) {
                        if (cell.getCol() > rangeModel.getX_end() || cell.getCol() < rangeModel.getX_start()) continue;
                        data.add(cell.getValue());
                    }
                    datas.add(data);
                }
                posDataInfo.setDatas(datas);
                areaInfos.add(posDataInfo);
                continue;
            }
            ArrayList<String> metaDims = new ArrayList<String>(16);
            metaDims.addAll(commonDims);
            RowDimDomain rowDimDoman = ((SpreadManager)sm2TmpModel.p1).getAreaManager().getRowDimDoman(posInfo);
            if (rowDimDoman != null) {
                metaDims.addAll(rowDimDoman.getDimensions().stream().map(m -> m.getNumber()).collect(Collectors.toList()));
            }
            if ((colDimDoman = ((SpreadManager)sm2TmpModel.p1).getAreaManager().getColDimDomain(posInfo)) != null) {
                metaDims.addAll(colDimDoman.getDimensions().stream().map(m -> m.getNumber()).collect(Collectors.toList()));
            }
            posDataInfo.setDims(metaDims);
            RangeModel rangeModel = new RangeModel(posInfo.getAreaRange());
            sheet.iteratorRangeCells(rangeModel.getY_start(), rangeModel.getY_end(), rangeModel.getX_start(), rangeModel.getX_end(), c -> {
                if (c.isMdDataDomain()) {
                    ArrayList<Object> data = new ArrayList<Object>(16);
                    List rcls = c.getNotNullMemberUserObject().stream().map(m -> m.getNumber()).collect(Collectors.toList());
                    data.addAll(commonDimMembs);
                    data.addAll(rcls);
                    data.add(c.getValue());
                    datas.add(data);
                }
            });
            posDataInfo.setDatas(datas);
            areaInfos.add(posDataInfo);
        }
        ReportQueryResult queryResult = new ReportQueryResult();
        queryResult.setTempNum(((TemplateModel)sm2TmpModel.p2).getNumber());
        queryResult.setAreaInfos(areaInfos);
        return queryResult;
    }

    public static void testAPIOperation() {
        ReportDataQueryParam param = new ReportDataQueryParam();
        param.setModelNum("LOK_2023");
        param.setSceneNum("MRpt");
        param.setYear("FY2023");
        param.setPeriod("M_M01");
        param.setCurrency("CNY");
        ArrayList orgs = Lists.newArrayList((Object[])new String[]{"root", "BCM2022"});
        param.setOrgs(orgs);
        ArrayList tmps = Lists.newArrayList((Object[])new String[]{"BS", "CF"});
        param.setTmps(tmps);
        HashMap<String, String> dim2Membs = new HashMap<String, String>(16);
        dim2Membs.put(DimTypesEnum.PROCESS.getNumber(), "EIRpt");
        dim2Membs.put(DimTypesEnum.AUDITTRIAL.getNumber(), "ATTotal");
        param.setDim2Mems(dim2Membs);
        ReportDataQueryController controller = new ReportDataQueryController();
        controller.getReportData(param);
    }
}

