/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.webapi.report.export;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.fi.bcm.business.export.util.ExportUtils;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.report.NewReportMultiExportService;
import kd.fi.bcm.formplugin.report.ReportMultiExportService;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import kd.fi.bcm.webapi.dimension.controller.DimensionController;
import kd.fi.bcm.webapi.report.model.ReportExportParam;
import kd.fi.bcm.webapi.report.model.ReportExportResult;

@ApiController(value="report", desc="\u62a5\u8868\u7ba1\u7406")
@ApiMapping(value="report")
public class ReportExportController {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DimensionController.class);

    @ApiPostMapping(value="/exportReport", desc="\u5bfc\u51fa\u62a5\u8868")
    public CustomApiResult<List<ReportExportResult>> getReportFile(@ApiParam(value="\u62a5\u8868\u5bfc\u51faAPI\u53c2\u6570", required=true) @ApiParam(value="\u62a5\u8868\u5bfc\u51faAPI\u53c2\u6570", required=true) ReportExportParam param) {
        ReportMultiExportService service = this.getExportService(param);
        service.initService();
        service.doExport_Excels();
        HashMap fileNameMap = service.getFileNm2UrlMap();
        ArrayList<ReportExportResult> results = new ArrayList<ReportExportResult>(16);
        for (Map.Entry entry : fileNameMap.entrySet()) {
            ReportExportResult result = new ReportExportResult((String)entry.getValue(), (String)entry.getKey());
            results.add(result);
        }
        return CustomApiResult.success(results);
    }

    public ReportMultiExportService getExportService(ReportExportParam param) {
        NewReportMultiExportService service = new NewReportMultiExportService();
        this.buildService((ReportMultiExportService)service, param);
        return service;
    }

    public void buildService(ReportMultiExportService service, ReportExportParam param) {
        service.setKeepSomeSetting(false);
        String modelShowNum = param.getModelNum();
        String modelNum = MemberReader.findModelNumberByShowNum((String)modelShowNum);
        long modelId = MemberReader.findModelIdByShowNum((String)modelShowNum);
        String atNum = param.getDim2Mems().get(DimTypesEnum.AUDITTRIAL.getNumber());
        DynamicObject atDy = ExportUtils.getMemberDy((long)modelId, (String)atNum, (String)"bcm_audittrialmembertree");
        HashMap<String, DynamicObject> auditMap = new HashMap<String, DynamicObject>(16);
        auditMap.put(atNum, atDy);
        service.setAuditMap(auditMap);
        service.setAudittrial(atDy);
        service.setCube(modelNum);
        service.setCyNumber2Dy(ExportUtils.getModelCyDys((long)modelId));
        String cyNum = param.getCurrency();
        DynamicObject cyDy = (DynamicObject)service.getCyNumber2Dy().get(cyNum);
        service.setCyObj_view(cyDy);
        service.setViewDataunit(1);
        service.setExcelfiletype("0");
        service.setSchemeName("");
        service.setFileruleStr("yearname_periodname_orgnumber");
        service.setFiletxt("");
        service.setFloat(false);
        String fyNum = param.getYear();
        String periodNum = param.getPeriod();
        DynamicObject fyDy = ExportUtils.getMemberDy((long)modelId, (String)fyNum, (String)"bcm_fymembertree");
        DynamicObject periodDy = ExportUtils.getMemberDy((long)modelId, (String)periodNum, (String)"bcm_periodmembertree");
        FYPeriodPair fyPeriodPair = new FYPeriodPair(fyNum + "|" + periodNum, fyDy, periodDy);
        service.setFyPeriodPairs((List)Lists.newArrayList((Object[])new FYPeriodPair[]{fyPeriodPair}));
        service.setModelId(modelId);
        String bpNum = param.getDim2Mems().get(DimTypesEnum.PROCESS.getNumber());
        DynamicObject bpDy = ExportUtils.getMemberDy((long)modelId, (String)bpNum, (String)"bcm_processmembertree");
        HashMap<String, DynamicObject> bpMap = new HashMap<String, DynamicObject>(16);
        bpMap.put(bpNum, bpDy);
        service.setProcess(bpDy);
        service.setProcessMap(bpMap);
        service.setReport(false);
        service.setSaveByDim(false);
        service.setScale(-1);
        service.setScaleStr("");
        String sceneNum = param.getSceneNum();
        DynamicObject sceneDy = ExportUtils.getMemberDy((long)modelId, (String)sceneNum, (String)"bcm_scenemembertree");
        service.setScene(sceneDy);
        service.setScene_view(sceneDy);
        service.setCslscheme_view(null);
        service.setSheetruleStr("reportname");
        service.setSheettxt("");
        service.setUnweave(true);
        service.setReportStatus((List)Lists.newArrayList((Object[])new String[]{"B", "C", "D", "E"}));
        service.setStartYear(fyDy);
        service.setStartPeriod(periodDy);
        service.setEndYear(fyDy);
        service.setEndPeriod(periodDy);
        service.setFilterEfftiveOrg(false);
        DynamicObjectCollection tempDoc = ExportUtils.getTempDoc(param.getTmps(), (long)modelId);
        service.setTempDoc(tempDoc);
        DynamicObjectCollection orgDoc = ExportUtils.getOrgDoc(param.getOrgs(), (long)modelId);
        service.setOrgDoc(orgDoc);
        service.setPageSourceEnum(ExportPageSourceEnum.DEFAULT);
        service.setSchemeId(Long.valueOf(0L));
        service.setPackDownload(false);
        service.setSourcestyle("1");
        service.setFloatdispay("1");
        service.setFiletype("3");
        service.setCsl(false);
        Map dimNum2Items = ExportUtils.getDimNum2Items(param.getDim2Mems(), (long)modelId);
        service.setDimNum2Items(dimNum2Items);
        service.setZipFileName(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u6587\u4ef6%s", (String)"ExportServiceConstructor_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())));
        service.setrNumbers(param.getTmps());
    }

    public static String getKey(HashMap<String, String> map, String value) {
        String mapKey = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            mapKey = entry.getKey();
        }
        return mapKey;
    }

    public void testAPIOperation() {
        ReportExportController controller = new ReportExportController();
        ReportExportParam param = new ReportExportParam();
        param.setModelNum("LOK_2023");
        param.setSceneNum("MRpt");
        param.setYear("FY2023");
        param.setPeriod("M_M01");
        param.setCurrency("HKD");
        param.setOrgs(Lists.newArrayList((Object[])new String[]{"BCM2022", "root"}));
        param.setTmps(Lists.newArrayList((Object[])new String[]{"BS", "CF", "PL"}));
        HashMap<String, String> dim2Mems = new HashMap<String, String>(16);
        dim2Mems.put(DimTypesEnum.PROCESS.getNumber(), "ERpt");
        dim2Mems.put(DimTypesEnum.AUDITTRIAL.getNumber(), "EntityInput");
        dim2Mems.put(DimTypesEnum.MULTIGAAP.getNumber(), "MGNone");
        dim2Mems.put("ZDY1", "BP-000617");
        param.setDim2Mems(dim2Mems);
        CustomApiResult<List<ReportExportResult>> results = controller.getReportFile(param);
    }
}

