/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.webapi.report.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.ModelPermHelper;
import kd.fi.bcm.business.template.model.ReportEditStatus;
import kd.fi.bcm.business.template.model.RightVersionTemplateParams;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.exception.CheckBusinessFailedException;
import kd.fi.bcm.common.exception.CheckPermFailedException;
import kd.fi.bcm.common.exception.ModelNotExitException;
import kd.fi.bcm.common.exception.ParamInvalidException;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.report.util.ReportRecordUtil;
import kd.fi.bcm.webapi.report.model.ReportStatusParam;
import kd.fi.bcm.webapi.report.model.ReportStatusResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportService {
    private static final Map<String, String> itemPermMap = MapInitHelper.ofMap((Object)ReportStatusEnum.WEAVING.status(), (Object)"4730fc9f000022ae", (Object)ReportStatusEnum.COMPLETE.status(), (Object)"4730fc9f000021ae", (Object)ReportStatusEnum.COMMIT.status(), (Object)"4730fc9f000023ae", (Object)ReportStatusEnum.BACK.status(), (Object)"4730fc9f000000ae");

    public void validateParam(ReportStatusParam param) throws Throwable {
        if (StringUtils.isEmpty((CharSequence)param.getModelSNum())) {
            throw new ParamInvalidException("modelSNum is required.");
        }
        long modelId = MemberReader.findModelIdByShowNum((String)param.getModelSNum());
        if (modelId == 0L) {
            throw new ModelNotExitException("modelSNum is invalid.");
        }
        if (!ModelPermHelper.hasModelPerm((long)modelId)) {
            throw new CheckPermFailedException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u4f53\u7cfb\u4f7f\u7528\u6743\u9650\u3002", (String)"AbstractMsService_1", (String)"fi-bcm-webapi", (Object[])new Object[0]));
        }
        String modelNum = MemberReader.findModelNumberByShowNum((String)param.getModelSNum());
        this.validateSingleParam(modelNum, param.getSceneNum(), DimTypesEnum.SCENARIO.getNumber(), "sceneNum");
        this.validateSingleParam(modelNum, param.getYearNum(), DimTypesEnum.YEAR.getNumber(), "yearNum");
        this.validateSingleParam(modelNum, param.getPeriodNum(), DimTypesEnum.PERIOD.getNumber(), "periodNum");
        this.validateSingleParam(modelNum, param.getCurrencyNum(), DimTypesEnum.CURRENCY.getNumber(), "currencyNum");
        this.validateSingleParam(modelNum, param.getOrgNum(), DimTypesEnum.ENTITY.getNumber(), "orgNum");
        if (StringUtils.isEmpty((CharSequence)param.getOperate())) {
            throw new ParamInvalidException(" operate is required.");
        }
        String permId = itemPermMap.get(param.getOperate());
        if (StringUtils.isEmpty((CharSequence)permId)) {
            throw new ParamInvalidException(" operate is invalid.");
        }
        this.checkItemPerm(modelId, permId);
    }

    private void validateSingleParam(String modelNum, String memNum, String dimNum, String paramName) throws Throwable {
        if (StringUtils.isEmpty((CharSequence)memNum)) {
            throw new ParamInvalidException(String.format("%s is required.", paramName));
        }
        IDNumberTreeNode treeNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNum, (String)memNum);
        if (treeNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new ParamInvalidException(String.format("%s is invalid.", paramName));
        }
        if (DimTypesEnum.ENTITY.getNumber().equals(dimNum) && !PermissionServiceImpl.getInstance((Long)treeNode.getModelId()).hasWritePerm(treeNode.getDimId(), treeNode.getId())) {
            throw new CheckPermFailedException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u7ec4\u7ec7\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"AbstractMsService_3", (String)"fi-bcm-webapi", (Object[])new Object[0]));
        }
    }

    private void checkItemPerm(long modelId, String permId) throws Throwable {
        if (MemberPermHelper.isModelManager((Long)modelId)) {
            return;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_model", (String)"reporttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        if (dynamicObject != null) {
            ApplicationTypeEnum appEnum = ApplicationTypeEnum.getEnumByIndex((String)dynamicObject.getString("reporttype"));
            if (ApplicationTypeEnum.CM == appEnum || ApplicationTypeEnum.RPT == appEnum) {
                if (0 == BcmBasePluginUtil.checkPermission((long)LongUtil.toLong((Object)RequestContext.get().getUserId()), (long)modelId, (String)AppMetadataCache.getAppInfo((String)appEnum.getAppnum()).getId(), (String)"bcm_report_list", (String)permId)) {
                    throw new CheckPermFailedException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\uff01", (String)"AbstractMsService_4", (String)"fi-bcm-webapi", (Object[])new Object[0]));
                }
            } else {
                throw new ParamInvalidException(ResManager.loadKDString((String)"\u4f53\u7cfb\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u53ea\u80fd\u5904\u7406\u8d22\u52a1\u62a5\u8868\u548c\u5408\u5e76\u62a5\u8868\u7684\u4f53\u7cfb\u3002", (String)"AbstractMsService_2", (String)"fi-bcm-webapi", (Object[])new Object[0]));
            }
        }
    }

    public ReportStatusResponse updateReportStatus(ReportStatusParam param) throws Throwable {
        ReportStatusResponse response = new ReportStatusResponse();
        Map result = ReportRecordUtil.executeReportStatusToEPM(this.packParamMap(param));
        if (MapUtils.isNotEmpty((Map)result)) {
            response.setSuccessReports((Set)result.get("successReports"));
            response.setFailReports((Set)result.get("failReports"));
            response.setCheckChkFailReports((Set)result.get("checkCHKFailReports"));
            List messages = (List)result.get("message");
            if (CollectionUtils.isNotEmpty((Collection)messages)) {
                response.setErrorMessage(messages.toString());
            }
            ReportRecordUtil.batchWriteLogs((long)MemberReader.findModelIdByShowNum((String)param.getModelSNum()), (Map)result, (boolean)false);
        }
        return response;
    }

    private Map<String, Object> packParamMap(ReportStatusParam param) throws Throwable {
        List templates;
        ReportEditStatus editStatus;
        long modelId = MemberReader.findModelIdByShowNum((String)param.getModelSNum());
        String modelNum = MemberReader.findModelNumberByShowNum((String)param.getModelSNum());
        long fyId = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.YEAR.getNumber(), (String)param.getYearNum()).getId();
        long scenarId = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.SCENARIO.getNumber(), (String)param.getSceneNum()).getId();
        long periodId = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.PERIOD.getNumber(), (String)param.getPeriodNum()).getId();
        IDNumberTreeNode node = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (String)param.getOrgNum());
        String currNum = param.getCurrencyNum();
        long orgId = node.getCopyfromId() != 0L ? node.getCopyfromId() : node.getId();
        long currencyId = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.CURRENCY.getNumber(), (String)currNum).getId();
        String cslscheme = (String)node.getProperty("cslscheme");
        DynamicObject one = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)cslscheme).and("model", "=", (Object)modelId)});
        long schemeId = one.getLong("id");
        RightVersionTemplateParams rightVersionTemplateParams = new RightVersionTemplateParams(modelId, scenarId, fyId, periodId, currencyId, true);
        rightVersionTemplateParams.setOrgIds(Collections.singleton(orgId));
        Map reportEditStatusMap = TemplateUtil.getCommitReportCount((RightVersionTemplateParams)rightVersionTemplateParams);
        if (MapUtils.isNotEmpty((Map)reportEditStatusMap) && (editStatus = (ReportEditStatus)reportEditStatusMap.get(orgId)) != null && CollectionUtils.isNotEmpty((Collection)(templates = editStatus.getAllTemplates()))) {
            HashMap templateReports = new HashMap(16);
            templates.forEach(id -> templateReports.put(Long.toString(id), id));
            Map paramForEPM = ReportRecordUtil.getReportParamForEPM((long)modelId, (long)fyId, (long)scenarId, (long)periodId, (long)currencyId, (long)orgId, (long)schemeId, templateReports, (boolean)param.isSkipChk());
            paramForEPM.put("Status", param.getOperate());
            return paramForEPM;
        }
        throw new CheckBusinessFailedException(ResManager.loadKDString((String)"\u65e0\u53ef\u64cd\u4f5c\u7684\u62a5\u8868\u3002", (String)"AbstractMsService_5", (String)"fi-bcm-webapi", (Object[])new Object[0]));
    }
}

