/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.webapi.taskmanage.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.webapi.taskmanage.model.TaskRecord;
import kd.fi.bcm.webapi.taskmanage.model.TaskRecordQueryParam;
import kd.fi.bcm.webapi.taskmanage.model.TaskRecordResult;

@ApiController(value="taskmanage", desc="\u4efb\u52a1\u7ba1\u7406API")
@ApiMapping(value="taskmanage")
public class TaskManageController {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, TaskManageController.class);

    @ApiPostMapping(value="/getTask", desc="\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b")
    public CustomApiResult<TaskRecordResult> getTask(@ApiParam(value="\u4efb\u52a1\u5b9e\u4f8b\u67e5\u8be2\u53c2\u6570", required=true) @ApiParam(value="\u4efb\u52a1\u5b9e\u4f8b\u67e5\u8be2\u53c2\u6570", required=true) TaskRecordQueryParam param) {
        log.startWatch();
        log.info("getTask api start,params:" + param);
        try {
            if (null == param.getBeginDate()) {
                return CustomApiResult.fail((String)"cm.100001", (String)"beginDate is null");
            }
            Tuple recordList = TaskRecordServiceHelper.queryTaskRecordByApi((Date)param.getBeginDate(), (Date)param.getEndDate(), (Integer)param.getPageIndex(), (Integer)param.getPageSize());
            TaskRecordResult data = new TaskRecordResult();
            ArrayList<TaskRecord> tasks = new ArrayList<TaskRecord>(((List)recordList.p1).size());
            for (TaskRecordModel recordModel : (List)recordList.p1) {
                TaskRecord bean = new TaskRecord();
                bean.setTaskId(recordModel.getId());
                bean.setTaskName(recordModel.getTaskTemplateModel().getName());
                bean.setTaskBeginTime(recordModel.getBeginTime());
                bean.setTaskEndTime(recordModel.getEndTime());
                Map filterMemberMap = recordModel.getFilterMemberInfo(true);
                bean.setScenarioName(this.getMemberName(filterMemberMap, SysDimensionEnum.Scenario));
                bean.setYearName(this.getMemberName(filterMemberMap, SysDimensionEnum.Year));
                bean.setPeriodName(this.getMemberName(filterMemberMap, SysDimensionEnum.Period));
                tasks.add(bean);
            }
            data.setTasks(tasks);
            data.setTotalSize((Integer)recordList.p2);
            data.setTotalPage((Integer)recordList.p3);
            log.infoEnd("getTask api end,task size:" + tasks.size());
            return CustomApiResult.success((Object)data);
        }
        catch (Exception ex) {
            log.error("getTask api error." + ThrowableHelper.toString((Exception)ex));
            return CustomApiResult.fail((String)"cm.100002", (String)ThrowableHelper.toString((Exception)ex));
        }
    }

    private String getMemberName(Map<String, Tuple<Long, String, String>> filterMemberMap, SysDimensionEnum dimensionEnum) {
        Tuple<Long, String, String> t = filterMemberMap.get(dimensionEnum.getNumber());
        return null != t ? (String)t.p3 : null;
    }
}

