/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common;

import java.util.Objects;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.common.StringUtils;

public class CustOperationContexts {
    public static final String CONTEXT_FORM_INTEGRATE = "custoc_integrate";
    public static final String CONTEXT_FORM_EPM = "custoc_epm";
    public static final String CONTEXT_FORM_MAN_REPORT = "cust_man_report";

    public static void setCustFormIdForIntegrate() {
        CustOperationContexts.setCustFormId(CONTEXT_FORM_INTEGRATE, false);
    }

    public static void setCustFormIdForEPM() {
        CustOperationContexts.setCustFormId(CONTEXT_FORM_EPM, false);
    }

    public static void setCustFormIdForManReport() {
        CustOperationContexts.setCustFormId(CONTEXT_FORM_MAN_REPORT, false);
    }

    private static void setCustFormId(String custFormId, boolean isForce) {
        OperationContext oc = OperationContext.get();
        if (Objects.isNull(oc)) {
            oc = new OperationContext();
            OperationContext.set((OperationContext)oc);
        }
        if (StringUtils.isEmpty(oc.getFormId()) || !oc.getFormId().startsWith("bcm_")) {
            oc.setFormId(custFormId);
        } else if (isForce) {
            oc.setFormId(custFormId);
        }
    }

    public static String decideTargetFormId(OperationContext context) {
        if (Objects.isNull(context)) {
            return "";
        }
        String targetFormId = context.getFormId();
        String report = ResManager.getLocaleString((String)"\u62a5\u8868\u7f16\u5236", (String)"CustOperationContexts_0", (String)"fi-bcm-common").getLocaleValue_zh_CN();
        if ("bcm_cslreportprocess".equals(context.getFormId()) && context.getFormName().contains(report)) {
            targetFormId = CONTEXT_FORM_MAN_REPORT;
        }
        return targetFormId;
    }
}

