/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.context.OperationContext;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.orm.util.ReflectionUtils;
import kd.epm.epbs.business.log.IOlapOpTarget;
import kd.epm.epbs.business.log.IOlapOpType;
import kd.epm.epbs.business.log.audit.OlapAuditServiceHelper;
import kd.epm.epbs.business.log.trace.BaseOlapOpTarget;
import kd.epm.epbs.business.log.trace.BaseOlapOpType;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import kd.fi.bcm.common.auditlog.ESClient;
import kd.fi.bcm.common.auditlog.LogESHelper;
import kd.fi.bcm.common.cache.MemberReader;

public class OlapEnhancementHelper {
    private static final Log LOG = LogFactory.getLog(OlapEnhancementHelper.class);
    private static Boolean isSupportAudit = null;
    private static Method commandInfoPropSetter = null;
    private static final CacheConfigInfo CUBE_AUDIT_CACHE;
    private static Cache<String, Boolean> CUBE_AUDIT_ENABLE_CACHE;

    public static void enhanceOlapCommandWithAudit(String cube, String operationType, CommandInfo commandInfo) {
        Objects.requireNonNull(commandInfo, "parameter commandInfo can not be null");
        OlapEnhancementHelper.setTraceOpInfo();
        if (Boolean.TRUE.equals(isSupportAudit)) {
            OlapAuditServiceHelper.enhanceCommandWithAudit((Long)MemberReader.findModelIdByNum(cube), (String)cube, (Collection)Lists.newArrayList((Object[])new CommandInfo[]{commandInfo}));
        }
    }

    public static void enhanceOlapCommandWithAudit(String cube, String operationType, Collection<CommandInfo> commandInfos) {
        if (commandInfos == null) {
            throw new IllegalArgumentException("parameter commandInfo can not be null");
        }
        OlapEnhancementHelper.setTraceOpInfo();
        if (Boolean.TRUE.equals(isSupportAudit)) {
            OlapAuditServiceHelper.enhanceCommandWithAudit((Long)MemberReader.findModelIdByNum(cube), (String)cube, commandInfos);
        }
    }

    public static void setTraceOpInfo() {
        OperationContext context = OperationContext.get();
        String formId = Objects.nonNull(context) ? context.getFormId() : "";
        String operationType = LogESHelper.getOperateType(formId);
        OlapTraceServiceHelper.setTraceOpInfo((IOlapOpType)new BaseOlapOpType(operationType), (IOlapOpTarget)new BaseOlapOpTarget(formId));
    }

    private static Map<String, String> setExtendProp(String eventId, String dataIndexName) {
        HashMap<String, String> extendProps = new HashMap<String, String>(4);
        extendProps.put("eventId", eventId);
        extendProps.put("auditIndex", dataIndexName);
        Map<String, String> configMap = ESClient.getServerConfig("audit");
        String httpport = configMap.get("httpport");
        String port = httpport == null ? configMap.get("port") : httpport;
        extendProps.put("audit.ip", configMap.get("ip"));
        extendProps.put("audit.port", port);
        extendProps.put("audit.username", configMap.get("username"));
        extendProps.put("audit.password", Encrypters.decode((String)configMap.get("password")));
        extendProps.put("audit.batchSize", configMap.get("batchSize"));
        LOG.info("auditIndex: {}, ip: {},  port: {},  username: {},  batchSize: {}", new Object[]{dataIndexName, configMap.get("ip"), port, configMap.get("username"), configMap.get("batchSize")});
        return extendProps;
    }

    private static void setExtendPropOnCommand(CommandInfo command, Map<String, String> extendProps) {
        try {
            commandInfoPropSetter.invoke((Object)command, extendProps);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new KDBizException(new ErrorCode("olap.command.setExtProperties", e.getMessage()), new Object[]{e});
        }
    }

    public static boolean isCubeEnableAudit(String cube) {
        try {
            return OlapAuditServiceHelper.isOpenAudit((Long)MemberReader.findModelIdByNum(cube));
        }
        catch (Exception e) {
            LOG.error("check cube is audit enable error: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void updateCubeEnableAudit(String cube, Boolean isEnableAuditLog) {
        CUBE_AUDIT_ENABLE_CACHE.put((Object)cube, (Object)isEnableAuditLog);
    }

    static {
        try {
            commandInfoPropSetter = CommandInfo.class.getDeclaredMethod("setExtProperties", Map.class);
            ReflectionUtils.makeAccessible((Method)commandInfoPropSetter);
            isSupportAudit = true;
        }
        catch (NoSuchMethodException e) {
            isSupportAudit = false;
        }
        LOG.info("OLAP_Client supports audit log: " + isSupportAudit);
        CUBE_AUDIT_CACHE = new CacheConfigInfo();
        CUBE_AUDIT_CACHE.setTimeout(2);
        CUBE_AUDIT_CACHE.setMaxMemSize(100000);
        CUBE_AUDIT_ENABLE_CACHE = CacheBuilder.newBuilder().recordStats().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    }
}

