/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.adjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustDimensionEntry;
import kd.fi.bcm.common.adjust.AdjustOperationUtils;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.adjust.IAdjust;
import kd.fi.bcm.common.adjust.IAdjustEntry;
import kd.fi.bcm.common.adjust.IAdjustHead;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.util.CollectionUtil;

public class AdjustBuilder<T extends IAdjustHead> {
    private List<IAdjustHead> list = new ArrayList<IAdjustHead>(10);
    private IAdjustHead current;
    private Map<String, Integer> groupSeqMap = new HashMap<String, Integer>(16);
    private long modelId;
    private long scenarioId;
    private long periodId;
    private long yearId;
    private List<Consumer<IAdjustHead>> afterHandler;
    private Function<Integer, String[]> codeRuleFunc;
    private Supplier<IAdjustHead> supplier;
    private Map<Long, String> dimMap;

    public AdjustBuilder(long modelId, long scenarioId, long yearId, long periodId, Supplier supplier) {
        this.modelId = modelId;
        this.scenarioId = scenarioId;
        this.periodId = periodId;
        this.yearId = yearId;
        this.supplier = supplier;
    }

    public AdjustBuilder addSingleAdjustAfterHandler(Consumer<IAdjustHead> consumer) {
        if (this.afterHandler == null) {
            this.afterHandler = new ArrayList<Consumer<IAdjustHead>>(16);
        }
        this.afterHandler.add(consumer);
        return this;
    }

    public AdjustBuilder next() {
        this.current = null;
        return this;
    }

    public AdjustBuilder newAdjustHead(Consumer<IAdjustHead> consumer) {
        this.newAdjustHead();
        consumer.accept(this.current);
        return this;
    }

    public IAdjustHead newAdjustHead() {
        this.excuteAfterHandler();
        this.groupSeqMap.clear();
        this.current = this.supplier.get();
        this.initAdjustInfo(this.current);
        this.list.add(this.current);
        return this.current;
    }

    private void excuteAfterHandler() {
        if (!CollectionUtil.isEmpty(this.afterHandler) && this.current != null) {
            this.afterHandler.forEach(handler -> handler.accept(this.current));
        }
    }

    public AdjustBuilder initDimPageLayout(Collection<AdjustDimensionEntry> pageLayouts) {
        for (AdjustDimensionEntry pageLayout : pageLayouts) {
            if (pageLayout.isSpread()) {
                this.current.addSpreadMemberDim(pageLayout.getDimId(), pageLayout.getSeq());
                continue;
            }
            this.current.addCommonPageMemberDim(pageLayout.getDimId(), pageLayout.getMemeberId(), pageLayout.getSeq());
        }
        return this;
    }

    public AdjustBuilder initDimPageLayout() {
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"bcm_dimension", (String)"shortnumber,id,dseq,membermodel,issysdimension,name,number,fieldmapped", (QFilter[])new QFilter("model", "=", (Object)this.modelId).toArray(), (String)"dseq");
        String dimNumber = null;
        for (DynamicObject dim : dimensions) {
            dimNumber = dim.getString("number");
            if (DimTypesEnum.SCENARIO.getNumber().equals(dimNumber) || DimTypesEnum.YEAR.getNumber().equals(dimNumber) || DimTypesEnum.PERIOD.getNumber().equals(dimNumber)) {
                this.current.addCommonPageMemberDim(dim.getLong("id"), (Long)this.current.get(dimNumber.toLowerCase(Locale.ENGLISH)), dim.getInt("dseq"));
                continue;
            }
            if (DimTypesEnum.CURRENCY.getNumber().equals(dimNumber)) {
                String currencyNum;
                String string = currencyNum = "RAdj".equals(this.current.getProcess()) ? "DC" : "EC";
                IDNumberTreeNode node = MemberReader.findCurrencyMemberByNum(MemberReader.findModelNumberById(this.modelId), currencyNum);
                if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
                this.current.addCommonPageMemberDim(dim.getLong("id"), node.getId(), dim.getInt("dseq"));
                continue;
            }
            if (DimTypesEnum.PROCESS.getNumber().equals(dimNumber)) {
                IDNumberTreeNode processNode = MemberReader.findProcessMemberByNum(MemberReader.findModelNumberById(this.modelId), this.current.getProcess());
                this.current.addCommonPageMemberDim(dim.getLong("id"), processNode.getId(), dim.getInt("dseq"));
                continue;
            }
            this.current.addSpreadMemberDim(dim.getLong("id"), dim.getInt("dseq"));
        }
        return this;
    }

    private void initAdjustInfo(IAdjust iAdjust) {
        iAdjust.setModelId(this.modelId);
        iAdjust.setPeriodId(this.periodId);
        iAdjust.setScenarioId(this.scenarioId);
        iAdjust.setYearId(this.yearId);
    }

    private Map<Long, String> dims() {
        if (this.dimMap == null) {
            this.dimMap = (Map)ThreadCache.get((Object)("dims." + this.modelId), () -> {
                HashMap dimMapTpm = new HashMap(16);
                QueryServiceHelper.query((String)"bcm_dimension", (String)"shortnumber,id,dseq,membermodel,issysdimension,name,number,fieldmapped", (QFilter[])new QFilter("model", "=", (Object)this.modelId).toArray(), (String)"dseq").forEach(e -> {
                    if (e.getBoolean("issysdimension")) {
                        dimMapTpm.put(e.getLong("id"), e.getString("number").toLowerCase());
                    } else {
                        dimMapTpm.put(e.getLong("id"), e.getString("fieldmapped").toLowerCase());
                    }
                });
                return dimMapTpm;
            });
        }
        return this.dimMap;
    }

    public IAdjustEntry addEntry(String groupNum) {
        if (this.current == null) {
            this.newAdjustHead();
        }
        Integer seq = this.groupSeqMap.getOrDefault(groupNum, 1);
        this.groupSeqMap.put(groupNum, seq + 1);
        IAdjustEntry iAdjustEntry = this.current.newEntry();
        iAdjustEntry.setAdjust(this.current);
        iAdjustEntry.set("groupnum", groupNum);
        iAdjustEntry.set("isdefaultcurrency", "1");
        iAdjustEntry.set("differ", 0.0);
        iAdjustEntry.set("dseq", seq);
        this.initAdjustInfo(iAdjustEntry);
        this.current.getPageLayoutDim(false).forEach(e -> iAdjustEntry.set(this.dims().get(e.getDimId()), e.getMemeberId()));
        return iAdjustEntry;
    }

    public AdjustBuilder addEntry(String groupNum, BiConsumer<IAdjustHead, IAdjustEntry> consumer) {
        IAdjustEntry iAdjustEntry = this.addEntry(groupNum);
        consumer.accept(this.current, iAdjustEntry);
        BigDecimal debit = iAdjustEntry.getDebit() == null ? BigDecimal.ZERO : iAdjustEntry.getDebit();
        BigDecimal crebit = iAdjustEntry.getCredit() == null ? BigDecimal.ZERO : iAdjustEntry.getCredit();
        iAdjustEntry.set("summoney", AdjustOperationUtils.handleSummoney(debit, crebit));
        IDNumberTreeNode entity = MemberReader.findEntityMemberById(this.modelId, iAdjustEntry.getEntity());
        if (OrgRelaProcessMembPool.isRelaProcess(this.current.getProcess())) {
            iAdjustEntry.set("merge", this.current.getEntity());
            IDNumberTreeNode mergeNode = MemberReader.findEntityMemberById(this.modelId, this.current.getEntity());
            iAdjustEntry.set("olaporg", AdjustBuilder.getParentDirectChild(mergeNode.getNumber(), entity.getLongNumber()));
            if (this.current.isMultiplecurrency().booleanValue() && (iAdjustEntry.get("cvtbeforedebit") == null && iAdjustEntry.get("cvtbeforecredit") == null || BigDecimal.ZERO.equals(iAdjustEntry.get("cvtbeforecredit")) && BigDecimal.ZERO.equals(iAdjustEntry.get("cvtbeforedebit")))) {
                iAdjustEntry.set("cvtbeforedebit", iAdjustEntry.get("debit"));
                iAdjustEntry.set("cvtbeforecredit", iAdjustEntry.get("credit"));
                iAdjustEntry.set("cvtbeforesummoney", iAdjustEntry.get("summoney"));
                iAdjustEntry.set("debit", null);
                iAdjustEntry.set("credit", null);
                iAdjustEntry.set("summoney", null);
            }
        } else {
            iAdjustEntry.set("olaporg", entity.getNumber());
        }
        return this;
    }

    private static String getParentDirectChild(String pNumber, String childLongNumber) {
        if (!StringUtils.isEmpty((String)pNumber) && !StringUtils.isEmpty((String)childLongNumber)) {
            String[] spr = childLongNumber.split("!");
            for (int i = 0; i < spr.length; ++i) {
                if (!spr[i].equals(pNumber) || i == spr.length - 1) continue;
                return pNumber + "_" + spr[i + 1];
            }
        }
        return null;
    }

    public AdjustBuilder setCodeRuleFunc(Function<Integer, String[]> codeRuleFunc) {
        this.codeRuleFunc = codeRuleFunc;
        return this;
    }

    private String[] generateAdjustNumber() {
        if (this.codeRuleFunc == null) {
            ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
            dy.set("createtime", (Object)TimeServiceHelper.now());
            return service.getBatchNumber("bcm_rptadjust", dy, null, this.list.size());
        }
        return this.codeRuleFunc.apply(this.list.size());
    }

    private void beforeBuild() {
        this.excuteAfterHandler();
        long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        String[] number = this.generateAdjustNumber();
        int i = 0;
        for (IAdjustHead adjustHead : this.list) {
            if (adjustHead.getEntrys().isEmpty()) continue;
            adjustHead.setNumber(number[i++]);
            adjustHead.set("creator", userId);
            adjustHead.set("createtime", now);
            adjustHead.set("modifier", userId);
            adjustHead.set("modifytime", now);
            if (RptAdjustStatusEnum.COMMIT.status() == adjustHead.getStatus()) {
                adjustHead.set("submitter", userId);
                adjustHead.set("submittime", now);
                continue;
            }
            if (RptAdjustStatusEnum.AUDIT.status() == adjustHead.getStatus()) {
                adjustHead.set("reviewer", userId);
                adjustHead.set("reviewtime", now);
                continue;
            }
            if (RptAdjustStatusEnum.RATIFY.status() != adjustHead.getStatus()) continue;
            adjustHead.set("ratifier", userId);
            adjustHead.set("ratifytime", now);
        }
    }

    public List<Object> build() {
        this.beforeBuild();
        return this.list.stream().map(e -> e.getData()).collect(Collectors.toList());
    }

    public Pair<Collection<DynamicObject>, Map<Long, Collection<DynamicObject>>> buildDynamic() {
        this.beforeBuild();
        HashMap datas = new HashMap(16);
        ArrayList heads = new ArrayList(this.list.size());
        for (IAdjustHead adjustHead : this.list) {
            if (adjustHead.getEntrys().isEmpty()) continue;
            Pair<DynamicObject, Collection<DynamicObject>> p = adjustHead.genDynamic();
            AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)p.p1, (Collection)p.p2, true);
            datas.put(adjustHead.getId(), p.p2);
            heads.add(p.p1);
        }
        return Pair.onePair(heads, datas);
    }

    public IAdjustHead getCurrent() {
        return this.current;
    }
}

